/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.jpdl.model.EsbElement;

public class EsbInputOutputConfigurationComposite
implements SelectionListener,
FocusListener,
MouseListener {
    public static int INPUT_CONFIGURATION = 0;
    public static int OUTPUT_CONFIGURATION = 1;
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private int type;
    private Table table;
    private TableEditor editor;
    private Text text;
    private Button addButton;
    private Button removeButton;
    int selectedColumn = -1;
    private EsbElement esbElement;
    private InputOutputConfigurationStrategy[] configurationStrategies = new InputOutputConfigurationStrategy[]{new InputOutputConfigurationStrategy(){

        public void addElement(GenericElement element) {
            EsbInputOutputConfigurationComposite.this.esbElement.addJbpmToEsbMapping(element);
        }

        public String[] columnHeaders() {
            return new String[]{"jBPM Name", "ESB Name"};
        }

        public int esbColumnIndex() {
            return 1;
        }

        public int jbpmColumnIndex() {
            return 0;
        }

        public void removeElement(GenericElement element) {
            EsbInputOutputConfigurationComposite.this.esbElement.removeJbpmToEsbMapping(element);
        }

        public GenericElement[] getMappings() {
            return EsbInputOutputConfigurationComposite.this.esbElement.getJbpmToEsbMappings();
        }
    }, new InputOutputConfigurationStrategy(){

        public void addElement(GenericElement element) {
            EsbInputOutputConfigurationComposite.this.esbElement.addEsbToJbpmMapping(element);
        }

        public String[] columnHeaders() {
            return new String[]{"ESB Name", "jBPM Name"};
        }

        public int esbColumnIndex() {
            return 0;
        }

        public int jbpmColumnIndex() {
            return 1;
        }

        public void removeElement(GenericElement element) {
            EsbInputOutputConfigurationComposite.this.esbElement.removeEsbToJbpmMapping(element);
        }

        public GenericElement[] getMappings() {
            return EsbInputOutputConfigurationComposite.this.esbElement.getEsbToJbpmMappings();
        }
    }};

    public static EsbInputOutputConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent, int type) {
        if (type != 0 && type != 1) {
            throw new RuntimeException("The type should be 0 or 1");
        }
        EsbInputOutputConfigurationComposite result = new EsbInputOutputConfigurationComposite();
        result.type = type;
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    private EsbInputOutputConfigurationComposite() {
    }

    public void setEsbElement(EsbElement esbElement) {
        if (this.esbElement == esbElement) {
            return;
        }
        this.unhookSelectionListener();
        this.clearControls();
        this.esbElement = esbElement;
        if (esbElement != null) {
            this.updateControls();
            this.hookSelectionListener();
        }
    }

    private void hookSelectionListener() {
        this.addButton.addSelectionListener((SelectionListener)this);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.table.addSelectionListener((SelectionListener)this);
        this.table.addMouseListener((MouseListener)this);
    }

    private void unhookSelectionListener() {
        this.addButton.removeSelectionListener((SelectionListener)this);
        this.removeButton.removeSelectionListener((SelectionListener)this);
        this.table.removeSelectionListener((SelectionListener)this);
        this.table.removeMouseListener((MouseListener)this);
    }

    private void clearControls() {
        this.addButton.setEnabled(true);
        this.removeButton.setEnabled(false);
        this.table.removeAll();
    }

    private void updateControls() {
        GenericElement[] elements = this.getMappings();
        int i = 0;
        while (i < elements.length) {
            TableItem item = new TableItem(this.table, 0);
            item.setData((Object)elements[i]);
            item.setText(this.jbpmColumnIndex(), this.getAttribute("bpm", elements[i]));
            item.setText(this.esbColumnIndex(), this.getAttribute("esb", elements[i]));
            ++i;
        }
    }

    private String getAttribute(String name, GenericElement element) {
        String result = (String)element.getGenericAttibutes().get(name);
        return result == null ? "" : result;
    }

    private void create() {
        this.table = this.widgetFactory.createTable(this.parent, 66048);
        this.addButton = this.widgetFactory.createButton(this.parent, "Add", 8);
        this.removeButton = this.widgetFactory.createButton(this.parent, "Remove", 8);
        this.table.setLayoutData((Object)this.createTableLayoutData());
        this.addButton.setLayoutData((Object)this.createAddButtonLayoutData());
        this.removeButton.setLayoutData((Object)this.createRemoveButtonLayoutData());
        this.initTable();
        this.createEditor();
    }

    private void createEditor() {
        this.editor = new TableEditor(this.table);
        this.text = new Text((Composite)this.table, 0);
        this.text.setVisible(false);
        this.text.setText("");
        this.editor.minimumWidth = this.text.getSize().x;
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
    }

    private void initTable() {
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableLayout handlerConfigBeanTableLayout = new TableLayout();
        handlerConfigBeanTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        handlerConfigBeanTableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50));
        this.table.setLayout((Layout)handlerConfigBeanTableLayout);
        TableColumn jbpmNameColumn = new TableColumn(this.table, 0);
        jbpmNameColumn.setText(this.columnHeaders()[0]);
        TableColumn esbNameColumn = new TableColumn(this.table, 0);
        esbNameColumn.setText(this.columnHeaders()[1]);
    }

    private FormData createAddButtonLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 0);
        result.right = new FormAttachment(100, 0);
        result.left = new FormAttachment((Control)this.removeButton, 0);
        result.left.alignment = 16384;
        return result;
    }

    private FormData createRemoveButtonLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.addButton, 0);
        result.right = new FormAttachment(100, 0);
        return result;
    }

    private FormData createTableLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 0);
        result.left = new FormAttachment(0, 0);
        result.bottom = new FormAttachment(100, 0);
        result.right = new FormAttachment((Control)this.removeButton, 0);
        return result;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.addButton) {
            this.handleAddButtonSelected();
        } else if (e.widget == this.removeButton) {
            this.handleRemoveButtonSelected();
        } else if (e.widget == this.table) {
            this.handleTableRowSelected();
        }
    }

    private void handleAddButtonSelected() {
        GenericElement element = (GenericElement)this.esbElement.getFactory().createById("org.jbpm.gd.jpdl.genericElement");
        element.setName("mapping");
        this.addElement(element);
        TableItem item = new TableItem(this.table, 0);
        item.setText(this.jbpmColumnIndex(), this.getNextName("bpm", this.jbpmColumnIndex()));
        item.setText(this.esbColumnIndex(), this.getNextName("esb", this.esbColumnIndex()));
        element.addGenericAttribute("bpm", item.getText(this.jbpmColumnIndex()));
        element.addGenericAttribute("esb", item.getText(this.esbColumnIndex()));
        item.setData((Object)element);
        this.table.setSelection(item);
    }

    private String getNextName(String kind, int pos) {
        int runner = 1;
        while (true) {
            boolean goodCandidate = true;
            String candidate = String.valueOf(kind) + "Name" + runner;
            TableItem[] items = this.table.getItems();
            int i = 0;
            while (i < items.length) {
                if (candidate.equals(items[i].getText(pos))) {
                    goodCandidate = false;
                }
                ++i;
            }
            if (goodCandidate) {
                return candidate;
            }
            ++runner;
        }
    }

    private void handleRemoveButtonSelected() {
        int i = this.table.getSelectionIndex();
        if (i == -1) {
            return;
        }
        TableItem item = this.table.getItem(i);
        this.removeElement((GenericElement)item.getData());
        this.table.remove(i);
        this.removeButton.setEnabled(this.table.getItemCount() == 0);
    }

    private void handleTableRowSelected() {
        this.removeButton.setEnabled(this.table.getSelection() != null);
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.text) {
            this.applyValue();
            this.endEdit();
        }
    }

    private void applyValue() {
        int i = this.table.getSelectionIndex();
        if (i == -1) {
            return;
        }
        TableItem item = this.table.getItem(i);
        item.setText(this.selectedColumn, this.text.getText());
        GenericElement element = (GenericElement)item.getData();
        if (element == null) {
            return;
        }
        element.addGenericAttribute("bpm", item.getText(this.jbpmColumnIndex()));
        element.addGenericAttribute("esb", item.getText(this.esbColumnIndex()));
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.selectedColumn = this.getSelectedColumn(e.x, e.y);
        if (this.selectedColumn == -1) {
            return;
        }
        this.doEdit();
    }

    private void doEdit() {
        if (this.text.isVisible()) {
            this.endEdit();
        }
        if (this.table.getSelectionIndex() == -1 || this.selectedColumn == -1) {
            return;
        }
        TableItem selection = this.table.getItem(this.table.getSelectionIndex());
        String value = selection.getText(this.selectedColumn);
        this.text.setText(value == null ? "" : value);
        this.editor.setEditor((Control)this.text, selection, this.selectedColumn);
        this.text.setVisible(true);
        this.text.selectAll();
        this.text.setFocus();
        this.text.addFocusListener((FocusListener)this);
    }

    private void endEdit() {
        this.text.setVisible(false);
        this.text.setText("");
        this.text.removeFocusListener((FocusListener)this);
    }

    private int getSelectedColumn(int x, int y) {
        int columnToEdit = -1;
        int columns = this.table.getColumnCount();
        TableItem tableItem = this.getSelectedTableItem();
        if (tableItem == null) {
            return -1;
        }
        int i = 0;
        while (i < columns) {
            Rectangle bounds = tableItem.getBounds(i);
            if (bounds.contains(x, y)) {
                columnToEdit = i;
                break;
            }
            ++i;
        }
        return columnToEdit;
    }

    private TableItem getSelectedTableItem() {
        TableItem[] selection = this.table.getSelection();
        if (selection.length > 0) {
            return selection[0];
        }
        return null;
    }

    public void mouseUp(MouseEvent e) {
    }

    private int jbpmColumnIndex() {
        return this.configurationStrategies[this.type].jbpmColumnIndex();
    }

    private int esbColumnIndex() {
        return this.configurationStrategies[this.type].esbColumnIndex();
    }

    private String[] columnHeaders() {
        return this.configurationStrategies[this.type].columnHeaders();
    }

    private void addElement(GenericElement element) {
        this.configurationStrategies[this.type].addElement(element);
    }

    private void removeElement(GenericElement element) {
        this.configurationStrategies[this.type].removeElement(element);
    }

    private GenericElement[] getMappings() {
        return this.configurationStrategies[this.type].getMappings();
    }

    private static interface InputOutputConfigurationStrategy {
        public int jbpmColumnIndex();

        public int esbColumnIndex();

        public String[] columnHeaders();

        public void addElement(GenericElement var1);

        public void removeElement(GenericElement var1);

        public GenericElement[] getMappings();
    }
}

