/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.ExceptionHandler;

public class ExceptionHandlerConfigurationComposite
implements FocusListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Label exceptionClassLabel;
    private Text exceptionClassText;
    private ExceptionHandler exceptionHandler;

    public static ExceptionHandlerConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        ExceptionHandlerConfigurationComposite result = new ExceptionHandlerConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    private ExceptionHandlerConfigurationComposite() {
    }

    public void setExceptionHandler(ExceptionHandler exceptionHandler) {
        if (this.exceptionHandler == exceptionHandler) {
            return;
        }
        this.unhookListeners();
        this.exceptionHandler = exceptionHandler;
        if (exceptionHandler == null) {
            this.clearControls();
        } else {
            this.updateControls();
            this.hookListeners();
        }
    }

    private void hookListeners() {
        this.exceptionClassText.addFocusListener((FocusListener)this);
    }

    private void unhookListeners() {
        this.exceptionClassText.removeFocusListener((FocusListener)this);
    }

    private void clearControls() {
        this.exceptionClassText.setText("");
    }

    private void updateControls() {
        String exceptionClass = this.exceptionHandler.getExceptionClass();
        if (exceptionClass != null) {
            this.exceptionClassText.setText(exceptionClass);
        } else {
            this.exceptionClassText.setText("");
        }
    }

    private void create() {
        this.exceptionClassLabel = this.widgetFactory.createLabel(this.parent, "Exception class");
        this.exceptionClassText = this.widgetFactory.createText(this.parent, "");
        this.exceptionClassText.setText("");
        this.exceptionClassLabel.setLayoutData((Object)this.createExceptionClassLabelLayoutData());
        this.exceptionClassText.setLayoutData((Object)this.createExceptionClassTextLayoutData());
    }

    private FormData createExceptionClassTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.exceptionClassLabel, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        return data;
    }

    private FormData createExceptionClassLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 2);
        data.bottom = new FormAttachment(100, 0);
        return data;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.exceptionClassText) {
            this.exceptionHandler.setExceptionClass(this.exceptionClassText.getText());
        }
    }
}

