/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.AbstractNotationElement;
import org.jbpm.gd.common.part.NotationElementGraphicalEditPart;
import org.jbpm.gd.common.part.OutlineEditPart;
import org.jbpm.gd.common.properties.AbstractPropertySection;
import org.jbpm.gd.common.util.SharedImages;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.ActionElement;
import org.jbpm.gd.jpdl.model.ExceptionHandler;
import org.jbpm.gd.jpdl.model.ExceptionHandlerContainer;
import org.jbpm.gd.jpdl.model.Script;
import org.jbpm.gd.jpdl.properties.ActionConfigurationComposite;
import org.jbpm.gd.jpdl.properties.ExceptionHandlerConfigurationComposite;
import org.jbpm.gd.jpdl.properties.ExceptionHandlerContainerSectionActionBarContributor;
import org.jbpm.gd.jpdl.properties.ScriptConfigurationComposite;

public class ExceptionHandlerContainerSection
extends AbstractPropertySection
implements PropertyChangeListener {
    private TabbedPropertySheetPage tabbedPropertySheetPage;
    private Tree exceptionHandlerTree;
    private ExceptionHandlerContainer exceptionHandlerContainer;
    private ExceptionHandlerContainerSectionActionBarContributor actionBarContributor;
    private ExceptionHandlerConfigurationComposite exceptionHandlerConfigurationComposite;
    private ActionConfigurationComposite actionConfigurationComposite;
    private ScriptConfigurationComposite scriptConfigurationComposite;
    private ExceptionHandler selectedExceptionHandler;
    private ActionElement selectedActionElement;
    private HashMap detailsPages = new HashMap();

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        this.actionBarContributor = new ExceptionHandlerContainerSectionActionBarContributor(this);
        this.tabbedPropertySheetPage = aTabbedPropertySheetPage;
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.createMasterArea(composite);
        this.createDetailsArea(composite);
    }

    private void createMasterArea(Composite composite) {
        this.exceptionHandlerTree = this.getWidgetFactory().createTree(composite, 68356);
        this.exceptionHandlerTree.setLayoutData((Object)this.createExceptionHandlerTreeLayoutData());
        this.exceptionHandlerTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExceptionHandlerContainerSection.this.handleEventTreeSelection();
            }
        });
        this.actionBarContributor.createPopupMenu((Composite)this.exceptionHandlerTree);
    }

    private void handleEventTreeSelection() {
        TreeItem[] selectedItems = this.exceptionHandlerTree.getSelection();
        if (selectedItems.length == 0) {
            this.unSelectAll();
        } else {
            SemanticElement element = (SemanticElement)selectedItems[0].getData();
            if (element instanceof ExceptionHandler) {
                this.selectExceptionHandler((ExceptionHandler)element);
            } else if (element instanceof ActionElement) {
                this.selectActionElement((ActionElement)element);
            }
        }
        this.updateActionBarContributor();
        this.updateDetailsArea();
    }

    private void updateActionBarContributor() {
        boolean enabled = this.getSelectedExceptionHandler() != null;
        this.actionBarContributor.setAddActionElementEnabled(enabled);
        this.actionBarContributor.setRemoveEnabled(enabled);
    }

    private boolean somethingSelected() {
        return this.getSelectedExceptionHandler() != null || this.getSelectedActionElement() != null;
    }

    private void updateDetailsArea() {
        String key = this.getSelectedKey();
        for (String candidate : this.detailsPages.keySet()) {
            ((Composite)this.detailsPages.get(candidate)).setVisible(candidate.equals(key));
        }
    }

    private String getSelectedKey() {
        String result = null;
        if (this.getSelectedActionElement() != null) {
            result = this.getSelectedActionElement().getElementId();
        } else if (this.getSelectedExceptionHandler() != null) {
            result = this.getSelectedExceptionHandler().getElementId();
        }
        return result;
    }

    private void unSelectAll() {
        if (this.somethingSelected()) {
            this.selectActionElement(null);
            this.selectExceptionHandler(null);
        }
    }

    private void selectExceptionHandler(ExceptionHandler exceptionHandler) {
        if (exceptionHandler == this.getSelectedExceptionHandler() && this.selectedActionElement == null) {
            return;
        }
        this.actionBarContributor.setAddActionElementEnabled(exceptionHandler != null);
        this.actionBarContributor.setRemoveEnabled(exceptionHandler != null);
        if (this.selectedActionElement != null) {
            this.selectedActionElement.removePropertyChangeListener(this);
        }
        if (this.selectedExceptionHandler != null) {
            this.selectedExceptionHandler.removePropertyChangeListener(this);
        }
        this.selectedActionElement = null;
        this.selectedExceptionHandler = exceptionHandler;
        this.exceptionHandlerConfigurationComposite.setExceptionHandler(exceptionHandler);
        if (this.selectedExceptionHandler != null) {
            this.selectedExceptionHandler.addPropertyChangeListener(this);
        }
    }

    private void selectActionElement(ActionElement actionElement) {
        if (actionElement == this.getSelectedActionElement()) {
            return;
        }
        ExceptionHandler exceptionHandler = null;
        if (actionElement != null) {
            exceptionHandler = (ExceptionHandler)this.exceptionHandlerTree.getSelection()[0].getParentItem().getData();
        }
        this.selectExceptionHandler(exceptionHandler);
        this.selectedActionElement = actionElement;
        this.updateActionElementDetails();
        if (this.selectedActionElement != null) {
            this.selectedActionElement.addPropertyChangeListener(this);
        }
    }

    private void updateActionElementDetails() {
        if (this.selectedActionElement instanceof Action) {
            this.actionConfigurationComposite.setAction((Action)this.selectedActionElement);
        } else if (this.selectedActionElement instanceof Script) {
            this.scriptConfigurationComposite.setScript((Script)this.selectedActionElement);
        }
    }

    private FormData createExceptionHandlerTreeLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(20, 0);
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        return data;
    }

    private void createDetailsArea(Composite composite) {
        this.createExceptionHandlerPage(composite);
        this.createActionPage(composite);
        this.createScriptPage(composite);
    }

    private void createActionPage(Composite composite) {
        Composite actionPage = this.getWidgetFactory().createComposite(composite);
        actionPage.setLayout((Layout)new FormLayout());
        actionPage.setLayoutData((Object)this.createDetailsPageLayoutData());
        this.detailsPages.put("org.jbpm.gd.jpdl.action", actionPage);
        this.actionConfigurationComposite = ActionConfigurationComposite.create(this.getWidgetFactory(), actionPage);
    }

    private void createExceptionHandlerPage(Composite composite) {
        Composite exceptionHandlerPage = this.getWidgetFactory().createFlatFormComposite(composite);
        exceptionHandlerPage.setLayoutData((Object)this.createDetailsPageLayoutData());
        this.detailsPages.put("org.jbpm.gd.jpdl.exceptionHandler", exceptionHandlerPage);
        this.exceptionHandlerConfigurationComposite = ExceptionHandlerConfigurationComposite.create(this.getWidgetFactory(), exceptionHandlerPage);
    }

    private void createScriptPage(Composite composite) {
        Composite scriptPage = this.getWidgetFactory().createComposite(composite);
        scriptPage.setLayout((Layout)new FormLayout());
        scriptPage.setLayoutData((Object)this.createDetailsPageLayoutData());
        this.detailsPages.put("org.jbpm.gd.jpdl.script", scriptPage);
        this.scriptConfigurationComposite = ScriptConfigurationComposite.create(this.getWidgetFactory(), scriptPage);
    }

    private FormData createDetailsPageLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.exceptionHandlerTree, 0);
        data.top = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        return data;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof NotationElementGraphicalEditPart) {
            AbstractNotationElement notationElement = ((NotationElementGraphicalEditPart)input).getNotationElement();
            this.setExceptionHandlerContainer((ExceptionHandlerContainer)notationElement.getSemanticElement());
        } else if (input instanceof OutlineEditPart) {
            this.setExceptionHandlerContainer((ExceptionHandlerContainer)((OutlineEditPart)input).getModel());
        }
    }

    private void clearControls() {
        this.exceptionHandlerTree.removeAll();
        Iterator iter = this.detailsPages.values().iterator();
        while (iter.hasNext()) {
            ((Composite)iter.next()).setVisible(false);
        }
    }

    private void setExceptionHandlerContainer(ExceptionHandlerContainer newExceptionHandlerContainer) {
        if (this.exceptionHandlerContainer == newExceptionHandlerContainer) {
            return;
        }
        if (this.exceptionHandlerContainer != null) {
            this.exceptionHandlerContainer.removePropertyChangeListener(this);
        }
        this.clearControls();
        this.exceptionHandlerContainer = newExceptionHandlerContainer;
        if (this.exceptionHandlerContainer != null) {
            this.updateExceptionHandlerTree();
            this.exceptionHandlerContainer.addPropertyChangeListener(this);
        }
    }

    private void updateExceptionHandlerTree() {
        ExceptionHandler[] exceptionHandlers = this.exceptionHandlerContainer.getExceptionHandlers();
        int i = 0;
        while (i < exceptionHandlers.length) {
            TreeItem exceptionHandlerItem = new TreeItem(this.exceptionHandlerTree, 0);
            exceptionHandlerItem.setText(this.getLabel(exceptionHandlers[i]));
            exceptionHandlerItem.setData((Object)exceptionHandlers[i]);
            exceptionHandlerItem.setImage(SharedImages.INSTANCE.getImage(exceptionHandlers[i].getIconDescriptor()));
            exceptionHandlerItem.setExpanded(true);
            ActionElement[] actionElements = exceptionHandlers[i].getActionElements();
            int j = 0;
            while (j < actionElements.length) {
                TreeItem actionElementItem = new TreeItem(exceptionHandlerItem, 0);
                actionElementItem.setText(this.getLabel(actionElements[j]));
                actionElementItem.setData((Object)actionElements[j]);
                actionElementItem.setImage(SharedImages.INSTANCE.getImage(actionElements[j].getIconDescriptor()));
                ++j;
            }
            ++i;
        }
    }

    private String getLabel(ActionElement actionElement) {
        String refName;
        String result = actionElement.getName();
        if (result != null && !"".equals(result)) {
            return result;
        }
        if (actionElement instanceof Action && (refName = ((Action)actionElement).getRefName()) != null && !"".equals(refName)) {
            return refName;
        }
        result = actionElement.getLabel();
        return result != null ? result.toLowerCase() : actionElement.getElementId();
    }

    public TabbedPropertySheetPage getTabbedPropertySheetPage() {
        return this.tabbedPropertySheetPage;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.exceptionHandlerTree.isDisposed()) {
            return;
        }
        if ("exceptionHandlerAdd".equals(evt.getPropertyName())) {
            TreeItem treeItem = new TreeItem(this.exceptionHandlerTree, 0);
            ExceptionHandler exceptionHandler = (ExceptionHandler)evt.getNewValue();
            treeItem.setText(this.getLabel(exceptionHandler));
            treeItem.setData((Object)exceptionHandler);
            treeItem.setImage(SharedImages.INSTANCE.getImage(exceptionHandler.getIconDescriptor()));
            this.exceptionHandlerTree.setSelection(treeItem);
            this.exceptionHandlerTree.notifyListeners(13, new Event());
        } else if ("actionElementAdd".equals(evt.getPropertyName())) {
            TreeItem selection = this.exceptionHandlerTree.getSelection()[0];
            if (selection.getData() instanceof ActionElement) {
                selection = selection.getParentItem();
            }
            TreeItem treeItem = new TreeItem(selection, 0);
            ActionElement actionElement = (ActionElement)evt.getNewValue();
            treeItem.setText(this.getLabel(actionElement));
            treeItem.setData((Object)actionElement);
            treeItem.setImage(SharedImages.INSTANCE.getImage(actionElement.getIconDescriptor()));
            this.exceptionHandlerTree.setSelection(treeItem);
            this.exceptionHandlerTree.notifyListeners(13, new Event());
        } else if ("exceptionHandlerRemove".equals(evt.getPropertyName()) || "actionElementRemove".equals(evt.getPropertyName())) {
            this.exceptionHandlerTree.getSelection()[0].dispose();
            this.exceptionHandlerTree.notifyListeners(13, new Event());
        } else if ("exceptionClass".equals(evt.getPropertyName())) {
            TreeItem treeItem;
            String newValue = (String)evt.getNewValue();
            if (this.exceptionHandlerTree.getSelectionCount() != 1) {
                return;
            }
            if (newValue == null || "".equals(newValue)) {
                newValue = "exception-handler";
            }
            if ((treeItem = this.exceptionHandlerTree.getSelection()[0]).getData() == evt.getSource()) {
                treeItem.setText(newValue);
            }
        } else if ("name".equals(evt.getPropertyName()) || "refName".equals(evt.getPropertyName())) {
            TreeItem treeItem;
            String newValue = (String)evt.getNewValue();
            if (this.exceptionHandlerTree.getSelectionCount() != 1) {
                return;
            }
            if (newValue == null || "".equals(newValue)) {
                newValue = "action";
            }
            if ((treeItem = this.exceptionHandlerTree.getSelection()[0]).getData() == evt.getSource()) {
                treeItem.setText(newValue);
            }
        }
    }

    private String getLabel(ExceptionHandler exceptionHandler) {
        String label = exceptionHandler.getExceptionClass();
        return label == null || "".equals(label) ? "exception" : label;
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public ExceptionHandlerContainer getExceptionHandlerContainer() {
        return this.exceptionHandlerContainer;
    }

    public ExceptionHandler getSelectedExceptionHandler() {
        return this.selectedExceptionHandler;
    }

    public ActionElement getSelectedActionElement() {
        return this.selectedActionElement;
    }

    public void aboutToBeShown() {
        this.actionBarContributor.activateContributions();
    }

    public void aboutToBeHidden() {
        this.actionBarContributor.deactivateContributions();
    }
}

