/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.MailElement;
import org.jbpm.gd.jpdl.model.Subject;

public class MailElementMailInfoConfigurationComposite
implements SelectionListener,
FocusListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private MailElement mailElement;
    private Label destinationLabel;
    private CCombo destinationCombo;
    private Text destinationText;
    private Label subjectLabel;
    private Text subjectText;
    private Label bodyLabel;
    private Text bodyText;

    public static MailElementMailInfoConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        MailElementMailInfoConfigurationComposite result = new MailElementMailInfoConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    public void setMailElement(MailElement mailElement) {
        if (this.mailElement == mailElement) {
            return;
        }
        this.unhookListeners();
        this.mailElement = mailElement;
        if (mailElement == null) {
            this.clearControls();
        } else {
            this.updateControls();
            this.hookListeners();
        }
    }

    private void hookListeners() {
        this.destinationCombo.addSelectionListener((SelectionListener)this);
        this.destinationText.addFocusListener((FocusListener)this);
        this.subjectText.addFocusListener((FocusListener)this);
        this.bodyText.addFocusListener((FocusListener)this);
    }

    private void unhookListeners() {
        this.destinationCombo.removeSelectionListener((SelectionListener)this);
        this.destinationText.addFocusListener((FocusListener)this);
        this.subjectText.removeFocusListener((FocusListener)this);
        this.bodyText.removeFocusListener((FocusListener)this);
    }

    private void clearControls() {
        this.destinationCombo.setText("To");
        this.destinationText.setText("");
        this.subjectText.setText("");
        this.bodyText.setText("");
    }

    private void updateControls() {
        this.destinationCombo.setText(this.mailElement.getActors() != null ? "Actors" : "To");
        if (this.mailElement.getActors() != null) {
            this.destinationCombo.setText("Actors");
            this.destinationText.setText(this.mailElement.getActors());
        } else {
            this.destinationCombo.setText("To");
            this.destinationText.setText(this.mailElement.getTo() == null ? "" : this.mailElement.getTo());
        }
        this.subjectText.setText(this.getSubjectText());
        this.bodyText.setText(this.getBodyText());
    }

    private String getSubjectText() {
        String result = "";
        Subject subject = this.mailElement.getSubject();
        if (subject != null) {
            result = subject.getSubject() == null ? "" : subject.getSubject();
        }
        return result;
    }

    private String getBodyText() {
        String result = "";
        if (this.mailElement.getText() != null) {
            result = this.mailElement.getText().getText() == null ? "" : this.mailElement.getText().getText();
        }
        return result;
    }

    private void create() {
        this.destinationLabel = this.widgetFactory.createLabel(this.parent, "Destination");
        this.destinationCombo = this.widgetFactory.createCCombo(this.parent);
        this.destinationCombo.setItems(new String[]{"To", "Actors"});
        this.destinationCombo.setText("To");
        this.destinationText = this.widgetFactory.createText(this.parent, "");
        this.subjectLabel = this.widgetFactory.createLabel(this.parent, "Subject");
        this.subjectText = this.widgetFactory.createText(this.parent, "");
        this.bodyLabel = this.widgetFactory.createLabel(this.parent, "Body");
        this.bodyText = this.widgetFactory.createText(this.parent, "", 514);
        this.destinationLabel.setLayoutData((Object)this.createDestinationLabelLayoutData());
        this.destinationCombo.setLayoutData((Object)this.createDestinationComboLayoutData());
        this.destinationText.setLayoutData((Object)this.createDestinationTextLayoutData());
        this.subjectLabel.setLayoutData((Object)this.createSubjectLabelLayoutData());
        this.subjectText.setLayoutData((Object)this.createSubjectTextLayoutData());
        this.bodyLabel.setLayoutData((Object)this.createBodyLabelLayoutData());
        this.bodyText.setLayoutData((Object)this.createBodyTextLayoutData());
    }

    private FormData createDestinationLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 3);
        return data;
    }

    private FormData createDestinationComboLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.destinationLabel, 0);
        data.top = new FormAttachment(0, 0);
        return data;
    }

    private FormData createDestinationTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.destinationCombo, 0);
        data.top = new FormAttachment(0, 2);
        data.right = new FormAttachment(100, 0);
        return data;
    }

    private FormData createSubjectLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.destinationCombo, 0);
        return data;
    }

    private FormData createSubjectTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.destinationCombo, 0);
        data.left.alignment = 16384;
        data.top = new FormAttachment((Control)this.destinationCombo, 0);
        data.right = new FormAttachment(100, 0);
        return data;
    }

    private FormData createBodyLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.subjectText, 0);
        return data;
    }

    private FormData createBodyTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.destinationCombo, 0);
        data.left.alignment = 16384;
        data.top = new FormAttachment((Control)this.subjectText, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        data.height = 50;
        return data;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private void updateSubject() {
        Subject subject = this.mailElement.getSubject();
        if (subject == null) {
            subject = (Subject)this.mailElement.getFactory().createById("org.jbpm.gd.jpdl.subject");
            this.mailElement.setSubject(subject);
        }
        subject.setSubject(this.subjectText.getText());
    }

    private void updateBody() {
        org.jbpm.gd.jpdl.model.Text text = this.mailElement.getText();
        if (text == null) {
            text = (org.jbpm.gd.jpdl.model.Text)this.mailElement.getFactory().createById("org.jbpm.gd.jpdl.text");
            this.mailElement.setText(text);
        }
        text.setText(this.bodyText.getText());
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.destinationCombo) {
            this.updateDestination();
        }
    }

    private void updateDestination() {
        String str = this.destinationText.getText();
        if ("To".equals(this.destinationCombo.getText())) {
            this.mailElement.setTo(str == null ? "" : str);
            this.mailElement.setActors(null);
        } else {
            this.mailElement.setTo(null);
            this.mailElement.setActors(str == null ? "" : str);
        }
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.destinationText) {
            this.updateDestination();
        } else if (e.widget == this.subjectText) {
            this.updateSubject();
        } else if (e.widget == this.bodyText) {
            this.updateBody();
        }
    }
}

