/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import java.net.URL;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionBars;
import org.jbpm.gd.common.util.SharedImages;
import org.jbpm.gd.jpdl.Plugin;
import org.jbpm.gd.jpdl.command.TaskCreateCommand;
import org.jbpm.gd.jpdl.command.TaskDeleteCommand;
import org.jbpm.gd.jpdl.model.TaskContainer;
import org.jbpm.gd.jpdl.properties.TaskContainerSection;

public class TaskContainerSectionActionBarContributor {
    private TaskContainerSection tasksSection;
    private ActionContributionItem addTaskToolbarContributionItem;
    private ActionContributionItem removeToolbarContributionItem;
    private ActionContributionItem addTaskMenuContributionItem;
    private ActionContributionItem removeMenuContributionItem;
    private Separator toolbarSeparator;
    private Separator menuSeparator;
    private Menu root;
    IContributionItem item;

    public TaskContainerSectionActionBarContributor(TaskContainerSection tasksSection) {
        this.setTasksSection(tasksSection);
        this.createAddTaskContributions();
        this.createSeparatorContributions();
        this.createRemoveContributions();
    }

    private void createSeparatorContributions() {
        this.toolbarSeparator = new Separator();
        this.menuSeparator = new Separator();
    }

    private void setTasksSection(TaskContainerSection tasksSection) {
        this.tasksSection = tasksSection;
    }

    public void activateContributions() {
        this.addAddTaskAction();
        this.addSeparators();
        this.addRemoveAction();
        this.getActionBars().updateActionBars();
    }

    private void addSeparators() {
        this.getActionBars().getToolBarManager().add((IContributionItem)this.toolbarSeparator);
        this.getActionBars().getMenuManager().add((IContributionItem)this.menuSeparator);
    }

    public void deactivateContributions() {
        this.removeAddTaskAction();
        this.removeSeparators();
        this.removeRemoveAction();
        this.getActionBars().updateActionBars();
    }

    private void removeSeparators() {
        this.getActionBars().getToolBarManager().remove((IContributionItem)this.toolbarSeparator);
        this.getActionBars().getMenuManager().remove((IContributionItem)this.menuSeparator);
    }

    public void setRemoveEnabled(boolean enabled) {
        this.removeMenuContributionItem.getAction().setEnabled(enabled);
        this.removeToolbarContributionItem.getAction().setEnabled(enabled);
    }

    private void addAddTaskAction() {
        this.getActionBars().getToolBarManager().add((IContributionItem)this.addTaskToolbarContributionItem);
        this.getActionBars().getMenuManager().add((IContributionItem)this.addTaskMenuContributionItem);
    }

    private void createAddTaskContributions() {
        this.addTaskToolbarContributionItem = new ActionContributionItem(this.createAddTaskAction());
        this.addTaskMenuContributionItem = new ActionContributionItem(this.createAddTaskAction());
    }

    private IAction createAddTaskAction() {
        Action action = new Action(){

            public void run() {
                TaskContainerSectionActionBarContributor.this.addNewTask();
            }
        };
        action.setImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/new_task_enabled.gif")));
        action.setDisabledImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/new_task_disabled.gif")));
        action.setToolTipText("Add a task");
        action.setText("New Task");
        return action;
    }

    private void addRemoveAction() {
        this.getActionBars().getToolBarManager().add((IContributionItem)this.removeToolbarContributionItem);
        this.getActionBars().getMenuManager().add((IContributionItem)this.removeMenuContributionItem);
    }

    private void createRemoveContributions() {
        this.removeToolbarContributionItem = new ActionContributionItem(this.createRemoveAction());
        this.removeMenuContributionItem = new ActionContributionItem(this.createRemoveAction());
    }

    private IAction createRemoveAction() {
        Action action = new Action(){

            public void run() {
                TaskContainerSectionActionBarContributor.this.removeSelectedObject();
            }
        };
        action.setImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/delete_enabled.gif")));
        action.setDisabledImageDescriptor(ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/delete_disabled.gif")));
        action.setToolTipText("Remove the selection");
        action.setText("Delete");
        action.setEnabled(false);
        return action;
    }

    private void addNewTask() {
        TaskContainer target = this.tasksSection.getTaskContainer();
        TaskCreateCommand command = new TaskCreateCommand(target.getFactory());
        command.setTaskContainer(target);
        this.getCommandStack().execute((Command)command);
    }

    private void removeSelectedObject() {
        TaskDeleteCommand command = new TaskDeleteCommand();
        command.setTaskContainer(this.tasksSection.getTaskContainer());
        command.setTask(this.tasksSection.getSelectedTask());
        this.getCommandStack().execute((Command)command);
    }

    private CommandStack getCommandStack() {
        return this.tasksSection.getCommandStack();
    }

    private void removeAddTaskAction() {
        this.getActionBars().getToolBarManager().remove((IContributionItem)this.addTaskToolbarContributionItem);
        this.getActionBars().getMenuManager().remove((IContributionItem)this.addTaskMenuContributionItem);
    }

    private void removeRemoveAction() {
        this.getActionBars().getToolBarManager().remove((IContributionItem)this.removeToolbarContributionItem);
        this.getActionBars().getMenuManager().remove((IContributionItem)this.removeMenuContributionItem);
    }

    private IActionBars getActionBars() {
        return this.tasksSection.getTabbedPropertySheetPage().getSite().getActionBars();
    }

    public void createPopupMenu(Composite composite) {
        this.root = new Menu((Control)composite);
        composite.setMenu(this.root);
        this.root.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                TaskContainerSectionActionBarContributor.this.disposePopupMenu();
                TaskContainerSectionActionBarContributor.this.createPopupMenu();
            }
        });
    }

    private void disposePopupMenu() {
        MenuItem[] menuItems = this.root.getItems();
        int i = 0;
        while (i < menuItems.length) {
            menuItems[i].dispose();
            ++i;
        }
    }

    private void createPopupMenu() {
        this.createAddTaskMenuItem();
        new MenuItem(this.root, 2);
        this.createRemoveMenuItem();
    }

    private String getDeleteImagePath() {
        String imagePath = this.tasksSection.getSelectedTask() != null ? "/icons/full/obj16/delete_enabled.gif" : "/icons/full/obj16/delete_disabled.gif";
        return imagePath;
    }

    private void createAddTaskMenuItem() {
        MenuItem addTaskItem = new MenuItem(this.root, 8);
        addTaskItem.setText("New Task");
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry("/icons/full/obj16/new_task_enabled.gif"));
        addTaskItem.setImage(SharedImages.INSTANCE.getImage(descriptor));
        addTaskItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskContainerSectionActionBarContributor.this.addNewTask();
            }
        });
    }

    private void createRemoveMenuItem() {
        MenuItem removeItem = new MenuItem(this.root, 8);
        removeItem.setText("Delete");
        ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)Plugin.getDefault().getBundle().getEntry(this.getDeleteImagePath()));
        removeItem.setImage(SharedImages.INSTANCE.getImage(descriptor));
        removeItem.setEnabled(this.tasksSection.getSelectedTask() != null);
        removeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TaskContainerSectionActionBarContributor.this.removeSelectedObject();
            }
        });
    }
}

