/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.Reminder;
import org.jbpm.gd.jpdl.model.Task;

public class TaskReminderConfigurationComposite
implements FocusListener,
SelectionListener {
    private TabbedPropertySheetWidgetFactory widgetFactory;
    private Composite parent;
    private Button reminderButton;
    private Composite reminderComposite;
    private Label duedateLabel;
    private Text duedateText;
    private Label repeatLabel;
    private Text repeatText;
    private Task task;

    public static TaskReminderConfigurationComposite create(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        TaskReminderConfigurationComposite result = new TaskReminderConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.create();
        return result;
    }

    public void setTask(Task task) {
        if (this.task == task) {
            return;
        }
        this.unhookListeners();
        this.clearControls();
        this.task = task;
        if (task != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    private void hookListeners() {
        this.reminderButton.addSelectionListener((SelectionListener)this);
        this.duedateText.addFocusListener((FocusListener)this);
        this.repeatText.addFocusListener((FocusListener)this);
    }

    private void unhookListeners() {
        this.reminderButton.removeSelectionListener((SelectionListener)this);
        this.duedateText.removeFocusListener((FocusListener)this);
        this.repeatText.removeFocusListener((FocusListener)this);
    }

    private void clearControls() {
        this.reminderButton.setSelection(false);
        this.duedateText.setText("");
        this.repeatText.setText("");
        this.reminderComposite.setVisible(false);
    }

    private void updateControls() {
        this.reminderButton.setSelection(this.task.getReminder() != null);
        this.duedateText.setText(this.getDueDateText());
        this.repeatText.setText(this.getRepeatText());
        this.reminderComposite.setVisible(this.reminderButton.getSelection());
    }

    private String getDueDateText() {
        String result = "";
        if (this.task.getReminder() != null && this.task.getReminder().getDueDate() != null) {
            result = this.task.getReminder().getDueDate();
        }
        return result;
    }

    private String getRepeatText() {
        String result = "";
        if (this.task.getReminder() != null && this.task.getReminder().getRepeat() != null) {
            result = this.task.getReminder().getRepeat();
        }
        return result;
    }

    private void create() {
        this.reminderButton = this.widgetFactory.createButton(this.parent, "Configure Reminder", 32);
        this.reminderComposite = this.widgetFactory.createFlatFormComposite(this.parent);
        this.duedateLabel = this.widgetFactory.createLabel(this.reminderComposite, "Due Date");
        this.duedateText = this.widgetFactory.createText(this.reminderComposite, "");
        this.repeatLabel = this.widgetFactory.createLabel(this.reminderComposite, "Repeat");
        this.repeatText = this.widgetFactory.createText(this.reminderComposite, "");
        this.reminderButton.setLayoutData((Object)this.createReminderButtonLayoutData());
        this.reminderComposite.setLayoutData((Object)this.createReminderCompositeLayoutData());
        this.duedateLabel.setLayoutData((Object)this.createDuedateLabelLayoutData());
        this.duedateText.setLayoutData((Object)this.createDuedateTextLayoutData());
        this.repeatLabel.setLayoutData((Object)this.createRepeatLabelLayoutData());
        this.repeatText.setLayoutData((Object)this.createRepeatTextLayoutData());
    }

    private FormData createReminderButtonLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 2);
        return data;
    }

    private FormData createReminderCompositeLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, -3);
        data.top = new FormAttachment((Control)this.reminderButton, -3);
        data.right = new FormAttachment(100, 3);
        return data;
    }

    private FormData createDuedateLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment(0, 2);
        return data;
    }

    private FormData createDuedateTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.duedateLabel, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 0);
        return data;
    }

    private FormData createRepeatLabelLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.duedateText, 2);
        return data;
    }

    private FormData createRepeatTextLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.duedateLabel, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this.duedateText, 0);
        return data;
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        if (e.widget == this.duedateText) {
            this.task.getReminder().setDueDate(this.duedateText.getText());
        } else if (e.widget == this.repeatText) {
            this.task.getReminder().setRepeat("".equals(this.repeatText.getText()) ? null : this.repeatText.getText());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.reminderButton) {
            if (this.reminderButton.getSelection()) {
                Reminder reminder = this.task.getReminder();
                if (reminder == null) {
                    reminder = (Reminder)this.task.getFactory().createById("org.jbpm.gd.jpdl.reminder");
                    this.task.setReminder(reminder);
                }
                reminder.setDueDate(this.duedateText.getText());
                reminder.setRepeat("".equals(this.repeatText.getText()) ? null : this.repeatText.getText());
            } else {
                this.task.setReminder(null);
            }
            this.reminderComposite.setVisible(this.reminderButton.getSelection());
        }
    }
}

