/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.properties;

import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.jboss.tools.jbpm.util.AutoResizeTableLayout;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.model.SemanticElementFactory;
import org.jbpm.gd.jpdl.model.Variable;
import org.jbpm.gd.jpdl.model.VariableContainer;
import org.jbpm.gd.jpdl.util.VariableTableCellClickedResolver;
import org.jbpm.gd.jpdl.util.VariableTableItemWrapper;

public class VariableContainerConfigurationComposite
implements SelectionListener {
    private FormToolkit widgetFactory;
    private Composite parent;
    private Label messageLabel;
    private Table variablesTable;
    private Button addButton;
    private Button removeButton;
    private VariableContainer variableContainer;
    private VariableTableCellClickedResolver resolver;
    private String variableDefaultName = "variable";
    private boolean nameOnlyVisible = false;
    private String[] columnTitles = null;

    public static VariableContainerConfigurationComposite create(FormToolkit widgetFactory, Composite parent, boolean nameOnly, String[] columnTitles) {
        VariableContainerConfigurationComposite result = new VariableContainerConfigurationComposite();
        result.widgetFactory = widgetFactory;
        result.parent = parent;
        result.nameOnlyVisible = nameOnly;
        result.columnTitles = columnTitles;
        result.create();
        return result;
    }

    public static VariableContainerConfigurationComposite create(FormToolkit widgetFactory, Composite parent) {
        return VariableContainerConfigurationComposite.create(widgetFactory, parent, false, new String[]{"Name", "Mapped Name", "Read", "Write", "Required"});
    }

    private VariableContainerConfigurationComposite() {
    }

    public void setVariableContainer(VariableContainer variableContainer) {
        if (this.variableContainer == variableContainer) {
            return;
        }
        this.unhookListeners();
        this.variableContainer = variableContainer;
        this.clearControls();
        if (variableContainer != null) {
            this.updateControls();
            this.hookListeners();
        }
    }

    private void hookListeners() {
        this.addButton.addSelectionListener((SelectionListener)this);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.variablesTable.addSelectionListener((SelectionListener)this);
        this.variablesTable.addMouseListener((MouseListener)this.resolver);
    }

    private void unhookListeners() {
        this.addButton.removeSelectionListener((SelectionListener)this);
        this.removeButton.removeSelectionListener((SelectionListener)this);
        this.variablesTable.removeSelectionListener((SelectionListener)this);
        this.variablesTable.removeMouseListener((MouseListener)this.resolver);
    }

    private void clearControls() {
        this.variablesTable.removeAll();
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    private void updateControls() {
        this.addButton.setEnabled(true);
        this.refreshTable();
    }

    private void create() {
        this.messageLabel = this.widgetFactory.createLabel(this.parent, "Define the used variables :");
        this.variablesTable = this.widgetFactory.createTable(this.parent, 66304);
        this.addButton = this.widgetFactory.createButton(this.parent, "Add", 8);
        this.removeButton = this.widgetFactory.createButton(this.parent, "Remove", 8);
        this.resolver = new VariableTableCellClickedResolver(this.variablesTable);
        this.removeButton.setEnabled(false);
        this.messageLabel.setLayoutData((Object)this.createMessageLabelLayoutData());
        this.variablesTable.setLayoutData((Object)this.createVariablesTableLayoutData());
        this.addButton.setLayoutData((Object)this.createAddButtonLayoutData());
        this.removeButton.setLayoutData((Object)this.createRemoveButtonLayoutData());
        this.initializeVariablesTable();
    }

    private void initializeVariablesTable() {
        this.variablesTable.setHeaderVisible(true);
        this.variablesTable.setLinesVisible(true);
        this.variablesTable.setLayout((Layout)new AutoResizeTableLayout(this.variablesTable));
        this.initializeTableColumns();
    }

    private void initializeTableColumns() {
        TableLayout layout = (TableLayout)this.variablesTable.getLayout();
        TableColumn dummyColumn = new TableColumn(this.variablesTable, 0x1000000);
        dummyColumn.setText("");
        ColumnWeightData dummyColumnData = new ColumnWeightData(0, 0);
        layout.addColumnData((ColumnLayoutData)dummyColumnData);
        TableColumn nameColumn = new TableColumn(this.variablesTable, 16384);
        nameColumn.setText(this.columnTitles[0]);
        ColumnWeightData nameColumnData = new ColumnWeightData(20, 100);
        layout.addColumnData((ColumnLayoutData)nameColumnData);
        TableColumn mappedNameColumn = new TableColumn(this.variablesTable, 16384);
        mappedNameColumn.setText(this.columnTitles[1]);
        ColumnWeightData mappedNameColumnData = new ColumnWeightData(20, 100);
        layout.addColumnData((ColumnLayoutData)mappedNameColumnData);
        if (this.nameOnlyVisible) {
            return;
        }
        TableColumn readColumn = new TableColumn(this.variablesTable, 0x1000000);
        readColumn.setText(this.columnTitles[2]);
        ColumnWeightData readColumnData = new ColumnWeightData(10, 60);
        layout.addColumnData((ColumnLayoutData)readColumnData);
        TableColumn writeColumn = new TableColumn(this.variablesTable, 0x1000000);
        writeColumn.setText(this.columnTitles[3]);
        ColumnWeightData writeColumnData = new ColumnWeightData(10, 60);
        layout.addColumnData((ColumnLayoutData)writeColumnData);
        TableColumn requiredColumn = new TableColumn(this.variablesTable, 0x1000000);
        requiredColumn.setText(this.columnTitles[4]);
        ColumnWeightData requiredColumnData = new ColumnWeightData(15, 75);
        layout.addColumnData((ColumnLayoutData)requiredColumnData);
    }

    private FormData createMessageLabelLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment(0, 5);
        result.left = new FormAttachment(0, 5);
        result.right = new FormAttachment(100, -5);
        return result;
    }

    private FormData createVariablesTableLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.messageLabel, 5);
        result.left = new FormAttachment(0, 5);
        result.bottom = new FormAttachment(100, -5);
        result.right = new FormAttachment((Control)this.removeButton, -5);
        return result;
    }

    private FormData createAddButtonLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.variablesTable, 0);
        result.top.alignment = 128;
        result.left = new FormAttachment((Control)this.removeButton, 0);
        result.left.alignment = 16384;
        result.right = new FormAttachment(100, -5);
        return result;
    }

    private FormData createRemoveButtonLayoutData() {
        FormData result = new FormData();
        result.top = new FormAttachment((Control)this.addButton, 5);
        result.right = new FormAttachment(100, -5);
        return result;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.addButton) {
            this.handleAddButtonSelected();
        } else if (e.widget == this.removeButton) {
            this.handleRemoveButtonSelected();
        } else if (e.widget == this.variablesTable) {
            this.handleVariablesTableSelected(e);
        }
    }

    private Variable createVariable(SemanticElementFactory delegateFactory) {
        if (delegateFactory == null) {
            return new Variable();
        }
        return (Variable)delegateFactory.createById("org.jbpm.gd.jpdl.variable");
    }

    private void handleAddButtonSelected() {
        SemanticElementFactory factory = null;
        if (this.variableContainer instanceof SemanticElement) {
            factory = ((SemanticElement)((Object)this.variableContainer)).getFactory();
        }
        Variable variable = this.createVariable(factory);
        variable.setName(this.getNextAvailableVariableName());
        variable.setAccess("read,write");
        this.variableContainer.addVariable(variable);
        VariableTableItemWrapper wrapper = new VariableTableItemWrapper(this.variablesTable, variable);
        this.variablesTable.setSelection(wrapper.getTableItem());
        wrapper.editCell(1);
        this.removeButton.setEnabled(this.variablesTable.getSelectionIndex() != -1);
    }

    private String getNextAvailableVariableName() {
        String result = this.variableDefaultName;
        int runner = 1;
        while (this.hasTableVariableWithName(String.valueOf(result) + runner)) {
            ++runner;
        }
        return String.valueOf(result) + runner;
    }

    private boolean hasTableVariableWithName(String name) {
        boolean result = false;
        int max = this.variablesTable.getItemCount();
        int i = 0;
        while (i < max) {
            VariableTableItemWrapper wrapper = (VariableTableItemWrapper)this.variablesTable.getItem(i).getData();
            if (name.equals(wrapper.getVariable().getName())) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    private void handleRemoveButtonSelected() {
        TableItem item = this.variablesTable.getItem(this.variablesTable.getSelectionIndex());
        VariableTableItemWrapper wrapper = (VariableTableItemWrapper)item.getData();
        this.variableContainer.removeVariable(wrapper.getVariable());
        this.refreshTable();
        this.removeButton.setEnabled(this.variablesTable.getSelectionIndex() != -1);
    }

    private void refreshTable() {
        this.variablesTable.removeAll();
        Variable[] variables = this.variableContainer.getVariables();
        int i = 0;
        while (i < variables.length) {
            new VariableTableItemWrapper(this.variablesTable, variables[i]);
            ++i;
        }
    }

    private void handleVariablesTableSelected(SelectionEvent e) {
        this.removeButton.setEnabled(this.variablesTable.getSelectionIndex() != -1);
    }

    public VariableContainer getVariableContainer() {
        return this.variableContainer;
    }

    void setBackground(Color color) {
        this.messageLabel.setBackground(color);
    }

    void setMessage(String message) {
        this.messageLabel.setText(message);
    }

    void setVariableDefaultName(String name) {
        this.variableDefaultName = name;
    }
}

