/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.resource.MoveResourceChange;

public class MoveProcessProcessor
extends MoveProcessor {
    private final IResource[] resourcesToMove;
    private IContainer destination;

    public MoveProcessProcessor(IResource resource) {
        IResource jpdlResource = null;
        IResource gpdResource = null;
        IResource jpgResource = null;
        if (resource == null || !resource.exists()) {
            throw new IllegalArgumentException("resource must not be null and must exist");
        }
        if (this.isJpdlFile(resource)) {
            jpdlResource = resource;
            gpdResource = this.getGpdResource(resource);
        } else if (this.isGpdFile(resource)) {
            jpdlResource = this.getJpdlResource(resource);
            gpdResource = resource;
        }
        if (jpdlResource != null && jpdlResource.exists() && gpdResource != null && gpdResource.exists()) {
            jpgResource = this.getJpgResource(jpdlResource);
            this.resourcesToMove = jpgResource != null && jpgResource.exists() ? new IResource[]{jpdlResource, gpdResource, jpgResource} : new IResource[]{jpdlResource, gpdResource};
        } else {
            throw new IllegalArgumentException("both jpdlFile and gpdFile must not be null and must exist");
        }
    }

    private String getProcessName(IResource resource) {
        String name = resource.getName();
        if (name.startsWith(".") && name.endsWith(".gpd.xml")) {
            return name.substring(1, name.indexOf(".gpd.xml"));
        }
        if (name.endsWith(".jpdl.xml")) {
            return name.substring(0, name.indexOf(".jpdl.xml"));
        }
        throw new IllegalArgumentException("resource must be either a jpdlFile or gpdFile");
    }

    private boolean isJpdlFile(IResource resource) {
        return resource.getName().endsWith(".jpdl.xml");
    }

    private boolean isGpdFile(IResource resource) {
        String name = resource.getName();
        return name.startsWith(".") && name.endsWith(".gpd.xml");
    }

    private IResource getJpgResource(IResource resource) {
        if (!resource.getName().endsWith(".jpdl.xml")) {
            throw new IllegalArgumentException("jpg resource can only be obtained for a jpdl file");
        }
        return resource.getParent().getFile((IPath)new Path(String.valueOf(this.getProcessName(resource)) + ".jpg"));
    }

    private IResource getGpdResource(IResource resource) {
        if (!resource.getName().endsWith(".jpdl.xml")) {
            throw new IllegalArgumentException("gpd resource can only be obtained for a jpdl file");
        }
        return resource.getParent().getFile((IPath)new Path("." + this.getProcessName(resource) + ".gpd.xml"));
    }

    private IResource getJpdlResource(IResource resource) {
        if (!resource.getName().endsWith(".gpd.xml")) {
            throw new IllegalArgumentException("jpdl resource can only be obtained for a gpd file");
        }
        return resource.getParent().getFile((IPath)new Path(String.valueOf(this.getProcessName(resource)) + ".jpdl.xml"));
    }

    public void setDestination(IContainer destination) {
        Assert.isNotNull((Object)destination);
        this.destination = destination;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        MultiStatus multi;
        Status temp;
        IStatus result = null;
        if (!this.resourcesToMove[0].isSynchronized(2)) {
            result = new Status(4, "org.eclipse.core.resources", 274, "Resource " + this.resourcesToMove[0].getName() + "is out of sync with file system", null);
        }
        if (!this.resourcesToMove[1].isSynchronized(2)) {
            temp = new Status(4, "org.eclipse.core.resources", 274, "Resource " + this.resourcesToMove[1].getName() + "is out of sync with file system", null);
            if (result == null) {
                result = temp;
            } else {
                multi = new MultiStatus("org.eclipse.core.resources", 274, "the resources are out of sync with file system", null);
                multi.add(result);
                multi.add((IStatus)temp);
                result = multi;
            }
        }
        if (this.resourcesToMove.length == 3 && !this.resourcesToMove[2].isSynchronized(2)) {
            temp = new Status(4, "org.eclipse.core.resources", 274, "Resource " + this.resourcesToMove[2].getName() + "is out of sync with file system", null);
            if (result == null) {
                result = temp;
            } else if (result instanceof MultiStatus) {
                ((MultiStatus)result).add((IStatus)temp);
            } else {
                multi = new MultiStatus("org.eclipse.core.resources", 274, "the resources are out of sync with file system", null);
                multi.add(result);
                multi.add((IStatus)temp);
                result = multi;
            }
        }
        if (result == null) {
            result = Status.OK_STATUS;
        }
        return RefactoringStatus.create((IStatus)result);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask("", 1);
        try {
            RefactoringStatus status = this.validateDestination(this.destination);
            if (status.hasFatalError()) {
                RefactoringStatus refactoringStatus = status;
                return refactoringStatus;
            }
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            int i = 0;
            while (i < this.resourcesToMove.length) {
                IResource resource = this.resourcesToMove[i];
                IResource newResource = this.destination.findMember(resource.getName());
                if (newResource != null) {
                    status.addWarning("'" + this.resourcesToMove[i].getFullPath().toString() + "' already exist. It will be replaced.");
                    deltaFactory.delete(newResource);
                }
                deltaFactory.move(this.resourcesToMove[i], this.destination.getFullPath());
                ++i;
            }
            RefactoringStatus refactoringStatus = status;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus validateDestination(IContainer destination) {
        Assert.isNotNull((Object)destination, (String)"container is null");
        if (destination instanceof IWorkspaceRoot) {
            return RefactoringStatus.createFatalErrorStatus((String)"Invalid parent");
        }
        if (!destination.exists()) {
            return RefactoringStatus.createFatalErrorStatus((String)"Destination does not exist");
        }
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", this.resourcesToMove.length);
        try {
            CompositeChange compositeChange = new CompositeChange("process move");
            compositeChange.markAsSynthetic();
            int i = 0;
            while (i < this.resourcesToMove.length) {
                MoveResourceChange moveChange = new MoveResourceChange(this.resourcesToMove[i], this.destination);
                compositeChange.add((Change)moveChange);
                ++i;
            }
            CompositeChange compositeChange2 = compositeChange;
            return compositeChange2;
        }
        finally {
            pm.done();
        }
    }

    public IResource[] getResourcesToMove() {
        return this.resourcesToMove;
    }

    public String getProcessToMove() {
        return this.getProcessName(this.resourcesToMove[0]);
    }

    public Object[] getElements() {
        return this.resourcesToMove;
    }

    public String getIdentifier() {
        return "org.jbpm.gd.jpdl.refactoring.moveProcessProcessor";
    }

    public String getProcessorName() {
        return "Move Process";
    }

    public boolean isApplicable() {
        int i = 0;
        while (i < this.resourcesToMove.length) {
            if (!MoveProcessProcessor.canMove(this.resourcesToMove[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean canMove(IResource res) {
        return (res instanceof IFile || res instanceof IFolder) && res.exists() && !res.isPhantom();
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        return new RefactoringParticipant[0];
    }
}

