/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.resource.RenameResourceChange;

public class RenameProcessProcessor
extends RenameProcessor {
    private IResource jpdlResource;
    private IResource gpdResource;
    private IResource jpgResource;
    private String newProcessName;
    private boolean updateReferences;

    public RenameProcessProcessor(IResource resource) {
        String newName;
        if (resource == null || !resource.exists()) {
            throw new IllegalArgumentException("resource must not be null and must exist");
        }
        if (this.isJpdlFile(resource)) {
            this.jpdlResource = resource;
            this.gpdResource = this.getGpdResource(resource);
        } else if (this.isGpdFile(resource)) {
            this.jpdlResource = this.getJpdlResource(resource);
            this.gpdResource = resource;
        }
        if (this.jpdlResource != null && this.jpdlResource.exists() && this.gpdResource != null && this.gpdResource.exists()) {
            this.jpgResource = this.getJpgResource(this.jpdlResource);
            this.updateReferences = true;
            newName = this.jpdlResource.getName();
            int i = newName.indexOf(".jpdl.xml");
            if (i != -1) {
                newName = newName.substring(0, i);
            }
        } else {
            throw new IllegalArgumentException("both jpdlFile and gpdFile must not be null and must exist");
        }
        this.setNewProcessName(newName);
    }

    private String getProcessName(IResource resource) {
        String name = resource.getName();
        if (name.startsWith(".") && name.endsWith(".gpd.xml")) {
            return name.substring(1, name.indexOf(".gpd.xml"));
        }
        if (name.endsWith(".jpdl.xml")) {
            return name.substring(0, name.indexOf(".jpdl.xml"));
        }
        throw new IllegalArgumentException("resource must be either a jpdlFile or gpdFile");
    }

    private boolean isJpdlFile(IResource resource) {
        return resource.getName().endsWith(".jpdl.xml");
    }

    private boolean isGpdFile(IResource resource) {
        String name = resource.getName();
        return name.startsWith(".") && name.endsWith(".gpd.xml");
    }

    private IResource getGpdResource(IResource resource) {
        if (!resource.getName().endsWith(".jpdl.xml")) {
            throw new IllegalArgumentException("gpd resource can only be obtained for a jpdl file");
        }
        return resource.getParent().getFile((IPath)new Path("." + this.getProcessName(resource) + ".gpd.xml"));
    }

    private IResource getJpdlResource(IResource resource) {
        if (!resource.getName().endsWith(".gpd.xml")) {
            throw new IllegalArgumentException("jpdl resource can only be obtained for a gpd file");
        }
        return resource.getParent().getFile((IPath)new Path(String.valueOf(this.getProcessName(resource)) + ".jpdl.xml"));
    }

    private IResource getJpgResource(IResource resource) {
        return resource.getParent().getFile((IPath)new Path(String.valueOf(this.getProcessName(resource)) + ".jpg"));
    }

    public String getNewProcessName() {
        return this.newProcessName;
    }

    public void setNewProcessName(String newName) {
        Assert.isNotNull((Object)newName);
        this.newProcessName = newName;
    }

    public boolean isUpdateReferences() {
        return this.updateReferences;
    }

    public void setUpdateReferences(boolean updateReferences) {
        this.updateReferences = updateReferences;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        MultiStatus multi;
        Status temp;
        IStatus result = null;
        if (!this.jpdlResource.isSynchronized(2)) {
            result = new Status(4, "org.eclipse.core.resources", 274, "Resource " + this.jpdlResource.getName() + "is out of sync with file system", null);
        }
        if (!this.gpdResource.isSynchronized(2)) {
            temp = new Status(4, "org.eclipse.core.resources", 274, "Resource " + this.jpdlResource.getName() + "is out of sync with file system", null);
            if (result == null) {
                result = temp;
            } else {
                multi = new MultiStatus("org.eclipse.core.resources", 274, "the resources are out of sync with file system", null);
                multi.add(result);
                multi.add((IStatus)temp);
                result = multi;
            }
        }
        if (!this.jpgResource.isSynchronized(2)) {
            temp = new Status(4, "org.eclipse.core.resources", 274, "Resource " + this.jpgResource.getName() + "is out of sync with file system", null);
            if (result == null) {
                result = temp;
            } else if (result instanceof MultiStatus) {
                ((MultiStatus)result).add((IStatus)temp);
            } else {
                multi = new MultiStatus("org.eclipse.core.resources", 274, "the resources are out of sync with file system", null);
                multi.add(result);
                multi.add((IStatus)temp);
                result = multi;
            }
        }
        if (result == null) {
            result = Status.OK_STATUS;
        }
        return RefactoringStatus.create((IStatus)result);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        pm.beginTask("", 1);
        try {
            ResourceChangeChecker checker = (ResourceChangeChecker)context.getChecker(ResourceChangeChecker.class);
            IResourceChangeDescriptionFactory deltaFactory = checker.getDeltaFactory();
            IPath newJpdlPath = this.jpdlResource.getFullPath().removeLastSegments(1).append(String.valueOf(this.getNewProcessName()) + ".jpdl.xml");
            deltaFactory.move(this.jpdlResource, newJpdlPath);
            IPath newGpdPath = this.gpdResource.getFullPath().removeLastSegments(1).append("." + this.getNewProcessName() + ".gpd.xml");
            deltaFactory.move(this.gpdResource, newGpdPath);
            if (this.jpgResource != null && this.jpgResource.exists()) {
                IPath newJpgPath = this.jpgResource.getFullPath().removeLastSegments(1).append(String.valueOf(this.getNewProcessName()) + ".jpg");
                deltaFactory.move(this.jpgResource, newJpgPath);
            }
            RefactoringStatus refactoringStatus = new RefactoringStatus();
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus validateNewElementName(String newName) {
        Assert.isNotNull((Object)newName, (String)"new name");
        IContainer c = this.jpdlResource.getParent();
        if (c == null) {
            return RefactoringStatus.createFatalErrorStatus((String)"Internal Error");
        }
        if ("".equals(newName)) {
            return RefactoringStatus.createFatalErrorStatus((String)"The name of the process cannot be the empty string");
        }
        if (c.findMember(String.valueOf(newName) + ".jpdl.xml") != null || c.findMember("." + newName + ".gpd.xml") != null) {
            return RefactoringStatus.createFatalErrorStatus((String)"A process with this name already exists");
        }
        if (!c.getFullPath().isValidSegment(String.valueOf(newName) + ".jpdl.xml") || !c.getFullPath().isValidSegment("." + newName + ".gpd.xml")) {
            return RefactoringStatus.createFatalErrorStatus((String)"This is an invalid name for a process");
        }
        RefactoringStatus result = RefactoringStatus.create((IStatus)c.getWorkspace().validateName(newName, this.jpdlResource.getType()));
        if (!result.hasFatalError()) {
            result.merge(RefactoringStatus.create((IStatus)c.getWorkspace().validateName(newName, this.gpdResource.getType())));
        }
        if (!result.hasFatalError()) {
            result.merge(RefactoringStatus.create((IStatus)c.getWorkspace().validatePath(this.createNewPath(this.jpdlResource, String.valueOf(newName) + ".jpdl.xml"), this.jpdlResource.getType())));
        }
        if (!result.hasFatalError()) {
            result.merge(RefactoringStatus.create((IStatus)c.getWorkspace().validatePath(this.createNewPath(this.gpdResource, "." + newName + ".gpd.xml"), this.gpdResource.getType())));
        }
        if (!result.hasFatalError() && this.jpgResource != null && this.jpgResource.exists()) {
            result.merge(RefactoringStatus.create((IStatus)c.getWorkspace().validatePath(this.createNewPath(this.jpgResource, String.valueOf(newName) + ".jpg"), this.jpgResource.getType())));
        }
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 1);
        try {
            CompositeChange compositeChange = new CompositeChange("process rename");
            compositeChange.add((Change)new RenameResourceChange(this.jpdlResource.getFullPath(), String.valueOf(this.getNewProcessName()) + ".jpdl.xml"));
            compositeChange.add((Change)new RenameResourceChange(this.gpdResource.getFullPath(), "." + this.getNewProcessName() + ".gpd.xml"));
            if (this.jpgResource != null && this.jpgResource.exists()) {
                compositeChange.add((Change)new RenameResourceChange(this.jpgResource.getFullPath(), String.valueOf(this.getNewProcessName()) + ".jpg"));
            }
            CompositeChange compositeChange2 = compositeChange;
            return compositeChange2;
        }
        finally {
            pm.done();
        }
    }

    private String createNewPath(IResource resource, String newName) {
        return resource.getFullPath().removeLastSegments(1).append(newName).toString();
    }

    public Object[] getElements() {
        if (this.jpgResource != null && this.jpgResource.exists()) {
            return new Object[]{this.jpdlResource, this.gpdResource, this.jpgResource};
        }
        return new Object[]{this.jpdlResource, this.gpdResource};
    }

    public String getIdentifier() {
        return "org.jbpm.gd.jpdl.refactoring.renameProcessProcessor";
    }

    public String getProcessorName() {
        return "Rename Process";
    }

    public boolean isApplicable() {
        if (this.jpdlResource == null) {
            return false;
        }
        if (!this.jpdlResource.exists()) {
            return false;
        }
        if (!this.jpdlResource.isAccessible()) {
            return false;
        }
        if (this.gpdResource == null) {
            return false;
        }
        if (!this.gpdResource.exists()) {
            return false;
        }
        return this.gpdResource.isAccessible();
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants shared) throws CoreException {
        return new RefactoringParticipant[0];
    }
}

