/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.refactoring;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jbpm.gd.jpdl.refactoring.RenameProcessProcessor;

public class RenameProcessWizard
extends RefactoringWizard {
    public RenameProcessWizard(IResource resource) {
        super((Refactoring)new RenameRefactoring((RenameProcessor)new RenameProcessProcessor(resource)), 4);
        this.setDefaultPageTitle("Rename Process");
        this.setWindowTitle("Rename Process");
    }

    protected void addUserInputPages() {
        RenameProcessProcessor processor = (RenameProcessProcessor)((Object)this.getRefactoring().getAdapter(RenameProcessProcessor.class));
        this.addPage((IWizardPage)new RenameProcessRefactoringConfigurationPage(processor));
    }

    private static class RenameProcessRefactoringConfigurationPage
    extends UserInputWizardPage {
        private final RenameProcessProcessor refactoringProcessor;
        private Text nameField;

        public RenameProcessRefactoringConfigurationPage(RenameProcessProcessor processor) {
            super("RenameResourceRefactoringInputPage");
            this.refactoringProcessor = processor;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setFont(parent.getFont());
            Label label = new Label(composite, 0);
            label.setText("New na&me");
            label.setLayoutData((Object)new GridData());
            this.nameField = new Text(composite, 2048);
            this.nameField.setText(this.refactoringProcessor.getNewProcessName());
            this.nameField.setFont(composite.getFont());
            this.nameField.setLayoutData((Object)new GridData(4, 1, true, false));
            this.nameField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RenameProcessRefactoringConfigurationPage.this.validatePage();
                }
            });
            this.nameField.selectAll();
            this.setPageComplete(false);
            this.setControl((Control)composite);
        }

        public void setVisible(boolean visible) {
            if (visible) {
                this.nameField.setFocus();
            }
            super.setVisible(visible);
        }

        protected final void validatePage() {
            String text = this.nameField.getText();
            RefactoringStatus status = this.refactoringProcessor.validateNewElementName(text);
            this.setPageComplete(status);
        }

        protected boolean performFinish() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.performFinish();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            this.storeSettings();
            return super.getNextPage();
        }

        private void storeSettings() {
        }

        private void initializeRefactoring() {
            this.refactoringProcessor.setNewProcessName(this.nameField.getText());
        }
    }
}

