/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.Controller;
import org.jbpm.gd.jpdl.model.Variable;

public class ControllerDomAdapter
extends XmlAdapter {
    private static HashMap NODE_TYPES = null;

    protected Map getNodeTypes() {
        if (NODE_TYPES == null) {
            NODE_TYPES = new HashMap();
            NODE_TYPES.put("variable", "variable");
            NODE_TYPES.put("genericElement", "genericElement");
        }
        return NODE_TYPES;
    }

    public void initialize(SemanticElement jpdlElement) {
        super.initialize(jpdlElement);
        Controller controller = (Controller)jpdlElement;
        controller.setConfigInfo(this.getTextContent());
        controller.setClassName(this.getAttribute("class"));
        controller.setConfigType(this.getAttribute("config-type"));
        controller.addPropertyChangeListener(this);
    }

    protected void initialize() {
        super.initialize();
        Controller controller = (Controller)this.getSemanticElement();
        if (controller != null) {
            GenericElement[] genericElements = controller.getGenericElements();
            int i = 0;
            while (i < genericElements.length) {
                this.addElement(genericElements[i]);
                ++i;
            }
            this.setTextContent(controller.getConfigInfo());
            this.setAttribute("class", controller.getClassName());
            this.setAttribute("config-type", controller.getConfigType());
            this.addElements(controller.getVariables());
        }
    }

    protected String getDefaultValue(String attributeName) {
        if ("config-type".equals(attributeName)) {
            return "field";
        }
        return super.getDefaultValue(attributeName);
    }

    protected void doPropertyChange(PropertyChangeEvent evt) {
        if ("configInfo".equals(evt.getPropertyName())) {
            this.setTextContent((String)evt.getNewValue());
        } else if ("className".equals(evt.getPropertyName())) {
            this.setAttribute("class", (String)evt.getNewValue());
        } else if ("configType".equals(evt.getPropertyName())) {
            this.setAttribute("config-type", (String)evt.getNewValue());
        } else if ("variableAdd".equals(evt.getPropertyName())) {
            this.addElement((Variable)evt.getNewValue());
        } else if ("variableRemove".equals(evt.getPropertyName())) {
            this.removeElement((Variable)evt.getOldValue());
        } else if ("genericElementAdd".equals(evt.getPropertyName())) {
            this.addElement((SemanticElement)evt.getNewValue());
        } else if ("genericElementRemove".equals(evt.getPropertyName())) {
            this.removeElement((SemanticElement)evt.getOldValue());
        }
    }

    protected void doModelUpdate(String name, String newValue) {
        Controller controller = (Controller)this.getSemanticElement();
        if ("#text".equals(name) && newValue != null) {
            controller.setConfigInfo(newValue);
        } else if ("class".equals(name)) {
            controller.setClassName(newValue);
        } else if ("config-type".equals(name)) {
            controller.setConfigType(newValue);
        }
    }

    protected void doModelAdd(XmlAdapter child) {
        String type = child.getElementType();
        SemanticElement jpdlElement = this.createSemanticElementFor(child);
        child.initialize(jpdlElement);
        Controller controller = (Controller)this.getSemanticElement();
        if ("variable".equals(type)) {
            controller.addVariable((Variable)jpdlElement);
        } else if ("genericElement".equals(type)) {
            controller.addGenericElement((GenericElement)jpdlElement);
        }
    }

    protected SemanticElement createSemanticElementFor(XmlAdapter child) {
        if ("genericElement".equals(child.getElementType())) {
            return this.getSemanticElementFactory().createById("org.jbpm.gd.jpdl.genericElement");
        }
        return super.createSemanticElementFor(child);
    }

    protected void doModelRemove(XmlAdapter child) {
    }

    public void addElement(SemanticElement element) {
        super.addElement(element);
    }
}

