/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.Description;
import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.ExceptionHandler;
import org.jbpm.gd.jpdl.model.MailNode;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Subject;
import org.jbpm.gd.jpdl.model.Text;
import org.jbpm.gd.jpdl.model.Timer;
import org.jbpm.gd.jpdl.model.Transition;

public class MailNodeDomAdapter
extends XmlAdapter {
    private static final String[] CHILD_ELEMENTS = new String[]{"description", "subject", "text", "event", "exception-handler", "timer", "transition"};
    private static HashMap NODE_TYPES = null;

    protected String[] getChildElements() {
        return CHILD_ELEMENTS;
    }

    protected Map getNodeTypes() {
        if (NODE_TYPES == null) {
            NODE_TYPES = new HashMap();
            NODE_TYPES.put("description", "description");
            NODE_TYPES.put("subject", "subject");
            NODE_TYPES.put("text", "text");
            NODE_TYPES.put("event", "event");
            NODE_TYPES.put("exception-handler", "exception-handler");
            NODE_TYPES.put("timer", "timer");
            NODE_TYPES.put("transition", "transition");
        }
        return NODE_TYPES;
    }

    protected String getDefaultValue(String attributeName) {
        if ("async".equals(attributeName)) {
            return "false";
        }
        return super.getDefaultValue(attributeName);
    }

    protected void initialize() {
        super.initialize();
        MailNode mailNode = (MailNode)this.getSemanticElement();
        if (mailNode != null) {
            this.setAttribute("async", mailNode.getAsync());
            this.setAttribute("name", mailNode.getName());
            this.setAttribute("template", mailNode.getTemplate());
            this.setAttribute("actors", mailNode.getActors());
            this.setAttribute("to", mailNode.getTo());
            this.addElement(mailNode.getDescription());
            this.addElement(mailNode.getSubject());
            this.addElement(mailNode.getText());
            this.addElements(mailNode.getEvents());
            this.addElements(mailNode.getExceptionHandlers());
            this.addElements(mailNode.getTimers());
            this.addElements(mailNode.getTransitions());
        }
    }

    public void initialize(SemanticElement jpdlElement) {
        super.initialize(jpdlElement);
        MailNode mailNode = (MailNode)jpdlElement;
        mailNode.setAsync(this.getAttribute("async"));
        mailNode.setName(this.getAttribute("name"));
        mailNode.setTemplate(this.getAttribute("template"));
        mailNode.setActors(this.getAttribute("actors"));
        mailNode.setTo(this.getAttribute("to"));
        mailNode.addPropertyChangeListener(this);
    }

    protected void doPropertyChange(PropertyChangeEvent evt) {
        if ("eventAdd".equals(evt.getPropertyName())) {
            this.addElement((Event)evt.getNewValue());
        } else if ("eventRemove".equals(evt.getPropertyName())) {
            this.removeElement((Event)evt.getOldValue());
        } else if ("exceptionHandlerAdd".equals(evt.getPropertyName())) {
            this.addElement((ExceptionHandler)evt.getNewValue());
        } else if ("exceptionHandlerRemove".equals(evt.getPropertyName())) {
            this.removeElement((ExceptionHandler)evt.getOldValue());
        } else if ("timerAdd".equals(evt.getPropertyName())) {
            this.addElement((Timer)evt.getNewValue());
        } else if ("timerRemove".equals(evt.getPropertyName())) {
            this.removeElement((Timer)evt.getOldValue());
        } else if ("transitionAdd".equals(evt.getPropertyName())) {
            this.addElement((Transition)evt.getNewValue());
        } else if ("transitionRemove".equals(evt.getPropertyName())) {
            this.removeElement((Transition)evt.getOldValue());
        } else if ("description".equals(evt.getPropertyName())) {
            this.setElement("description", (SemanticElement)evt.getOldValue(), (Description)evt.getNewValue());
        } else if ("subject".equals(evt.getPropertyName())) {
            this.setElement("subject", (SemanticElement)evt.getOldValue(), (SemanticElement)evt.getNewValue());
        } else if ("text".equals(evt.getPropertyName())) {
            this.setElement("text", (SemanticElement)evt.getOldValue(), (SemanticElement)evt.getNewValue());
        } else if ("template".equals(evt.getPropertyName())) {
            this.setAttribute("template", (String)evt.getNewValue());
        } else if ("actors".equals(evt.getPropertyName())) {
            this.setAttribute("actors", (String)evt.getNewValue());
        } else if ("to".equals(evt.getPropertyName())) {
            this.setAttribute("to", (String)evt.getNewValue());
        } else if ("subject".equals(evt.getPropertyName())) {
            this.setAttribute("subject", (String)evt.getNewValue());
        } else if ("text".equals(evt.getPropertyName())) {
            this.setAttribute("text", (String)evt.getNewValue());
        } else if ("async".equals(evt.getPropertyName())) {
            this.setAttribute("async", (String)evt.getNewValue());
        } else if ("name".equals(evt.getPropertyName())) {
            this.setAttribute("name", (String)evt.getNewValue());
        }
    }

    protected void doModelUpdate(String name, final String newValue) {
        final MailNode mailNode = (MailNode)this.getSemanticElement();
        if ("name".equals(name)) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    mailNode.setName(newValue);
                }
            });
        } else if ("async".equals(name)) {
            mailNode.setAsync(newValue);
        } else if ("to".equals(name)) {
            mailNode.setTo(newValue);
        } else if ("actors".equals(name)) {
            mailNode.setActors(newValue);
        } else if ("template".equals(name)) {
            mailNode.setTemplate(newValue);
        }
    }

    protected void doModelAdd(XmlAdapter child) {
        String type = child.getElementType();
        SemanticElement jpdlElement = this.createSemanticElementFor(child);
        child.initialize(jpdlElement);
        MailNode mailNode = (MailNode)this.getSemanticElement();
        if ("subject".equals(type)) {
            mailNode.setSubject((Subject)jpdlElement);
        } else if ("text".equals(type)) {
            mailNode.setText((Text)jpdlElement);
        } else if ("event".equals(type)) {
            mailNode.addEvent((Event)jpdlElement);
        } else if ("exception-handler".equals(type)) {
            mailNode.addExceptionHandler((ExceptionHandler)jpdlElement);
        } else if ("timer".equals(type)) {
            mailNode.addTimer((Timer)jpdlElement);
        } else if ("transition".equals(type)) {
            mailNode.addTransition((Transition)jpdlElement);
            ((Transition)jpdlElement).setSource((NodeElement)this.getSemanticElement());
        } else if ("description".equals(this.getNodeType(type))) {
            mailNode.setDescription((Description)jpdlElement);
        }
    }

    protected void doModelRemove(XmlAdapter child) {
        String type = child.getElementType();
        MailNode mailNode = (MailNode)this.getSemanticElement();
        if ("subject".equals(type)) {
            mailNode.setSubject(null);
        } else if ("text".equals(type)) {
            mailNode.setText(null);
        } else if ("event".equals(type)) {
            mailNode.removeEvent((Event)child.getSemanticElement());
        } else if ("exception-handler".equals(type)) {
            mailNode.removeExceptionHandler((ExceptionHandler)child.getSemanticElement());
        } else if ("timer".equals(type)) {
            mailNode.removeTimer((Timer)child.getSemanticElement());
        } else if ("transition".equals(type)) {
            mailNode.removeTransition((Transition)child.getSemanticElement());
        } else if ("description".equals(this.getNodeType(type))) {
            mailNode.setDescription(null);
        }
    }
}

