/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.editor;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.metamodels.webservice.Interface;
import org.teiid.designer.ui.common.eventsupport.IDialogStatusListener;
import org.teiid.designer.ui.common.widget.ScrollableTitleAreaDialog;
import org.teiid.designer.webservice.ui.WebServiceUiPlugin;
import org.teiid.designer.webservice.ui.editor.NewOperationPanel;
import org.teiid.designer.webservice.ui.editor.WebServiceOperation;

public class NewOperationDialog
extends ScrollableTitleAreaDialog
implements IDialogStatusListener {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(NewOperationDialog.class);
    Interface intFace;
    WebServiceOperation operation;
    NewOperationPanel editorPanel;

    private static String getString(String id) {
        return WebServiceUiPlugin.UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public NewOperationDialog(Shell parentShell, Interface intFace) {
        super(parentShell);
        this.intFace = intFace;
        this.operation = new WebServiceOperation("new_operation", this.intFace);
        this.operation.setInputMessageName("input_msg");
        this.operation.setOutputMessageName("output_msg");
    }

    public NewOperationDialog(Shell parentShell, int nColumns) {
        super(parentShell, nColumns);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(NewOperationDialog.getString("title"));
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(NewOperationDialog.getString("title"));
        this.setMessage(NewOperationDialog.getString("initialMessage"));
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridData)composite.getLayoutData()).grabExcessHorizontalSpace = true;
        ((GridData)composite.getLayoutData()).widthHint = 600;
        ((GridData)composite.getLayoutData()).heightHint = 400;
        this.editorPanel = new NewOperationPanel(composite, 0, this.intFace, this.operation, this);
        this.sizeScrolledPanel();
        return composite;
    }

    public WebServiceOperation getOperationData() {
        return this.operation;
    }

    public void notifyStatusChanged(IStatus status) {
        if (status.isOK()) {
            this.setErrorMessage(null);
            this.setMessage(NewOperationDialog.getString("okToCreateOperation"));
        } else if (status.getSeverity() == 2) {
            this.setErrorMessage(null);
            this.setMessage(status.getMessage(), 2);
        } else {
            this.setErrorMessage(status.getMessage());
        }
        this.setOkEnabled(this.editorPanel.canFinish());
    }

    private void setOkEnabled(boolean enabled) {
        this.getButton(0).setEnabled(enabled);
    }
}

