/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.editor;

import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.Viewer;
import org.teiid.designer.ui.util.ModelObjectNotificationHelper;

public class OperationEditorNotifyChangedListener
implements INotifyChangedListener {
    private Viewer viewer;
    private IResource iResource;

    public void initialize(Viewer viewer, IResource iResource) {
        if (this.viewer == null) {
            this.viewer = viewer;
            this.iResource = iResource;
        }
    }

    public void notifyChanged(Notification theNotification) {
        ModelObjectNotificationHelper notificationHelper;
        boolean refreshTree = false;
        if (this.iResource != null && (notificationHelper = new ModelObjectNotificationHelper(theNotification)).shouldHandleNotification()) {
            List changedModels = notificationHelper.getModifiedResources();
            for (Object nextObj : changedModels) {
                if (nextObj == null || !(nextObj instanceof IResource) || !nextObj.equals(this.iResource)) continue;
                refreshTree = true;
                break;
            }
        }
        if (refreshTree) {
            this.viewer.refresh();
        }
    }
}

