/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.editor;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.EditorPart;
import org.teiid.designer.core.loading.ComponentLoadingManager;
import org.teiid.designer.core.loading.IManagedLoading;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.ui.UiConstants;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.editors.AbstractModelEditorPageActionBarContributor;
import org.teiid.designer.ui.editors.INavigationSupported;
import org.teiid.designer.ui.editors.ModelEditor;
import org.teiid.designer.ui.editors.ModelEditorManager;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.editors.ModelEditorPageOutline;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.webservice.WebServicePlugin;
import org.teiid.designer.webservice.ui.editor.OperationEditorNotifyChangedListener;
import org.teiid.designer.webservice.ui.editor.OperationEditorSelectionHandler;
import org.teiid.designer.webservice.ui.util.WebServiceUiUtil;

public final class OperationEditorPage
extends EditorPart
implements ModelEditorPage,
INavigationSupported,
IManagedLoading {
    public static final String PACKAGE_DIAGRAM_TYPE_ID = "packageDiagramType";
    private ModelResource resrc;
    private IWorkbenchWindow wdw;
    private List workspaceSelectionListeners = new ArrayList();
    private Object editingObj;
    private Control ctrl;
    private Control selectedCtrl;
    private OperationEditorSelectionHandler selectionHandler;
    private OperationEditorNotifyChangedListener notifyChangedListener;
    private ModelEditor meParentEditor;
    private boolean editorOpened = false;

    public void addWorkspaceSelectionListener(ISelectionListener listener) {
        this.workspaceSelectionListeners.add(listener);
    }

    public boolean canDisplay(IEditorInput input) {
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            try {
                this.resrc = ModelUtilities.getModelResourceForIFile((IFile)fileInput.getFile(), (boolean)false);
                if (this.resrc.getPrimaryMetamodelDescriptor() != null && "http://www.metamatrix.com/metamodels/WebService".equals(this.resrc.getPrimaryMetamodelDescriptor().getNamespaceURI())) {
                    return true;
                }
            }
            catch (ModelWorkspaceException err) {
                WebServicePlugin.Util.log((Throwable)err);
            }
        }
        return false;
    }

    public IResource getEditorResource() {
        IFileEditorInput fileInput;
        if (this.getEditorInput() instanceof IFileEditorInput && (fileInput = (IFileEditorInput)this.getEditorInput()) != null) {
            return fileInput.getFile();
        }
        return null;
    }

    public boolean canOpenContext(Object input) {
        return !(input instanceof Diagram);
    }

    public void manageLoad(Properties args) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ((CTabFolder)OperationEditorPage.this.ctrl.getParent()).addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        Control cntrl = ((CTabItem)event.item).getControl();
                        if (!cntrl.isDisposed()) {
                            OperationEditorPage.this.updateUi(((CTabItem)event.item).getControl());
                        }
                    }
                });
                OperationEditorPage.this.updateUi(OperationEditorPage.this.selectedCtrl);
            }
        };
        UiUtil.runInSwtThread((Runnable)runnable, (boolean)true);
    }

    public void createPartControl(Composite parent) {
        this.selectedCtrl = this.ctrl = parent;
        ComponentLoadingManager manager = ComponentLoadingManager.getInstance();
        manager.manageLoading((IManagedLoading)this);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public Control getControl() {
        return this.ctrl;
    }

    public AbstractModelEditorPageActionBarContributor getActionBarContributor() {
        return null;
    }

    public ISelectionChangedListener getModelObjectSelectionChangedListener() {
        return this.getSelectionHandler();
    }

    public ISelectionProvider getModelObjectSelectionProvider() {
        return this.getSelectionHandler();
    }

    public INotifyChangedListener getNotifyChangedListener() {
        if (this.notifyChangedListener == null) {
            this.notifyChangedListener = new OperationEditorNotifyChangedListener();
        }
        return this.notifyChangedListener;
    }

    public ModelEditorPageOutline getOutlineContribution() {
        return null;
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.wdw = site.getWorkbenchWindow();
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSelectedFirst(IEditorInput input) {
        return true;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void openComplete() {
    }

    public void initializeEditorPage() {
        this.setEditingObject(null);
    }

    private void setEditingObject(Object someInput) {
        if (someInput == null) {
            IEditorInput input = this.getEditorInput();
            if (input instanceof IFileEditorInput) {
                try {
                    ModelAnnotation obj = ModelUtilities.getModelResourceForIFile((IFile)((IFileEditorInput)input).getFile(), (boolean)false).getModelAnnotation();
                    if (obj != null) {
                        this.editingObj = WebServiceUiUtil.getOperation(obj);
                        if (this.editingObj == null) {
                            this.editingObj = WebServiceUiUtil.getFirstInterface(obj);
                        }
                    }
                }
                catch (ModelWorkspaceException err) {
                    WidgetUtil.showError((Throwable)err);
                    UiConstants.Util.log((Throwable)err);
                }
            }
        } else {
            this.editingObj = WebServiceUiUtil.getOperation(someInput);
            if (this.editingObj == null) {
                this.editingObj = WebServiceUiUtil.getFirstInterface(someInput);
            }
        }
    }

    public void openContext(Object input) {
        this.openContext(input, false);
    }

    public void openContext(Object input, boolean forceRefresh) {
        this.autoSelect();
        this.setEditingObject(input);
        this.openObjectEditor();
    }

    private void openObjectEditor() {
        if (this.editingObj == null) {
            this.setEditingObject(null);
        }
        this.editorOpened = true;
        int hgt = 0;
        Control editorCtrl = this.getControl();
        Composite parent = this.getControl().getParent();
        while (parent != null) {
            Rectangle rect = parent.computeTrim(0, 0, 0, 0);
            hgt += rect.y + rect.height;
            if (parent instanceof SashForm && !parent.isDisposed()) {
                SashForm splitter = (SashForm)parent;
                splitter.setRedraw(false);
                try {
                    Control objEditorCtrl;
                    ModelEditorManager.getModelEditorForFile((IFile)((IFile)this.getEditorResource()), (boolean)false).editModelObject(this.editingObj, null);
                    Control[] controls = splitter.getChildren();
                    Control control = objEditorCtrl = controls[0] == editorCtrl ? controls[1] : controls[0];
                    if (controls[0] == editorCtrl) {
                        editorCtrl.moveBelow(objEditorCtrl);
                    }
                    if (!objEditorCtrl.isVisible()) {
                        objEditorCtrl.setVisible(true);
                        splitter.layout();
                        controls = splitter.getChildren();
                    }
                    splitter.setWeights(new int[]{editorCtrl.getSize().y + objEditorCtrl.getSize().y - hgt, hgt});
                    if (controls.length <= 2) break;
                    controls[2].setVisible(false);
                    break;
                }
                finally {
                    splitter.setRedraw(true);
                }
            }
            editorCtrl = parent;
            parent = parent.getParent();
        }
    }

    public void preDispose() {
        if (this.wdw != null) {
            Iterator iter = this.workspaceSelectionListeners.iterator();
            while (iter.hasNext()) {
                ISelectionListener listener = (ISelectionListener)iter.next();
                this.wdw.getSelectionService().removeSelectionListener(listener);
                iter.remove();
            }
        }
    }

    public void processEvent(EventObject event) {
    }

    public void setFocus() {
    }

    public void setLabelProvider(ILabelProvider provider) {
    }

    public void setTitleText(String title) {
        this.setPartName(title);
    }

    public void updateReadOnlyState(boolean isReadOnly) {
    }

    void updateUi(Control control) {
        if (control == this.selectedCtrl) {
            if (!this.editorOpened) {
                this.openObjectEditor();
            }
            return;
        }
        if (control == this.ctrl) {
            this.openObjectEditor();
        } else if (this.selectedCtrl == this.ctrl) {
            Control ctrlAncestor = this.getControl();
            Composite parent = this.getControl().getParent();
            while (parent != null) {
                if (parent instanceof SashForm) {
                    parent.setRedraw(false);
                    try {
                        Control[] controls = parent.getChildren();
                        if (controls[1] == ctrlAncestor) {
                            controls[0].moveBelow(ctrlAncestor);
                        }
                        if (controls.length > 2) {
                            controls[2].setVisible(true);
                        }
                        ModelEditorManager.closeObjectEditor();
                        break;
                    }
                    finally {
                        parent.setRedraw(true);
                    }
                }
                ctrlAncestor = parent;
                parent = parent.getParent();
            }
        }
        this.selectedCtrl = control;
    }

    public OperationEditorSelectionHandler getSelectionHandler() {
        if (this.selectionHandler == null) {
            this.selectionHandler = new OperationEditorSelectionHandler();
        }
        return this.selectionHandler;
    }

    private void autoSelect() {
        ModelEditorManager.autoSelectEditor((ModelEditor)this.meParentEditor, (ModelEditorPage)this);
    }

    public IMarker createMarker() {
        return null;
    }

    public void setParent(ModelEditor theMeParent) {
        this.meParentEditor = theMeParent;
    }
}

