/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.ArrayUtil;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.metamodels.core.Annotation;
import org.teiid.designer.metamodels.core.AnnotationContainer;
import org.teiid.designer.metamodels.core.CoreFactory;
import org.teiid.designer.metamodels.diagram.Diagram;
import org.teiid.designer.metamodels.transformation.SqlTransformationMappingRoot;
import org.teiid.designer.metamodels.webservice.Input;
import org.teiid.designer.metamodels.webservice.Interface;
import org.teiid.designer.metamodels.webservice.Operation;
import org.teiid.designer.metamodels.webservice.Output;
import org.teiid.designer.metamodels.webservice.WebServiceFactory;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.query.sql.proc.IAssignmentStatement;
import org.teiid.designer.query.sql.proc.IBlock;
import org.teiid.designer.query.sql.proc.IDeclareStatement;
import org.teiid.designer.query.sql.symbol.IElementSymbol;
import org.teiid.designer.transformation.ui.UiPlugin;
import org.teiid.designer.transformation.ui.actions.TransformationSourceManager;
import org.teiid.designer.transformation.ui.editors.SqlPanelDropTargetListener;
import org.teiid.designer.transformation.ui.editors.TransformationObjectEditorPage;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlEditorPanel;
import org.teiid.designer.transformation.util.TransformationHelper;
import org.teiid.designer.ui.common.tree.AbstractTreeContentProvider;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.UiBusyIndicator;
import org.teiid.designer.ui.editors.ModelEditorPage;
import org.teiid.designer.ui.editors.ModelObjectEditorPage;
import org.teiid.designer.ui.editors.MultiPageModelEditor;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.webservice.ui.IInternalUiConstants;
import org.teiid.designer.webservice.ui.WebServiceUiPlugin;
import org.teiid.designer.webservice.ui.editor.InputVariableSection;
import org.teiid.designer.webservice.ui.editor.NewOperationDialog;
import org.teiid.designer.webservice.ui.editor.OperationEditorNotifyChangedListener;
import org.teiid.designer.webservice.ui.editor.OperationEditorPage;
import org.teiid.designer.webservice.ui.editor.VariableEditorDialog;
import org.teiid.designer.webservice.ui.editor.WebServiceOperation;
import org.teiid.designer.webservice.ui.util.WebServiceUiUtil;
import org.teiid.query.ui.sqleditor.component.DisplayNode;
import org.teiid.query.ui.sqleditor.component.QueryDisplayComponent;

public class OperationObjectEditorPage
extends TransformationObjectEditorPage
implements ArrayUtil.Constants,
IInternalUiConstants,
IInternalUiConstants.Images,
CoreStringUtil.Constants {
    private static final String I18N_PFX = I18nUtil.getPropertyPrefix(OperationObjectEditorPage.class);
    public static final String NAME = UTIL.getString(String.valueOf(I18N_PFX) + "name", new Object[0]);
    private static final String OPS_TITLE = UTIL.getString(String.valueOf(I18N_PFX) + "operationsTitle", new Object[0]);
    private static final String PROC_DESC = UTIL.getString(String.valueOf(I18N_PFX) + "procedureDescription", new Object[0]);
    private static final String PROC_TITLE = UTIL.getString(String.valueOf(I18N_PFX) + "procedureTitle", new Object[0]);
    private static final String VARS_DESC = UTIL.getString(String.valueOf(I18N_PFX) + "variablesDescription", new Object[0]);
    private static final String DROP_CONFIRM_TITLE = UTIL.getString(String.valueOf(I18N_PFX) + "dropConfirmTitle", new Object[0]);
    private static final String DROP_CONFIRM_MSG = UTIL.getString(String.valueOf(I18N_PFX) + "dropConfirmMsg", new Object[0]);
    private static final String EDIT = UTIL.getString(String.valueOf(I18N_PFX) + "edit", new Object[0]);
    private static final String EDIT_LABEL = "<html><p>" + UTIL.getString(String.valueOf(I18N_PFX) + "editLabel", (Object)("<a>" + EDIT + "</a>")) + "</p></html>";
    private static final int DFLT_LEFT_H_WGT = 250;
    private static final int DFLT_RIGHT_H_WGT = 750;
    private static final int DFLT_TOP_V_WGT = 250;
    private static final int DFLT_BOTTOM_V_WGT = 750;
    private static final String LEFT_H_WGT_PREF = String.valueOf(I18N_PFX) + "leftHorizontalWeight";
    private static final String RIGHT_H_WGT_PREF = String.valueOf(I18N_PFX) + "rightHorizontalWeight";
    private static final String TOP_V_WGT_PREF = String.valueOf(I18N_PFX) + "leftVerticalWeight";
    private static final String BOTTOM_V_WGT_PREF = String.valueOf(I18N_PFX) + "rightVerticalWeight";
    private TreeViewer opViewer;
    private InputVariableSection varSection;
    private Map declarationsToAssignments;
    Operation selectedOp;
    private FormText editLink;
    private Resource resrc;
    private OperationEditorPage opEditorPage;
    private SashForm hSplitter;
    private SashForm vSplitter;
    private Section sqlPanelSection;
    private Section treeSection;
    private SqlEditorPanel sqlEditorPanel;
    private boolean allowsExternalEdits = true;
    Action createOperationAction;
    Action deleteAction;

    protected boolean allowsMultipleTabs() {
        return false;
    }

    public boolean canClose() {
        return false;
    }

    public boolean canEdit(Object object, IEditorPart editor) {
        return editor instanceof OperationEditorPage;
    }

    protected IAction contributeReconcileAction() {
        return null;
    }

    protected SqlPanelDropTargetListener createDropTargetListener(SqlEditorPanel sqlPanel, SqlTransformationMappingRoot transformation) {
        return new MySqlPanelDropTargetListener(sqlPanel, transformation, this);
    }

    void createEditActionControl(Composite parent) {
        FormToolkit toolkit = WebServiceUiPlugin.getDefault().getFormToolkit(parent.getDisplay());
        this.editLink = WidgetFactory.createFormText((Composite)parent, (FormToolkit)toolkit, (String)EDIT_LABEL, (IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent event) {
                OperationObjectEditorPage.this.editVariables();
            }
        });
        WidgetUtil.disableFormText((FormText)this.editLink);
    }

    protected SqlEditorPanel createSelectEditorForNoUpdate(Composite parent) {
        FillLayout fillLayout = new FillLayout();
        parent.setLayout((Layout)fillLayout);
        Display display = parent.getDisplay();
        FormToolkit toolkit = WebServiceUiPlugin.getDefault().getFormToolkit(display);
        Composite mainBody = toolkit.createForm(parent).getBody();
        mainBody.setLayout((Layout)fillLayout);
        this.hSplitter = new SashForm(mainBody, 256);
        this.treeSection = toolkit.createSection((Composite)this.hSplitter, 256);
        this.treeSection.setText(OPS_TITLE);
        toolkit.paintBordersFor((Composite)this.treeSection);
        this.opViewer = new TreeViewer((Composite)this.treeSection, 768);
        this.treeSection.setClient((Control)this.opViewer.getTree());
        this.opViewer.setContentProvider((IContentProvider)new AbstractTreeContentProvider(){

            public Object[] getChildren(Object parent) {
                return parent instanceof Interface ? ((Interface)parent).getOperations().toArray() : EMPTY_ARRAY;
            }

            public Object[] getElements(Object inputElement) {
                ArrayList interfaces = new ArrayList();
                for (Object obj : (List)inputElement) {
                    if (!(obj instanceof Interface)) continue;
                    interfaces.add(obj);
                }
                return interfaces.toArray();
            }

            public Object getParent(Object element) {
                return element instanceof Operation ? ((Operation)element).getInterface() : null;
            }
        });
        this.opViewer.setLabelProvider((IBaseLabelProvider)ModelUtilities.getEMFLabelProvider());
        this.opEditorPage.getSelectionHandler().initialize(this.opViewer);
        super.setNoUpdatesAllowed(true);
        ((OperationEditorNotifyChangedListener)this.opEditorPage.getNotifyChangedListener()).initialize((Viewer)this.opViewer, this.opEditorPage.getEditorResource());
        final MenuManager columnMenuManager = new MenuManager();
        this.opViewer.getControl().setMenu(columnMenuManager.createContextMenu((Control)parent));
        this.opViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(final SelectionChangedEvent event) {
                UiBusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        columnMenuManager.removeAll();
                        columnMenuManager.add((IAction)(this).OperationObjectEditorPage.this.createOperationAction);
                        columnMenuManager.add((IContributionItem)new Separator());
                        columnMenuManager.add((IAction)(this).OperationObjectEditorPage.this.deleteAction);
                        OperationObjectEditorPage.this.operationSelected(event);
                    }
                });
            }
        });
        this.createOperationAction = new Action("Create Operation"){

            public void run() {
                block9: {
                    boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Create New Operation", (Object)((Object)this));
                    boolean succeeded = false;
                    try {
                        try {
                            OperationObjectEditorPage.this.createOperation();
                            succeeded = true;
                        }
                        catch (ModelWorkspaceException e) {
                            Util.log((Throwable)e);
                            if (!requiredStart) break block9;
                            if (succeeded) {
                                ModelerCore.commitTxn();
                                OperationObjectEditorPage.this.opViewer.refresh();
                                break block9;
                            }
                            ModelerCore.rollbackTxn();
                        }
                    }
                    finally {
                        if (requiredStart) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                                OperationObjectEditorPage.this.opViewer.refresh();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                    }
                }
            }
        };
        this.createOperationAction.setImageDescriptor(WebServiceUiPlugin.getDefault().getImageDescriptor("icons/full/obj16/new_operation.png"));
        this.deleteAction = new Action("Delete"){

            public void run() {
                block9: {
                    boolean requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Create New Operation", (Object)((Object)this));
                    boolean succeeded = false;
                    try {
                        try {
                            IStructuredSelection sel = (IStructuredSelection)OperationObjectEditorPage.this.opViewer.getSelection();
                            EObject eObject = (EObject)sel.getFirstElement();
                            ModelerCore.getModelEditor().delete(eObject);
                            succeeded = true;
                        }
                        catch (ModelerCoreException e) {
                            Util.log((Throwable)e);
                            if (!requiredStart) break block9;
                            if (succeeded) {
                                ModelerCore.commitTxn();
                                OperationObjectEditorPage.this.opViewer.refresh();
                                break block9;
                            }
                            ModelerCore.rollbackTxn();
                        }
                    }
                    finally {
                        if (requiredStart) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                                OperationObjectEditorPage.this.opViewer.refresh();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                    }
                }
            }
        };
        this.deleteAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        this.vSplitter = new SashForm((Composite)this.hSplitter, 512);
        this.declarationsToAssignments = new TreeMap(new Comparator(){

            public int compare(Object object1, Object object2) {
                if (object1 == null) {
                    return -1;
                }
                if (object2 == null) {
                    return 1;
                }
                return ((IDeclareStatement)object1).getVariable().getShortName().compareTo(((IDeclareStatement)object2).getVariable().getShortName());
            }
        });
        this.varSection = new InputVariableSection((Composite)this.vSplitter, VARS_DESC, this){

            @Override
            protected void createActionControls(Composite parent) {
                OperationObjectEditorPage.this.createEditActionControl(parent);
            }
        };
        this.varSection.create();
        this.sqlPanelSection = toolkit.createSection((Composite)this.vSplitter, 384);
        this.sqlPanelSection.setText(PROC_TITLE);
        this.sqlPanelSection.setDescription(PROC_DESC);
        this.sqlEditorPanel = super.createSelectEditorForNoUpdate((Composite)this.sqlPanelSection);
        this.sqlEditorPanel.getTextViewer().getTextWidget().setEnabled(false);
        this.sqlPanelSection.setClient((Control)this.sqlEditorPanel);
        this.sqlEditorPanel.getQueryDisplayComponent().addPropertyListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                OperationObjectEditorPage.this.displayNodeUpdated(((QueryDisplayComponent)event.getSource()).getDisplayNode());
            }
        });
        IPreferenceStore store = WebServiceUiPlugin.getDefault().getPreferenceStore();
        int leftHWgt = store.getInt(LEFT_H_WGT_PREF);
        int rightHWgt = store.getInt(RIGHT_H_WGT_PREF);
        this.hSplitter.setWeights(new int[]{leftHWgt == 0 ? 250 : leftHWgt, rightHWgt == 0 ? 750 : rightHWgt});
        int topVWgt = store.getInt(TOP_V_WGT_PREF);
        int bottomVWgt = store.getInt(BOTTOM_V_WGT_PREF);
        this.vSplitter.setWeights(new int[]{topVWgt == 0 ? 250 : topVWgt, bottomVWgt == 0 ? 750 : bottomVWgt});
        this.sqlPanelSection.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                OperationObjectEditorPage.this.updateWeightPreferences();
            }
        });
        return this.sqlEditorPanel;
    }

    private void setSectionEnabled(Object section, boolean enable) {
        if (section == this.varSection) {
            this.varSection.setEnabled(enable);
        } else if (section == this.sqlPanelSection) {
            if (enable) {
                Color fgdColor = Display.getDefault().getSystemColor(21);
                this.sqlPanelSection.setEnabled(true);
                this.sqlPanelSection.setForeground(fgdColor);
                this.getTextWidget().setEnabled(true);
                this.getTextWidget().setEditable(true);
                this.getTextWidget().setForeground(fgdColor);
                this.editLink.setEnabled(true);
                WidgetUtil.enableFormText((FormText)this.editLink);
                this.editLink.setForeground(fgdColor);
            } else {
                Color fgdColor = Display.getDefault().getSystemColor(18);
                this.sqlPanelSection.setEnabled(false);
                this.sqlPanelSection.setForeground(fgdColor);
                this.getTextWidget().setEnabled(false);
                this.getTextWidget().setEditable(false);
                this.getTextWidget().setForeground(fgdColor);
                this.editLink.setForeground(fgdColor);
                this.editLink.setBackground(Display.getDefault().getSystemColor(1));
                WidgetUtil.disableFormText((FormText)this.editLink);
                this.showMessageArea(false);
            }
        }
    }

    protected List customizeActionList(List initialActionList) {
        initialActionList.remove("ExpandSelect");
        initialActionList.remove("ToggleOptimizer");
        initialActionList.remove("LaunchCriteriaBuilder");
        initialActionList.remove("LaunchExpressionBuilder");
        return initialActionList;
    }

    public boolean deactivate() {
        UiUtil.savePreferences((IPreferenceStore)WebServiceUiPlugin.getDefault().getPreferenceStore());
        return super.deactivate();
    }

    void displayNodeUpdated(DisplayNode root) {
        root.setVisible(true, true);
        for (DisplayNode node2 : root.getChildren()) {
            if (!(node2.getLanguageObject() instanceof IBlock)) continue;
            node2.setVisible(true, true);
            HashMap<IElementSymbol, IDeclareStatement> declarations = new HashMap<IElementSymbol, IDeclareStatement>();
            for (DisplayNode node2 : node2.getChildren()) {
                IAssignmentStatement assignment;
                Object declaration;
                IDeclareStatement declaration2;
                if (node2.getLanguageObject() instanceof IDeclareStatement && (declaration2 = (IDeclareStatement)node2.getLanguageObject()).getVariable().getName().startsWith("VARIABLES.IN_")) {
                    declarations.put(declaration2.getVariable(), declaration2);
                    node2.setVisible(true, true);
                }
                if (!(node2.getLanguageObject() instanceof IAssignmentStatement) && !(node2.getLanguageObject() instanceof IDeclareStatement) || (declaration = declarations.get((assignment = (IAssignmentStatement)node2.getLanguageObject()).getVariable())) == null) continue;
                this.declarationsToAssignments.put(declaration, assignment);
                node2.setVisible(true, true);
            }
            this.varSection.refresh();
            break;
        }
    }

    public void edit(Object object) {
        super.edit(object);
        if (object != null) {
            Resource resrc = ((EObject)object).eResource();
            if (resrc == null && object instanceof Diagram) {
                resrc = ((Diagram)object).getTarget().eResource();
            }
            if (this.resrc == resrc) {
                this.selectOperation(this.getCurrentMappingRoot());
            } else {
                this.resrc = resrc;
                this.updateOperations();
            }
        }
    }

    void editVariables() {
        if (this.editLink.getHyperlinkSettings().getHyperlinkUnderlineMode() == 1) {
            return;
        }
        new VariableEditorDialog(this.getControl().getShell(), this.varSection.getSelection(), this).open();
    }

    public DisplayNode findBlock() {
        return this.findBlock(this.getCurrentSqlEditor().getQueryDisplayComponent().getDisplayNode());
    }

    private DisplayNode findBlock(DisplayNode node) {
        if (node.getLanguageObject() instanceof IBlock) {
            return node;
        }
        Iterator iter = node.getChildren().iterator();
        while (iter.hasNext()) {
            node = this.findBlock((DisplayNode)iter.next());
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public Map getDeclarationsToAssignments() {
        return this.declarationsToAssignments;
    }

    public Object getEditableObject(Object object) {
        Object obj = super.getEditableObject(object);
        if (obj == null) {
            Operation theOp = WebServiceUiUtil.getOperation(object);
            obj = theOp != null && theOp.eResource() != null ? TransformationHelper.getTransformationMappingRoot((EObject)theOp) : WebServiceUiUtil.getFirstInterface(object);
        }
        return obj;
    }

    protected List getSeparatorLocations() {
        ArrayList<Integer> separatorLocs = new ArrayList<Integer>(6);
        separatorLocs.add(new Integer(1));
        separatorLocs.add(new Integer(3));
        separatorLocs.add(new Integer(4));
        separatorLocs.add(new Integer(6));
        return separatorLocs;
    }

    public String getTransformationName() {
        return NAME;
    }

    public void initialize(MultiPageModelEditor editor) {
        for (ModelObjectEditorPage objEditor : editor.getObjectEditors()) {
            if (objEditor == this) continue;
            objEditor.setOverride((ModelObjectEditorPage)this);
        }
        for (ModelEditorPage editorPg : editor.getAllEditors()) {
            if (!(editorPg instanceof OperationEditorPage)) continue;
            this.opEditorPage = (OperationEditorPage)editorPg;
            this.opEditorPage.addWorkspaceSelectionListener(new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    OperationObjectEditorPage.this.workspaceSelectionChanged(selection);
                }
            });
        }
    }

    public boolean isResourceValid() {
        return true;
    }

    void operationSelected(SelectionChangedEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object obj = selection.getFirstElement();
        if (obj instanceof Operation) {
            Operation op = (Operation)obj;
            if (op == this.selectedOp) {
                return;
            }
            ModelResource resrc = ModelUtilities.getModelResourceForModelObject((EObject)op);
            try {
                List transformations = resrc.getModelTransformations().getTransformations((EObject)op);
                if (!transformations.isEmpty()) {
                    this.setSectionEnabled(this.varSection, true);
                    this.setSectionEnabled(this.sqlPanelSection, true);
                    this.declarationsToAssignments.clear();
                    WebServiceUiUtil.initializeProcedure(op, this, false);
                    if (this.selectedOp != null) {
                        boolean dirty = this.isDirty();
                        this.doSave(false);
                        super.edit(transformations.get(0));
                        if (dirty && !this.isDirty()) {
                            this.setDirty(dirty);
                        }
                    } else {
                        super.edit(transformations.get(0));
                    }
                    this.selectedOp = op;
                    this.sqlPanelSection.redraw();
                    return;
                }
            }
            catch (ModelWorkspaceException err) {
                IInternalUiConstants.UTIL.log((Throwable)err);
            }
        } else {
            if (this.selectedOp != null) {
                this.doSave(false);
            }
            super.edit(null);
            this.selectedOp = null;
            this.setSectionEnabled(this.varSection, false);
            this.setSectionEnabled(this.sqlPanelSection, false);
            this.declarationsToAssignments.clear();
            this.varSection.refresh();
            this.sqlPanelSection.redraw();
        }
    }

    public void refreshVariables() {
        this.varSection.refresh();
    }

    private void selectOperation(Object object) {
        Operation op = WebServiceUiUtil.getOperation(object);
        if (op != null && op.eResource() == this.resrc) {
            this.opViewer.setSelection((ISelection)new StructuredSelection((Object)op), true);
        }
    }

    private void updateOperations() {
        UiUtil.runInSwtThread((Runnable)new Runnable(){

            @Override
            public void run() {
                OperationObjectEditorPage.this.updateOperationsInSwtThread();
            }
        }, (boolean)true);
    }

    void updateOperationsInSwtThread() {
        if (!this.opViewer.getTree().isDisposed()) {
            this.opViewer.setInput((Object)this.resrc.getContents());
            this.opViewer.expandAll();
            if (this.getCurrentMappingRoot() != null) {
                this.selectOperation(this.getCurrentMappingRoot());
            }
        }
    }

    void updateWeightPreferences() {
        IPreferenceStore store = WebServiceUiPlugin.getDefault().getPreferenceStore();
        int[] wgts = this.hSplitter.getWeights();
        UiUtil.updateIntegerPreference((String)LEFT_H_WGT_PREF, (int)wgts[0], (int)250, (IPreferenceStore)store);
        UiUtil.updateIntegerPreference((String)RIGHT_H_WGT_PREF, (int)wgts[1], (int)750, (IPreferenceStore)store);
        wgts = this.vSplitter.getWeights();
        UiUtil.updateIntegerPreference((String)TOP_V_WGT_PREF, (int)wgts[0], (int)250, (IPreferenceStore)store);
        UiUtil.updateIntegerPreference((String)BOTTOM_V_WGT_PREF, (int)wgts[1], (int)750, (IPreferenceStore)store);
    }

    void workspaceSelectionChanged(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            this.selectOperation(((IStructuredSelection)selection).getFirstElement());
        }
    }

    boolean confirmSourceReset() {
        boolean resetSource = false;
        IPreferenceStore prefStore = UiPlugin.getDefault().getPreferenceStore();
        boolean disableCallbacks = prefStore.getBoolean("transformation.ui.preference.disableCallbacks");
        if (!disableCallbacks) {
            resetSource = MessageDialog.openQuestion(null, (String)DROP_CONFIRM_TITLE, (String)DROP_CONFIRM_MSG);
        }
        return resetSource;
    }

    public boolean allowsExternalEdits() {
        return this.allowsExternalEdits;
    }

    public void setAllowsExternalEdits(boolean theAllowExternalEdits) {
        this.allowsExternalEdits = theAllowExternalEdits;
    }

    private void createOperation() throws ModelWorkspaceException {
        IStructuredSelection sel = (IStructuredSelection)this.opViewer.getSelection();
        Object obj = sel.getFirstElement();
        Interface intFace = null;
        if (obj instanceof Operation) {
            intFace = ((Operation)obj).getInterface();
        } else if (obj instanceof Interface) {
            intFace = (Interface)obj;
        }
        NewOperationDialog dialog = new NewOperationDialog(this.getControl().getShell(), intFace);
        if (dialog.open() == 0) {
            WebServiceOperation operationData = dialog.getOperationData();
            WebServiceFactory factory = WebServiceFactory.eINSTANCE;
            ModelResource modelResource = ModelUtilities.getModelResource((Object)intFace);
            Operation operation = factory.createOperation();
            operation.setName(operationData.getName());
            intFace.getOperations().add((Object)operation);
            String desc = operationData.getDescription();
            if (desc != null) {
                try {
                    Annotation annotation;
                    AnnotationContainer annotations = null;
                    for (Object next : modelResource.getEmfResource().getContents()) {
                        if (!(next instanceof AnnotationContainer)) continue;
                        annotations = (AnnotationContainer)next;
                        break;
                    }
                    if (annotations == null) {
                        annotations = CoreFactory.eINSTANCE.createAnnotationContainer();
                        modelResource.getEmfResource().getContents().add((Object)annotations);
                    }
                    if ((annotation = annotations.findAnnotation((EObject)operation)) == null) {
                        annotation = CoreFactory.eINSTANCE.createAnnotation();
                        annotations.getAnnotations().add((Object)annotation);
                        annotation.setAnnotatedObject((EObject)operation);
                    }
                    annotation.setDescription(desc);
                }
                catch (ModelWorkspaceException modelWorkspaceException) {
                    Util.log(4, "Error setting description on new resource");
                }
            }
            if (operationData.isIncludeInputMessage()) {
                Input input = factory.createInput();
                input.setName(operationData.getInputMessageName());
                operation.setInput(input);
                input.setContentElement(operationData.getInputContentViaElement());
            }
            if (operationData.isIncludeOutputMessage()) {
                Output output = factory.createOutput();
                output.setName(operationData.getOutputMessageName());
                operation.setOutput(output);
                output.setContentElement(operationData.getOutputContentViaElement());
                output.setXmlDocument(operationData.getXmlDocument());
            }
        }
    }

    public class MySqlPanelDropTargetListener
    extends SqlPanelDropTargetListener {
        SqlEditorPanel sqlPanel;

        public MySqlPanelDropTargetListener(SqlEditorPanel theSqlPanel, SqlTransformationMappingRoot theTransformation, Object theTxnSource) {
            super(theSqlPanel, theTransformation, theTxnSource);
            this.sqlPanel = theSqlPanel;
        }

        protected Point getXYPanelOffset() {
            Point newPt = new Point(3, -8);
            newPt.y += this.sqlPanel.getLocation().y;
            return newPt;
        }

        public boolean isEnabled(DropTargetEvent event) {
            return this.dragSourceIsDocument(event);
        }

        protected boolean isInsertOK(DropTargetEvent event) {
            return this.dragSourceIsDocument(event);
        }

        public void drop(DropTargetEvent event) {
            event.detail = 1;
            final DropTargetEvent dtEvent = event;
            if (this.dragSourceIsDocument(event)) {
                UiBusyIndicator.showWhile(null, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MySqlPanelDropTargetListener.this.executeDropInFrom(MySqlPanelDropTargetListener.this.getEventEObjects(dtEvent));
                        OperationObjectEditorPage.this.edit(((MySqlPanelDropTargetListener)MySqlPanelDropTargetListener.this).OperationObjectEditorPage.this.selectedOp);
                    }
                });
            }
        }

        private boolean dragSourceIsDocument(DropTargetEvent event) {
            boolean result = false;
            List eObjList = this.getEventEObjects(event);
            if (!eObjList.isEmpty() && eObjList.size() == 1) {
                result = eObjList.get(0) instanceof XmlDocument;
            }
            return result;
        }

        public void executeDropInFrom(List dropList) {
            if (dropList.size() != 1) {
                return;
            }
            SqlTransformationMappingRoot transformation = this.getTransformation();
            boolean canAdd = false;
            if (transformation != null) {
                canAdd = TransformationSourceManager.canAdd((EObject)transformation, (List)dropList, (Object)((Object)this));
            }
            if (canAdd) {
                XmlDocument document = null;
                if (!dropList.isEmpty() && dropList.size() == 1 && dropList.get(0) instanceof XmlDocument) {
                    document = (XmlDocument)dropList.get(0);
                }
                if (document != null) {
                    if (this.sqlIsEmpty()) {
                        WebServiceUiUtil.addXmlDocumentAsSource(transformation, document, (Object)this);
                    } else {
                        boolean shouldResetSource = OperationObjectEditorPage.this.confirmSourceReset();
                        if (shouldResetSource) {
                            WebServiceUiUtil.setXmlDocumentAsSource(transformation, document, (Object)this);
                        }
                    }
                }
            } else {
                TransformationSourceManager.warnUserAboutInvalidSources((List)dropList);
            }
        }

        public boolean sqlIsEmpty() {
            DisplayNode firstVisibleNode = this.sqlPanel.getQueryDisplayComponent().getFirstVisibleNode();
            return firstVisibleNode == null;
        }
    }
}

