/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.editor;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NodeInfo;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDParticle;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.core.designer.xml.XPathHelper;
import org.teiid.designer.metamodels.webservice.Input;
import org.teiid.designer.metamodels.webservice.Operation;
import org.teiid.designer.metamodels.xsd.XsdUtil;
import org.teiid.designer.query.sql.lang.ILanguageObject;
import org.teiid.designer.query.sql.proc.IAssignmentStatement;
import org.teiid.designer.query.sql.proc.IDeclareStatement;
import org.teiid.designer.query.sql.proc.IStatement;
import org.teiid.designer.transformation.ui.editors.sqleditor.SqlEditorPanel;
import org.teiid.designer.ui.OverlayImageIcon;
import org.teiid.designer.ui.common.graphics.GlobalUiColorManager;
import org.teiid.designer.ui.common.tree.AbstractTreeContentProvider;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.widget.DefaultTreeViewerController;
import org.teiid.designer.ui.common.widget.Dialog;
import org.teiid.designer.ui.common.widget.ITreeViewerController;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.webservice.procedure.DocumentGenerator;
import org.teiid.designer.webservice.procedure.XsdInstanceNode;
import org.teiid.designer.webservice.ui.IInternalUiConstants;
import org.teiid.designer.webservice.ui.WebServiceUiPlugin;
import org.teiid.designer.webservice.ui.editor.InputVariableSection;
import org.teiid.designer.webservice.ui.editor.OperationObjectEditorPage;
import org.teiid.designer.webservice.ui.util.WebServiceUiUtil;
import org.teiid.designer.webservice.util.WebServiceUtil;
import org.teiid.query.ui.sqleditor.component.DisplayNode;
import org.teiid.query.ui.sqleditor.component.DisplayNodeFactory;

public class VariableEditorDialog
extends Dialog
implements IInternalUiConstants,
IInternalUiConstants.Images,
CoreStringUtil.Constants {
    private static final String I18N_PFX = I18nUtil.getPropertyPrefix(VariableEditorDialog.class);
    private static final WebServiceUiPlugin PLUGIN = WebServiceUiPlugin.getDefault();
    private static final String NULL_ELEMENT_MSG = UTIL.getString(String.valueOf(I18N_PFX) + "nullElementMsg", new Object[0]);
    private static final String NULL_INPUT_MSG = UTIL.getString(String.valueOf(I18N_PFX) + "nullInputMsg", new Object[0]);
    private static final String REQUEST_DOC_DESC = UTIL.getString(String.valueOf(I18N_PFX) + "requestDocumentDescription", new Object[0]);
    private static final String REQUEST_DOC_TITLE = UTIL.getString(String.valueOf(I18N_PFX) + "requestDocumentTitle", new Object[0]);
    private static final String TITLE = UTIL.getString(String.valueOf(I18N_PFX) + "title", new Object[0]);
    private static final String VAR_XPATH_TITLE = String.valueOf(I18N_PFX) + "variableXpathTitle";
    private static final String VARS_DESC = UTIL.getString(String.valueOf(I18N_PFX) + "variablesDescription", new Object[0]);
    private static final String XPATH_TITLE = UTIL.getString(String.valueOf(I18N_PFX) + "xpathTitle", new Object[0]);
    private static final String X_PREF = String.valueOf(I18N_PFX) + "x";
    private static final String Y_PREF = String.valueOf(I18N_PFX) + "y";
    private static final String WTH_PREF = String.valueOf(I18N_PFX) + "width";
    private static final String HGT_PREF = String.valueOf(I18N_PFX) + "height";
    private static final int DFLT_LEFT_H_WGT = 750;
    private static final int DFLT_RIGHT_H_WGT = 250;
    private static final int DFLT_TOP_V_WGT = 750;
    private static final int DFLT_BOTTOM_V_WGT = 250;
    private static final String LEFT_H_WGT_PREF = String.valueOf(I18N_PFX) + "leftHorizontalWeight";
    private static final String RIGHT_H_WGT_PREF = String.valueOf(I18N_PFX) + "rightHorizontalWeight";
    private static final String TOP_V_WGT_PREF = String.valueOf(I18N_PFX) + "leftVerticalWeight";
    private static final String BOTTOM_V_WGT_PREF = String.valueOf(I18N_PFX) + "rightVerticalWeight";
    private OperationObjectEditorPage editor;
    private Input input;
    private XsdInstanceNode rootNode;
    private Map nodesToDeclarations;
    private TreeViewer nodeViewer;
    private InputVariableSection varSection;
    private Section xpathSection;
    private StyledText xpathText;
    private Color normalBkgd;
    private Color recursionBkgd;
    private Set highlightedRecursionItems = new HashSet();
    private IStructuredSelection selection;
    private SashForm hSplitter;
    private SashForm vSplitter;

    public VariableEditorDialog(Shell shell, IStructuredSelection selection, OperationObjectEditorPage editor) {
        super(shell, TITLE);
        XSDElementDeclaration element;
        this.editor = editor;
        this.input = ((Operation)editor.getCurrentMappingRoot().getTarget()).getInput();
        if (this.input != null && (element = this.input.getContentElement()) != null) {
            this.rootNode = new XsdInstanceNode(element);
        }
        this.nodesToDeclarations = new HashMap(editor.getDeclarationsToAssignments().size());
        this.selection = selection;
    }

    private void addDisplayNode(IStatement statement) {
        DisplayNode block = this.editor.findBlock();
        DisplayNode newNode = DisplayNodeFactory.createDisplayNode((DisplayNode)block, (Object)statement);
        if (newNode != null) {
            newNode.setVisible(true, true);
            List newNodes = newNode.getDisplayNodeList();
            DisplayNode ancestor = block;
            while (ancestor != null) {
                List nodes = ancestor.getDisplayNodeList();
                int ndx = 0;
                while (ndx < nodes.size()) {
                    DisplayNode node = (DisplayNode)nodes.get(ndx);
                    if (node.getParent() == block && "BEGIN".equals(node.toString())) {
                        nodes.addAll(ndx + 2, newNodes);
                        break;
                    }
                    ++ndx;
                }
                ancestor = ancestor.getParent();
            }
        }
        SqlEditorPanel editorPanel = this.editor.getCurrentSqlEditor();
        editorPanel.setText(editorPanel.getQueryDisplayComponent().getDisplayNode().toDisplayString());
        editorPanel.setHasPendingChanges();
    }

    protected Control createContents(Composite parent) {
        Control ctrl = super.createContents(parent);
        Button button = this.getButton(1);
        --((GridLayout)button.getParent().getLayout()).numColumns;
        button.dispose();
        IPreferenceStore store = WebServiceUiPlugin.getDefault().getPreferenceStore();
        int wth = store.getInt(WTH_PREF);
        int hgt = store.getInt(HGT_PREF);
        if (wth == 0) {
            this.setSizeRelativeToScreen(60, 50);
        } else {
            this.getShell().setSize(wth, hgt);
        }
        int x = store.getInt(X_PREF);
        int y = store.getInt(Y_PREF);
        if (x == 0) {
            this.setCenterOnDisplay(true);
        } else {
            this.getShell().setLocation(x, y);
        }
        this.getShell().addControlListener((ControlListener)new ControlAdapter(){

            public void controlMoved(ControlEvent event) {
                VariableEditorDialog.this.updateLocationPreferences();
            }

            public void controlResized(ControlEvent event) {
                VariableEditorDialog.this.updateSizePreferences();
            }
        });
        return ctrl;
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        if (this.input == null) {
            WidgetFactory.createStyledTextBox((Composite)parent, (String)NULL_INPUT_MSG);
            return parent;
        }
        if (this.rootNode == null) {
            WidgetFactory.createStyledTextBox((Composite)parent, (String)NULL_ELEMENT_MSG);
            return parent;
        }
        FillLayout fillLayout = new FillLayout();
        parent.setLayout((Layout)fillLayout);
        FormToolkit toolkit = WebServiceUiPlugin.getDefault().getFormToolkit(parent.getDisplay());
        Composite form = toolkit.createForm(parent).getBody();
        form.setLayout((Layout)fillLayout);
        this.vSplitter = new SashForm(form, 512);
        this.hSplitter = WidgetFactory.createSplitter((Composite)this.vSplitter);
        Section section = toolkit.createSection((Composite)this.hSplitter, 384);
        section.setText(REQUEST_DOC_TITLE);
        section.setDescription(REQUEST_DOC_DESC);
        toolkit.paintBordersFor((Composite)section);
        this.nodeViewer = WidgetFactory.createTreeViewer2((Composite)section, (int)32, (ITreeViewerController)new DefaultTreeViewerController(){

            public void checkedStateToggled(TreeItem item) {
                VariableEditorDialog.this.nodeCheckedStateToggled(item);
            }

            public boolean isItemCheckable(TreeItem item) {
                return VariableEditorDialog.this.isNodeCheckable(item);
            }

            public void itemExpanded(TreeExpansionEvent event) {
                VariableEditorDialog.this.nodeExpanded(event);
            }

            public void itemSelected(SelectionChangedEvent event) {
                VariableEditorDialog.this.nodeSelected(event);
            }

            public void update(TreeItem item, boolean checked) {
                VariableEditorDialog.this.nodeUpdated(item);
            }
        });
        section.setClient((Control)this.nodeViewer.getTree());
        this.nodeViewer.setContentProvider((IContentProvider)new AbstractTreeContentProvider(){

            public Object[] getChildren(Object element) {
                return VariableEditorDialog.this.getNodeChildren(element);
            }

            public Object getParent(Object element) {
                return VariableEditorDialog.this.getNodeParent(element);
            }

            public boolean hasChildren(Object element) {
                return VariableEditorDialog.this.getNodeHasChildren(element);
            }
        });
        this.nodeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return VariableEditorDialog.this.getNodeImage(element);
            }

            public String getText(Object element) {
                return VariableEditorDialog.this.getNodeName(element);
            }
        });
        this.varSection = new InputVariableSection((Composite)this.hSplitter, VARS_DESC, this.editor){};
        this.varSection.create();
        this.varSection.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                VariableEditorDialog.this.variableSelected();
            }
        });
        this.xpathSection = toolkit.createSection((Composite)this.vSplitter, 256);
        this.xpathSection.setText(XPATH_TITLE);
        toolkit.paintBordersFor((Composite)this.xpathSection);
        this.xpathText = new StyledText((Composite)this.xpathSection, 64);
        this.xpathText.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.xpathSection.setClient((Control)this.xpathText);
        this.xpathText.setEditable(false);
        IPreferenceStore store = WebServiceUiPlugin.getDefault().getPreferenceStore();
        int leftHWgt = store.getInt(LEFT_H_WGT_PREF);
        int rightHWgt = store.getInt(RIGHT_H_WGT_PREF);
        this.hSplitter.setWeights(new int[]{leftHWgt == 0 ? 750 : leftHWgt, rightHWgt == 0 ? 250 : rightHWgt});
        int topVWgt = store.getInt(TOP_V_WGT_PREF);
        int bottomVWgt = store.getInt(BOTTOM_V_WGT_PREF);
        this.vSplitter.setWeights(new int[]{topVWgt == 0 ? 750 : topVWgt, bottomVWgt == 0 ? 250 : bottomVWgt});
        this.nodeViewer.getTree().getParent().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                VariableEditorDialog.this.updateWeightPreferences();
            }
        });
        this.nodeViewer.setInput((Object)this);
        this.nodeViewer.expandToLevel(2);
        this.normalBkgd = this.nodeViewer.getTree().getItem(0).getBackground();
        this.recursionBkgd = GlobalUiColorManager.getColor((RGB)new RGB(204, 204, 255));
        this.updateNodesToDeclarations();
        this.updateCheckBoxes(this.nodeViewer.getTree().getItems());
        if (this.selection != null && !this.selection.isEmpty()) {
            this.varSection.select((Map.Entry)this.selection.getFirstElement());
        }
        return parent;
    }

    private XsdInstanceNode getNode(NodeInfo node) {
        if (node.getParent() instanceof DocumentInfo) {
            return this.rootNode;
        }
        XsdInstanceNode parent = this.getNode(node.getParent());
        if (parent == null) {
            return null;
        }
        return this.getNode(node.getLocalPart(), node.getURI(), parent);
    }

    private XsdInstanceNode getNode(String name, String namespace, XsdInstanceNode node) {
        XsdInstanceNode[] children = node.getChildren();
        int ndx = 0;
        while (ndx < children.length) {
            XsdInstanceNode child = children[ndx];
            if (child.getResolvedXsdComponent() instanceof XSDModelGroup ? (child = this.getNode(name, namespace, child)) != null : name.equals(child.getName()) && namespace.equals(child.getTargetNamespace())) {
                return child;
            }
            ++ndx;
        }
        return null;
    }

    private XsdInstanceNode getNode(IDeclareStatement declaration) {
        for (Map.Entry nodeEntry : this.nodesToDeclarations.entrySet()) {
            if (!nodeEntry.getValue().equals(declaration)) continue;
            return (XsdInstanceNode)nodeEntry.getKey();
        }
        return null;
    }

    Object[] getNodeChildren(Object element) {
        if (element == this) {
            return new Object[]{this.rootNode};
        }
        return ((XsdInstanceNode)element).getChildren();
    }

    boolean getNodeHasChildren(Object element) {
        XsdInstanceNode node = (XsdInstanceNode)element;
        XsdInstanceNode[] children = node.getChildren();
        XsdInstanceNode ancestor = node.getParent();
        while (ancestor != null) {
            if (ancestor.isRecursive()) {
                this.nodeViewer.update((Object)ancestor, null);
            }
            ancestor = ancestor.getParent();
        }
        return children.length > 0;
    }

    Image getNodeImage(Object element) {
        Image img;
        XsdInstanceNode node = (XsdInstanceNode)element;
        XSDConcreteComponent comp = node.getXsdComponent();
        if (comp instanceof XSDParticle) {
            XSDParticle particle = (XSDParticle)comp;
            img = ModelUtilities.getEMFLabelProvider().getImage((Object)particle.getTerm());
            int min = XsdUtil.getMinOccurs((XSDComponent)particle);
            int max = XsdUtil.getMaxOccurs((XSDComponent)particle);
            if (min != 1 || max != 1) {
                Image overlay = min == 0 ? (max == 0 ? PLUGIN.getImage("icons/full/ovr16/occursZero.gif") : (max == 1 ? PLUGIN.getImage("icons/full/ovr16/occursZeroToOne.gif") : (max > 1 ? PLUGIN.getImage("icons/full/ovr16/occursZeroToN.gif") : PLUGIN.getImage("icons/full/ovr16/occursZeroToUnbounded.gif")))) : (min == 1 ? (max > 1 ? PLUGIN.getImage("icons/full/ovr16/occursOneToN.gif") : PLUGIN.getImage("icons/full/ovr16/occursOneToUnbounded.gif")) : (max == min ? PLUGIN.getImage("icons/full/ovr16/occursN.gif") : (max > min ? PLUGIN.getImage("icons/full/ovr16/occursNToM.gif") : PLUGIN.getImage("icons/full/ovr16/occursNToUnbounded.gif"))));
                img = new OverlayImageIcon(img, overlay, 2).getImage();
            }
        } else {
            img = ModelUtilities.getEMFLabelProvider().getImage((Object)comp);
        }
        if (node.isRecursive()) {
            return new OverlayImageIcon(img, PLUGIN.getImage("icons/full/ovr16/recursive.gif"), 1).getImage();
        }
        return img;
    }

    String getNodeName(Object element) {
        XsdInstanceNode node = (XsdInstanceNode)element;
        XSDConcreteComponent comp = node.getXsdComponent();
        if (comp instanceof XSDParticle) {
            comp = ((XSDParticle)comp).getTerm();
        }
        return ModelUtilities.getEMFLabelProvider().getText((Object)comp);
    }

    Object getNodeParent(Object element) {
        return ((XsdInstanceNode)element).getParent();
    }

    private void highlightRecursionItems(TreeItem item, TreeItem selectedItem) {
        XSDConcreteComponent comp = ((XsdInstanceNode)item.getData()).getXsdComponent();
        if (comp instanceof XSDParticle) {
            comp = ((XSDParticle)comp).getTerm();
        }
        this.highlightRecursionItems(item, selectedItem, comp);
    }

    private void highlightRecursionItems(TreeItem item, TreeItem selectedItem, XSDConcreteComponent rootComponent) {
        TreeItem[] items = item.getItems();
        int ndx = items.length;
        while (--ndx >= 0) {
            XsdInstanceNode childNode;
            TreeItem childItem = items[ndx];
            if (childItem != selectedItem && (childNode = (XsdInstanceNode)childItem.getData()).isRecursive()) {
                XSDConcreteComponent childComp = childNode.getXsdComponent();
                if (childComp instanceof XSDParticle) {
                    childComp = ((XSDParticle)childComp).getTerm();
                }
                if (childComp == rootComponent) {
                    this.highlightedRecursionItems.add(childItem);
                    childItem.setBackground(this.recursionBkgd);
                }
            }
            if (!childItem.getExpanded()) continue;
            this.highlightRecursionItems(childItem, selectedItem, rootComponent);
        }
    }

    private boolean isDescendentOf(DisplayNode node, DisplayNode ancestor) {
        if (node == ancestor) {
            return true;
        }
        DisplayNode parent = node.getParent();
        if (parent == null) {
            return false;
        }
        return this.isDescendentOf(parent, ancestor);
    }

    boolean isNodeCheckable(TreeItem item) {
        return ((XsdInstanceNode)item.getData()).isSelectable();
    }

    void nodeCheckedStateToggled(TreeItem item) {
        XsdInstanceNode node = (XsdInstanceNode)item.getData();
        node.setSelected(item.getChecked());
        if (item.getChecked()) {
            IDeclareStatement declaration = WebServiceUiUtil.createDeclareStatement(node, this.input);
            this.nodesToDeclarations.put(node, declaration);
            WebServiceUiUtil.ensureVariablesUnique(this.nodesToDeclarations);
            this.editor.getDeclarationsToAssignments().put(declaration, declaration);
            this.addDisplayNode((IStatement)declaration);
        } else {
            this.removeVariableStatements((IDeclareStatement)this.nodesToDeclarations.remove(node));
        }
        this.varSection.refresh();
        this.editor.refreshVariables();
        this.editor.getCurrentSqlEditor().setHasPendingChanges();
    }

    void nodeExpanded(TreeExpansionEvent event) {
        TreeItem item = WidgetUtil.findTreeItem((Object)event.getElement(), (TreeViewer)this.nodeViewer);
        this.updateCheckBoxes(item.getItems());
    }

    void nodeSelected(SelectionChangedEvent event) {
        for (TreeItem item : this.highlightedRecursionItems) {
            item.setBackground(this.normalBkgd);
        }
        this.nodeViewer.update(this.highlightedRecursionItems.toArray(), null);
        this.highlightedRecursionItems.clear();
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        if (!selection.isEmpty()) {
            IDeclareStatement declaration;
            XsdInstanceNode node = (XsdInstanceNode)selection.getFirstElement();
            if (node.isRecursive()) {
                XsdInstanceNode recursionRoot = node.findRecursionRoot();
                TreeItem item = WidgetUtil.findTreeItem((Object)node, (TreeViewer)this.nodeViewer);
                if (recursionRoot == null) {
                    recursionRoot = node;
                    this.highlightRecursionItems(item, item);
                } else {
                    TreeItem recursionItem = WidgetUtil.findTreeItem((Object)recursionRoot, (TreeViewer)this.nodeViewer);
                    this.highlightedRecursionItems.add(recursionItem);
                    recursionItem.setBackground(this.recursionBkgd);
                    this.highlightRecursionItems(recursionItem, item);
                }
                this.nodeViewer.update(this.highlightedRecursionItems.toArray(), null);
            }
            if ((declaration = (IDeclareStatement)this.nodesToDeclarations.get(node)) != null) {
                for (Map.Entry entry : this.editor.getDeclarationsToAssignments().entrySet()) {
                    if (entry.getKey() != declaration) continue;
                    this.varSection.select(entry);
                    break;
                }
            } else {
                this.varSection.clearSelection();
            }
        }
    }

    void nodeUpdated(TreeItem item) {
        if (item.getGrayed()) {
            item.setChecked(false);
        }
    }

    private void removeVariableStatements(IDeclareStatement declaration) {
        IAssignmentStatement assignment = (IAssignmentStatement)this.editor.getDeclarationsToAssignments().remove(declaration);
        DisplayNode block = this.editor.findBlock();
        if (block != null) {
            Iterator childIter = block.getChildren().iterator();
            while (childIter.hasNext()) {
                ILanguageObject obj;
                DisplayNode blockChild = (DisplayNode)childIter.next();
                if (!(blockChild.getLanguageObject() instanceof IDeclareStatement) && !(blockChild.getLanguageObject() instanceof IAssignmentStatement) || (obj = blockChild.getLanguageObject()) != declaration && obj != assignment) continue;
                childIter.remove();
                DisplayNode displayNode = block;
                while (displayNode != null) {
                    Iterator nodeIter = displayNode.getDisplayNodeList().iterator();
                    while (nodeIter.hasNext()) {
                        if (!this.isDescendentOf((DisplayNode)nodeIter.next(), blockChild)) continue;
                        nodeIter.remove();
                    }
                    displayNode = displayNode.getParent();
                }
                if (obj == assignment) break;
            }
        }
        SqlEditorPanel editorPanel = this.editor.getCurrentSqlEditor();
        editorPanel.setText(editorPanel.getQueryDisplayComponent().getDisplayNode().toDisplayString());
        editorPanel.setHasPendingChanges();
    }

    private void updateCheckBoxes(TreeItem[] items) {
        int ndx = items.length;
        while (--ndx >= 0) {
            TreeItem item = items[ndx];
            XsdInstanceNode node = (XsdInstanceNode)item.getData();
            if (!node.isSelectable()) {
                item.setGrayed(true);
            } else if (node.isSelected()) {
                item.setChecked(true);
            }
            if (!item.getExpanded()) continue;
            this.updateCheckBoxes(item.getItems());
        }
    }

    void updateDeletedNodes(List entries) {
        for (Map.Entry varEntry : entries) {
            IDeclareStatement declaration = (IDeclareStatement)varEntry.getKey();
            Iterator nodeIter = this.nodesToDeclarations.entrySet().iterator();
            while (nodeIter.hasNext()) {
                Map.Entry nodeEntry = nodeIter.next();
                if (nodeEntry.getValue() != declaration) continue;
                nodeIter.remove();
                XsdInstanceNode node = (XsdInstanceNode)nodeEntry.getKey();
                node.setSelected(false);
                WidgetUtil.findTreeItem((Object)node, (TreeViewer)this.nodeViewer).setChecked(false);
                this.removeVariableStatements(declaration);
            }
        }
        this.editor.refreshVariables();
    }

    void updateLocationPreferences() {
        IPreferenceStore store = WebServiceUiPlugin.getDefault().getPreferenceStore();
        Point loc = this.getShell().getLocation();
        UiUtil.updateIntegerPreference((String)X_PREF, (int)loc.x, (int)0, (IPreferenceStore)store);
        UiUtil.updateIntegerPreference((String)Y_PREF, (int)loc.y, (int)0, (IPreferenceStore)store);
    }

    void updateNodesToDeclarations() {
        String doc = DocumentGenerator.SHARED.generate(this.rootNode);
        this.nodesToDeclarations.clear();
        for (Map.Entry entry : this.editor.getDeclarationsToAssignments().entrySet()) {
            try {
                XsdInstanceNode node;
                NodeInfo saxonNode;
                Object obj = XPathHelper.getSingleMatch((Reader)new StringReader(doc), (String)WebServiceUtil.getXpath((IAssignmentStatement)((IAssignmentStatement)entry.getValue())));
                if (!(obj instanceof NodeInfo) || (saxonNode = (NodeInfo)obj).getNodeKind() != 1 && saxonNode.getNodeKind() != 2 || (node = this.getNode(saxonNode)) == null || !node.isSelectable()) continue;
                node.setSelected(true);
                this.nodesToDeclarations.put(node, entry.getKey());
            }
            catch (Exception exception) {}
        }
        this.editor.refreshVariables();
    }

    void updateSizePreferences() {
        IPreferenceStore store = WebServiceUiPlugin.getDefault().getPreferenceStore();
        Point loc = this.getShell().getSize();
        UiUtil.updateIntegerPreference((String)WTH_PREF, (int)loc.x, (int)0, (IPreferenceStore)store);
        UiUtil.updateIntegerPreference((String)HGT_PREF, (int)loc.y, (int)0, (IPreferenceStore)store);
    }

    void updateWeightPreferences() {
        IPreferenceStore store = WebServiceUiPlugin.getDefault().getPreferenceStore();
        int[] wgts = this.hSplitter.getWeights();
        UiUtil.updateIntegerPreference((String)LEFT_H_WGT_PREF, (int)wgts[0], (int)750, (IPreferenceStore)store);
        UiUtil.updateIntegerPreference((String)RIGHT_H_WGT_PREF, (int)wgts[1], (int)250, (IPreferenceStore)store);
        wgts = this.vSplitter.getWeights();
        UiUtil.updateIntegerPreference((String)TOP_V_WGT_PREF, (int)wgts[0], (int)750, (IPreferenceStore)store);
        UiUtil.updateIntegerPreference((String)BOTTOM_V_WGT_PREF, (int)wgts[1], (int)250, (IPreferenceStore)store);
    }

    void variableSelected() {
        IStructuredSelection selection = this.varSection.getSelection();
        if (selection.isEmpty() || selection.size() > 1) {
            this.xpathSection.setText(XPATH_TITLE);
            this.xpathText.setText("");
        } else {
            Map.Entry varEntry = (Map.Entry)selection.getFirstElement();
            IDeclareStatement declaration = (IDeclareStatement)varEntry.getKey();
            this.xpathSection.setText(UTIL.getString(VAR_XPATH_TITLE, (Object)declaration.getVariable().getShortName()));
            this.xpathSection.layout();
            IAssignmentStatement assignment = (IAssignmentStatement)varEntry.getValue();
            this.xpathText.setText(WebServiceUtil.getXpath((IAssignmentStatement)assignment));
            XsdInstanceNode node = this.getNode(declaration);
            if (node != null) {
                WidgetUtil.select((Object)node, (Viewer)this.nodeViewer);
            }
        }
    }
}

