/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDElementDeclaration;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.metamodels.relational.aspects.validation.RelationalStringNameValidator;
import org.teiid.designer.metamodels.webservice.Interface;
import org.teiid.designer.metamodels.xml.XmlDocument;
import org.teiid.designer.relational.model.RelationalReference;
import org.teiid.designer.webservice.ui.WebServiceUiPlugin;

public class WebServiceOperation
extends RelationalReference {
    String inputMessageName;
    String outputMessageName;
    XSDElementDeclaration inputContentViaElement;
    XSDElementDeclaration outputContentViaElement;
    XmlDocument xmlDocument;
    List<String> existingNames;
    private String transformationSQL;
    private boolean includeInputMessage = true;
    private boolean includeOutputMessage = true;

    public WebServiceOperation() {
        this.setType(14);
        this.setNameValidator((StringNameValidator)new RelationalStringNameValidator(false));
    }

    public WebServiceOperation(String name, Interface intFace) {
        super(name);
        this.setType(14);
        this.setNameValidator((StringNameValidator)new RelationalStringNameValidator(false));
        this.init(intFace);
    }

    private void init(Interface intFace) {
        this.existingNames = new ArrayList<String>();
        for (Object oper : intFace.getOperations()) {
            String name = ModelerCore.getModelEditor().getName((EObject)oper);
            this.existingNames.add(name.toUpperCase());
        }
        String name = this.getName();
        this.setName(this.getNewUniqueName(name));
    }

    public void setTransformationSQL(String sql) {
        this.transformationSQL = sql;
    }

    public String getTransformationSQL() {
        return this.transformationSQL;
    }

    public String getInputMessageName() {
        return this.inputMessageName;
    }

    public void setInputMessageName(String inputMessageName) {
        this.inputMessageName = inputMessageName;
    }

    public String getOutputMessageName() {
        return this.outputMessageName;
    }

    public void setOutputMessageName(String outputMessageName) {
        this.outputMessageName = outputMessageName;
    }

    public XSDElementDeclaration getInputContentViaElement() {
        return this.inputContentViaElement;
    }

    public void setInputContentViaElement(XSDElementDeclaration inputContentViaElement) {
        this.inputContentViaElement = inputContentViaElement;
    }

    public XSDElementDeclaration getOutputContentViaElement() {
        return this.outputContentViaElement;
    }

    public void setOutputContentViaElement(XSDElementDeclaration outputContentViaElement) {
        this.outputContentViaElement = outputContentViaElement;
    }

    public XmlDocument getXmlDocument() {
        return this.xmlDocument;
    }

    public void setXmlDocument(XmlDocument xmlDocument) {
        this.xmlDocument = xmlDocument;
    }

    public void validate() {
        super.validate();
        if (this.getStatus().getSeverity() == 4) {
            return;
        }
        if (this.existingNames.contains(this.getName().toUpperCase())) {
            this.setStatus((IStatus)new Status(4, "org.teiid.designer.webservice.ui", WebServiceUiPlugin.UTIL.getString("WebServiceOperation.validate_nameAlreadyExists", (Object)this.getName())));
            return;
        }
        if (StringUtilities.isEmpty((String)this.inputMessageName)) {
            this.setStatus((IStatus)new Status(2, "org.teiid.designer.webservice.ui", WebServiceUiPlugin.UTIL.getString("WebServiceOperation.validate_inputMessageEmptyOrNull", new Object[0])));
            return;
        }
        if (StringUtilities.isEmpty((String)this.outputMessageName)) {
            this.setStatus((IStatus)new Status(2, "org.teiid.designer.webservice.ui", WebServiceUiPlugin.UTIL.getString("WebServiceOperation.validate_outputMessageEmptyOrNull", new Object[0])));
            return;
        }
        if (this.inputContentViaElement == null) {
            this.setStatus((IStatus)new Status(2, "org.teiid.designer.webservice.ui", WebServiceUiPlugin.UTIL.getString("WebServiceOperation.validate_inputContentViaElementNull", new Object[0])));
            return;
        }
        if (this.outputContentViaElement == null) {
            this.setStatus((IStatus)new Status(2, "org.teiid.designer.webservice.ui", WebServiceUiPlugin.UTIL.getString("WebServiceOperation.validate_outputContentViaElementNull", new Object[0])));
            return;
        }
        if (this.xmlDocument == null) {
            this.setStatus((IStatus)new Status(2, "org.teiid.designer.webservice.ui", WebServiceUiPlugin.UTIL.getString("WebServiceOperation.validate_outputXmlDocumentNull", new Object[0])));
            return;
        }
    }

    private String getNewUniqueName(String proposedName) {
        if (this.existingNames.contains(proposedName.toUpperCase())) {
            int count = 1;
            String newName = String.valueOf(proposedName) + '_' + Integer.toString(count);
            while (this.existingNames.contains(newName.toUpperCase()) && count < 20) {
                ++count;
                if (!this.existingNames.contains(newName.toUpperCase())) {
                    return newName;
                }
                newName = String.valueOf(proposedName) + '_' + Integer.toString(count);
            }
            return newName;
        }
        return proposedName;
    }

    public boolean isIncludeInputMessage() {
        return this.includeInputMessage;
    }

    public void setIncludeInputMessage(boolean includeInputMessage) {
        this.includeInputMessage = includeInputMessage;
    }

    public boolean isIncludeOutputMessage() {
        return this.includeOutputMessage;
    }

    public void setIncludeOutputMessage(boolean includeOutputMessage) {
        this.includeOutputMessage = includeOutputMessage;
    }
}

