/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.wizard;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.util.FileUrl;
import org.teiid.designer.ui.common.eventsupport.SelectionUtilities;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.webservice.IWebServiceModelBuilder;
import org.teiid.designer.webservice.IWebServiceResource;
import org.teiid.designer.webservice.ui.IInternalUiConstants;
import org.teiid.designer.webservice.ui.util.WebServiceUiUtil;
import org.teiid.designer.webservice.ui.wizard.ShowDependenciesDialog;

public final class NamespaceResolutionPage
extends AbstractWizardPage
implements IInternalUiConstants,
IInternalUiConstants.HelpContexts,
IInternalUiConstants.Images {
    static final String PREFIX = I18nUtil.getPropertyPrefix(NamespaceResolutionPage.class);
    private static final String[] TBL_HDRS;
    static final int ERROR_COLUMN;
    static final int NAMESPACE_COLUMN;
    static final int PATH_COLUMN;
    private final int MAIN_PANEL_COLUMNS = 2;
    private IWebServiceModelBuilder builder;
    private IAction copyAction;
    IAction viewAction;
    private IAction showDependenciesAction;
    private TableViewer viewer;

    static {
        ERROR_COLUMN = 0;
        NAMESPACE_COLUMN = 1;
        PATH_COLUMN = 2;
        TBL_HDRS = new String[3];
        NamespaceResolutionPage.TBL_HDRS[NamespaceResolutionPage.ERROR_COLUMN] = "";
        NamespaceResolutionPage.TBL_HDRS[NamespaceResolutionPage.NAMESPACE_COLUMN] = NamespaceResolutionPage.getString("tableColumn.namespace");
        NamespaceResolutionPage.TBL_HDRS[NamespaceResolutionPage.PATH_COLUMN] = NamespaceResolutionPage.getString("tableColumn.path");
    }

    public NamespaceResolutionPage(IWebServiceModelBuilder theBuilder) {
        super(NamespaceResolutionPage.class.getSimpleName(), NamespaceResolutionPage.getString("title"));
        this.builder = theBuilder;
        this.setImageDescriptor(WebServiceUiUtil.getImageDescriptor("icons/full/wizban/WebService.gif"));
        this.setPageComplete(true);
    }

    public void createControl(Composite theParent) {
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        pnlMain.setLayout((Layout)new GridLayout(2, false));
        this.setControl((Control)pnlMain);
        IWorkbenchHelpSystem helpSystem = UiUtil.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)pnlMain, "org.teiid.designer.webservice.ui.namespaceResolutionPage");
        this.createTablePanel(pnlMain);
    }

    private void createTableActions(IToolBarManager theToolBarMgr) {
        this.copyAction = new Action(NamespaceResolutionPage.getString("action.copy"), 1){

            public void run() {
                NamespaceResolutionPage.this.handleCopyWsdlInfo();
            }
        };
        this.copyAction.setImageDescriptor(WebServiceUiUtil.getSharedImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setDisabledImageDescriptor(WebServiceUiUtil.getSharedImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setHoverImageDescriptor(WebServiceUiUtil.getSharedImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setToolTipText(NamespaceResolutionPage.getString("action.copy.tip"));
        this.copyAction.setEnabled(false);
        theToolBarMgr.add(this.copyAction);
        this.viewAction = new Action(NamespaceResolutionPage.getString("action.viewNamespace"), 1){

            public void run() {
                NamespaceResolutionPage.this.handleViewNamespace();
            }
        };
        this.viewAction.setImageDescriptor(WebServiceUiUtil.getSharedImageDescriptor("IMG_OBJ_FILE"));
        this.viewAction.setToolTipText(NamespaceResolutionPage.getString("action.viewNamespace.tip"));
        this.viewAction.setEnabled(false);
        theToolBarMgr.add(this.viewAction);
        this.showDependenciesAction = new Action(NamespaceResolutionPage.getString("action.showDependencies"), 1){

            public void run() {
                NamespaceResolutionPage.this.handleShowDependencies();
            }
        };
        this.showDependenciesAction.setImageDescriptor(WebServiceUiUtil.getImageDescriptor("icons/full/cview16/show_dependencies.gif"));
        this.showDependenciesAction.setToolTipText(NamespaceResolutionPage.getString("action.showDependencies.tip"));
        this.showDependenciesAction.setEnabled(false);
        theToolBarMgr.add(this.showDependenciesAction);
        theToolBarMgr.update(true);
    }

    protected void createTableContextMenu() {
        MenuManager mgr = new MenuManager();
        mgr.add(this.copyAction);
        mgr.add(this.viewAction);
        mgr.add(this.showDependenciesAction);
        Control table = this.viewer.getControl();
        table.setMenu(mgr.createContextMenu(table));
    }

    private void createTablePanel(Composite theParent) {
        ViewForm viewForm = WidgetFactory.createViewForm((Composite)theParent, (int)2048, (int)1808, (int)1);
        viewForm.setTopLeft((Control)WidgetFactory.createLabel((Composite)viewForm, (String)NamespaceResolutionPage.getString("label.tableViewForm")));
        Composite pnl = WidgetFactory.createPanel((Composite)viewForm, (int)0, (int)1808, (int)1, (int)1);
        viewForm.setContent((Control)pnl);
        int style = 68354;
        this.viewer = WidgetFactory.createTableViewer((Composite)pnl, (int)style);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent theEvent) {
                NamespaceResolutionPage.this.handleRowSelected();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent theEvent) {
                if (NamespaceResolutionPage.this.viewAction.isEnabled()) {
                    NamespaceResolutionPage.this.viewAction.run();
                }
            }
        });
        Table tbl = this.viewer.getTable();
        tbl.setHeaderVisible(true);
        tbl.setLinesVisible(true);
        int i = 0;
        while (i < TBL_HDRS.length) {
            TableColumn col = new TableColumn(tbl, 16384);
            col.setText(TBL_HDRS[i]);
            col.pack();
            if (i == ERROR_COLUMN) {
                col.setResizable(false);
                col.setImage(WebServiceUiUtil.getImage("icons/full/cview16/resolution_status.gif"));
            }
            ++i;
        }
        this.createTableActions(WidgetFactory.createViewFormToolBar((ViewForm)viewForm));
        this.createTableContextMenu();
    }

    private static String getString(String theKey) {
        return UTIL.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), new Object[0]);
    }

    IWebServiceModelBuilder getBuilder() {
        return this.builder;
    }

    File getFile(File file) {
        Object url = null;
        Map urlMap = this.builder.getUrlMap();
        if (file != null && urlMap != null) {
            String key = file.getAbsolutePath();
            url = urlMap.get(key);
        }
        if (url == null) {
            return file;
        }
        FileUrl fileUrl = new FileUrl(file.toURI());
        fileUrl.setOriginalUrlString(url.toString());
        return fileUrl;
    }

    void handleCopyWsdlInfo() {
        WebServiceUiUtil.copyToClipboard(this.viewer.getSelection());
    }

    void handleRowSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        boolean singleSelection = SelectionUtilities.isSingleSelection((ISelection)selection);
        this.copyAction.setEnabled(!selection.isEmpty());
        boolean enable = false;
        if (!selection.isEmpty()) {
            List resources = SelectionUtilities.getSelectedObjects((ISelection)selection);
            int size = resources.size();
            int i = 0;
            while (i < size) {
                IWebServiceResource resource = (IWebServiceResource)resources.get(i);
                if (resource.isResolved()) {
                    enable = true;
                    break;
                }
                ++i;
            }
        }
        enable = singleSelection;
        if (singleSelection) {
            IWebServiceResource resource = (IWebServiceResource)SelectionUtilities.getSelectedObject((ISelection)selection);
            enable = resource.isResolved();
        }
        this.viewAction.setEnabled(enable);
    }

    void handleShowDependencies() {
        new ShowDependenciesDialog(this.getShell(), this.builder).open();
    }

    void handleViewNamespace() {
        WebServiceUiUtil.viewFile(this.getShell(), this.viewer.getSelection());
    }

    private void packTableColumns() {
        Table tbl = this.viewer.getTable();
        int i = 0;
        while (i < TBL_HDRS.length) {
            tbl.getColumn(i).pack();
            ++i;
        }
    }

    private void setPageStatus() {
        IStatus status = this.builder.validateWSDLNamespaces();
        if (status.getSeverity() == 4) {
            this.setErrorMessage(status.getMessage());
            this.setPageComplete(false);
        } else {
            int severity = 0;
            String msg = null;
            if (status.getSeverity() == 0) {
                msg = NamespaceResolutionPage.getString("page.msg");
            } else {
                severity = status.getSeverity();
                msg = status.getMessage();
            }
            this.setErrorMessage(null);
            this.setMessage(msg, severity);
            this.setPageComplete(true);
        }
    }

    public void setVisible(boolean theShowFlag) {
        if (theShowFlag) {
            Collection resources = this.builder.getResources();
            this.viewer.setInput((Object)resources);
            boolean enable = false;
            if (resources != null && !resources.isEmpty()) {
                for (IWebServiceResource resource : resources) {
                    if (resource.getReferencedResources().isEmpty()) continue;
                    enable = true;
                    break;
                }
            }
            this.packTableColumns();
            this.setPageStatus();
            this.showDependenciesAction.setEnabled(enable);
            this.viewer.getControl().setFocus();
        } else {
            this.setPageComplete(true);
        }
        super.setVisible(theShowFlag);
    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object theInputElement) {
            return NamespaceResolutionPage.this.getBuilder().getWSDLResources().toArray();
        }

        public void inputChanged(Viewer theViewer, Object theOldInput, Object theNewInput) {
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public Image getColumnImage(Object theElement, int theIndex) {
            Image result = null;
            if (theElement instanceof IWebServiceResource) {
                IWebServiceResource resource = (IWebServiceResource)theElement;
                IStatus status = resource.getStatus();
                if (theIndex == ERROR_COLUMN) {
                    result = WebServiceUiUtil.getStatusImage(status);
                } else if (theIndex != NAMESPACE_COLUMN && theIndex != PATH_COLUMN) {
                    CoreArgCheck.isTrue((boolean)false, (String)UTIL.getString(String.valueOf(PREFIX) + "msg.unknownTableColumn", new Object[]{Integer.toString(theIndex)}));
                }
            } else {
                CoreArgCheck.isTrue((boolean)false, (String)UTIL.getString(String.valueOf(PREFIX) + "msg.unknownObjectType", new Object[]{theElement.getClass().getName()}));
            }
            return result;
        }

        public String getColumnText(Object theElement, int theIndex) {
            String result = null;
            if (theElement instanceof IWebServiceResource) {
                IWebServiceResource resource = (IWebServiceResource)theElement;
                if (theIndex == ERROR_COLUMN) {
                    result = "";
                } else if (theIndex == NAMESPACE_COLUMN) {
                    result = WebServiceUiUtil.getText(resource.getNamespace());
                } else if (theIndex == PATH_COLUMN) {
                    result = WebServiceUiUtil.getText(NamespaceResolutionPage.this.getFile(resource.getFile()));
                } else {
                    CoreArgCheck.isTrue((boolean)false, (String)UTIL.getString(String.valueOf(PREFIX) + "msg.unknownTableColumn", new Object[]{Integer.toString(theIndex)}));
                }
            } else {
                CoreArgCheck.isTrue((boolean)false, (String)UTIL.getString(String.valueOf(PREFIX) + "msg.unknownObjectType", new Object[]{theElement.getClass().getName()}));
            }
            return result;
        }
    }
}

