/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.wizard;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.wizards.INewModelWizardContributor2;
import org.teiid.designer.webservice.IWebServiceModelBuilder;
import org.teiid.designer.webservice.WebServicePlugin;
import org.teiid.designer.webservice.ui.IInternalUiConstants;
import org.teiid.designer.webservice.ui.wizard.ImportWsdlValidationPage;
import org.teiid.designer.webservice.ui.wizard.NamespaceResolutionPage;
import org.teiid.designer.webservice.ui.wizard.SchemaLocationPage;
import org.teiid.designer.webservice.ui.wizard.SelectWsdlOperationsPage;
import org.teiid.designer.webservice.ui.wizard.WsdlSelectionPage;
import org.teiid.designer.webservice.ui.wizard.XmlModelSelectionPage;

public final class WebServiceModelContributor
implements INewModelWizardContributor2,
IInternalUiConstants {
    static final String PREFIX = I18nUtil.getPropertyPrefix(WebServiceModelContributor.class);
    private IWebServiceModelBuilder builder;
    private IWizardPage[] pages;
    private WizardPage namespaceResolutionPage;
    private WizardPage schemaLocationPage;
    private WizardPage wsdlSelectionPage;
    private WizardPage selectWsdlOperationsPage;
    private WizardPage wsdlValidationPage;
    private WizardPage xmlSelectionPage;

    public boolean canFinishEarly(IWizardPage theCurrentPage) {
        return false;
    }

    public void createWizardPages(ISelection theSelection, IResource theModelResource, IPath theModelPath, MetamodelDescriptor theDescriptor, boolean theIsVirtual) {
        this.builder = WebServicePlugin.createModelBuilder((IResource)theModelResource, (IPath)theModelPath, (MetamodelDescriptor)theDescriptor);
        this.wsdlSelectionPage = new WsdlSelectionPage(this.builder, WsdlSelectionPage.EditableNameField.UNEDITABLE);
        this.wsdlValidationPage = new ImportWsdlValidationPage(this.builder);
        this.selectWsdlOperationsPage = new SelectWsdlOperationsPage(this.builder);
        this.namespaceResolutionPage = new NamespaceResolutionPage(this.builder);
        this.schemaLocationPage = new SchemaLocationPage(this.builder);
        this.xmlSelectionPage = new XmlModelSelectionPage(this.builder);
        this.pages = new IWizardPage[6];
        this.pages[0] = this.wsdlSelectionPage;
        this.pages[1] = this.wsdlValidationPage;
        this.pages[2] = this.namespaceResolutionPage;
        this.pages[3] = this.selectWsdlOperationsPage;
        this.pages[4] = this.schemaLocationPage;
        this.pages[5] = this.xmlSelectionPage;
        ((WsdlSelectionPage)this.wsdlSelectionPage).setInitialSelection(theSelection);
    }

    private void dispose() {
        try {
            this.builder.getModelGenerator(true).close();
        }
        catch (CoreException theException) {
            UTIL.log((Throwable)theException);
        }
    }

    public void doCancel() {
        List newResources = this.builder.getAllNewResources();
        if (newResources != null && !newResources.isEmpty()) {
            this.dispose();
        }
    }

    public void doFinish(ModelResource theModelResource, IProgressMonitor theMonitor) {
        int severity = this.builder.validateWSDLNamespaces().getSeverity();
        CoreArgCheck.isTrue((severity < 4 ? 1 : 0) != 0, (String)"ERROR validating WSDL Namespaces");
        severity = this.builder.validateXSDNamespaces().getSeverity();
        CoreArgCheck.isTrue((severity < 4 ? 1 : 0) != 0, (String)"ERROR validating XSD Namespaces");
        try {
            try {
                IStatus status = this.builder.getModelGenerator(true).execute(theMonitor);
                if (status != null) {
                    this.logMessage(status);
                    final IStatus filteredStatus = this.filterStatus(status);
                    if (filteredStatus != null) {
                        UiUtil.getWorkbenchShellOnlyIfUiThread().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                ErrorDialog.openError((Shell)UiUtil.getWorkbenchShellOnlyIfUiThread(), (String)UTIL.getString(String.valueOf(PREFIX) + "dialog.messages.title", new Object[0]), null, (IStatus)filteredStatus, (int)7);
                            }
                        });
                    }
                }
            }
            catch (CoreException theException) {
                UTIL.log((Throwable)theException);
                WidgetUtil.showError((String)UTIL.getString(String.valueOf(PREFIX) + "generateModelProblem", new Object[0]));
                this.dispose();
            }
        }
        finally {
            this.dispose();
        }
    }

    private IStatus filterStatus(IStatus theStatus) {
        int code;
        Object result = null;
        result = theStatus instanceof MultiStatus ? new MultiStatus(theStatus.getPlugin(), theStatus.getCode(), theStatus.getMessage(), theStatus.getException()) : theStatus;
        if (result instanceof MultiStatus) {
            MultiStatus multiStatus = (MultiStatus)result;
            IStatus[] kids = multiStatus.getChildren();
            int i = 0;
            while (i < kids.length) {
                IStatus kidStatus = this.filterStatus(kids[i]);
                if (kidStatus != null) {
                    multiStatus.add(kidStatus);
                }
                ++i;
            }
            if (multiStatus.getChildren().length == 0) {
                result = null;
            }
        } else if (result.getSeverity() == 2 && ((code = result.getCode()) == 31301 || code == 58005)) {
            result = null;
        }
        return result;
    }

    public IWizardPage[] getWizardPages() {
        return this.pages;
    }

    public void inputChanged(ISelection theSelection, IResource theTargetResource, MetamodelDescriptor theDescriptor, boolean theIsVirtual) {
    }

    private void logMessage(IStatus theStatus) {
        if (theStatus.getSeverity() != 0) {
            UTIL.log(theStatus.getSeverity(), UTIL.getString(String.valueOf(PREFIX) + "logMessage", new Object[]{String.valueOf(theStatus.getCode()), theStatus.getMessage()}));
            if (theStatus.isMultiStatus()) {
                IStatus[] kids = theStatus.getChildren();
                int i = 0;
                while (i < kids.length) {
                    this.logMessage(kids[i]);
                    ++i;
                }
            }
        }
    }

    public void currentPageChanged(IWizardPage page) {
    }

    public IWizardPage getNextPage(IWizardPage page) {
        CoreArgCheck.isNotNull((Object)page);
        int ndx = this.indexOf(page);
        List<IWizardPage> pgs = Arrays.asList(this.getPages());
        if (ndx == pgs.size() - 1 || ndx < 0) {
            return null;
        }
        IWizardPage nextPage = pgs.get(ndx + 1);
        if (nextPage instanceof ImportWsdlValidationPage) {
            Map wsdlMessages = ((WsdlSelectionPage)page).getWsdlValidationMessages();
            ImportWsdlValidationPage validationPage = (ImportWsdlValidationPage)nextPage;
            validationPage.clearValidationMessages();
            if (wsdlMessages.size() > 0) {
                validationPage.setValidationMessages(wsdlMessages);
            } else {
                nextPage = pgs.get(ndx + 2);
            }
        }
        return nextPage;
    }

    private int indexOf(IWizardPage page) {
        List<IWizardPage> pgs = Arrays.asList(this.getPages());
        return pgs.indexOf(page);
    }

    private IWizardPage[] getPages() {
        return this.pages;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        CoreArgCheck.isNotNull((Object)page);
        int ndx = this.indexOf(page);
        if (ndx <= 0) {
            return null;
        }
        return Arrays.asList(this.getPages()).get(ndx - 1);
    }

    public ModelResource getSelectedModelResource() {
        return null;
    }

    public boolean copyAllDescriptions() {
        return false;
    }
}

