/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.metamodel.MetamodelDescriptor;
import org.teiid.designer.core.notification.util.DefaultIgnorableNotificationSource;
import org.teiid.designer.core.transaction.UnitOfWorkImpl;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.ui.UiPlugin;
import org.teiid.designer.ui.actions.DeleteAction;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.JobUtils;
import org.teiid.designer.ui.common.wizard.AbstractWizard;
import org.teiid.designer.ui.common.wizard.NoOpenProjectsWizardPage;
import org.teiid.designer.ui.product.IModelerProductContexts;
import org.teiid.designer.ui.viewsupport.ModelerUiViewUtils;
import org.teiid.designer.webservice.IWebServiceModelBuilder;
import org.teiid.designer.webservice.WebServicePlugin;
import org.teiid.designer.webservice.ui.IInternalUiConstants;
import org.teiid.designer.webservice.ui.WebServiceUiPlugin;
import org.teiid.designer.webservice.ui.wizard.ImportWsdlValidationPage;
import org.teiid.designer.webservice.ui.wizard.NamespaceResolutionPage;
import org.teiid.designer.webservice.ui.wizard.SchemaLocationPage;
import org.teiid.designer.webservice.ui.wizard.SelectWsdlOperationsPage;
import org.teiid.designer.webservice.ui.wizard.WsdlSelectionPage;
import org.teiid.designer.webservice.ui.wizard.XmlModelSelectionPage;

public class WsdlFileSystemImportWizard
extends AbstractWizard
implements IImportWizard,
IInternalUiConstants {
    static final String I18N_PREFIX = I18nUtil.getPropertyPrefix(WsdlFileSystemImportWizard.class);
    private static final String TITLE = WsdlFileSystemImportWizard.getString("title");
    private static final ImageDescriptor IMAGE = WebServiceUiPlugin.getDefault().getImageDescriptor("icons/full/ctool16/import_wsdl.gif");
    private static final String NOT_LICENSED_MSG = WsdlFileSystemImportWizard.getString("notLicensedMessage");
    private static final String WEB_SERVICES_CLASS_ID = "Web Service";
    private static boolean importLicensed = true;
    private IWebServiceModelBuilder builder;
    private WizardPage namespaceResolutionPage;
    private WizardPage schemaLocationPage;
    private WizardPage wsdlSelectionPage;
    private WizardPage selectWsdlOperationsPage;
    private WizardPage xmlSelectionPage;
    private WizardPage wsdlValidationPage;
    private IStructuredSelection selection;
    private IStatus status;
    private IContainer folder;
    boolean rollbackNewResources = false;
    private boolean autoBuildOn = false;

    private static String getString(String id) {
        return UTIL.getString(String.valueOf(I18N_PREFIX) + id, new Object[0]);
    }

    public WsdlFileSystemImportWizard() {
        super((AbstractUIPlugin)WebServiceUiPlugin.getDefault(), TITLE, IMAGE);
    }

    Composite createEmptyPageControl(Composite parent) {
        return new Composite(parent, 0);
    }

    public void createPageControls(Composite pageContainer) {
        if (importLicensed) {
            super.createPageControls(pageContainer);
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.selection = currentSelection;
        if (ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric()) {
            this.selection = new StructuredSelection((Object)ProductCustomizerMgr.getInstance().getProductCharacteristics().getHiddenProject());
        } else {
            List selectedResources = IDE.computeSelectedResources((IStructuredSelection)currentSelection);
            if (!selectedResources.isEmpty()) {
                this.selection = new StructuredSelection(selectedResources);
            }
        }
        if (!ModelerUiViewUtils.workspaceHasOpenModelProjects()) {
            IProject newProject = ModelerUiViewUtils.queryUserToCreateModelProject();
            if (newProject != null) {
                this.selection = new StructuredSelection((Object)newProject);
            } else {
                this.addPage((IWizardPage)NoOpenProjectsWizardPage.getStandardPage());
                return;
            }
        }
        if (importLicensed) {
            this.createWizardPages((ISelection)this.selection);
        } else {
            WizardPage page = new WizardPage(WsdlFileSystemImportWizard.class.getSimpleName(), TITLE, null){

                public void createControl(Composite parent) {
                    this.setControl((Control)WsdlFileSystemImportWizard.this.createEmptyPageControl(parent));
                }
            };
            page.setMessage(NOT_LICENSED_MSG, 3);
            page.setPageComplete(false);
            this.addPage((IWizardPage)page);
        }
        this.setNeedsProgressMonitor(true);
    }

    public void createWizardPages(ISelection theSelection) {
        if (this.selection != null && !this.selection.isEmpty()) {
            Object obj = this.selection.getFirstElement();
            IContainer someFolder = ModelUtil.getContainer((Object)obj);
            try {
                if (someFolder != null && someFolder.getProject().getNature("org.teiid.designer.core.modelNature") != null) {
                    this.folder = someFolder;
                }
            }
            catch (CoreException err) {
                IInternalUiConstants.UTIL.log((Throwable)err);
                WidgetUtil.showError((Throwable)err);
            }
        }
        IPath theModelPath = null;
        if (this.folder != null) {
            theModelPath = this.folder.getFullPath();
        }
        MetamodelDescriptor theDescriptor = this.getGenerateFromWsdlDescriptor();
        this.builder = WebServicePlugin.createModelBuilder((IResource)this.folder, (IPath)theModelPath, (MetamodelDescriptor)theDescriptor);
        this.builder.setSaveAllBeforeFinish(true);
        this.wsdlSelectionPage = new WsdlSelectionPage(this.builder, WsdlSelectionPage.EditableNameField.EDITABLE);
        this.wsdlSelectionPage.setPageComplete(false);
        this.addPage((IWizardPage)this.wsdlSelectionPage);
        this.wsdlValidationPage = new ImportWsdlValidationPage(this.builder);
        this.wsdlValidationPage.setPageComplete(true);
        this.addPage((IWizardPage)this.wsdlValidationPage);
        this.namespaceResolutionPage = new NamespaceResolutionPage(this.builder);
        this.namespaceResolutionPage.setPageComplete(false);
        this.addPage((IWizardPage)this.namespaceResolutionPage);
        this.selectWsdlOperationsPage = new SelectWsdlOperationsPage(this.builder);
        this.selectWsdlOperationsPage.setPageComplete(false);
        this.addPage((IWizardPage)this.selectWsdlOperationsPage);
        this.schemaLocationPage = new SchemaLocationPage(this.builder);
        this.addPage((IWizardPage)this.schemaLocationPage);
        this.xmlSelectionPage = new XmlModelSelectionPage(this.builder);
        this.addPage((IWizardPage)this.xmlSelectionPage);
        ((WsdlSelectionPage)this.wsdlSelectionPage).setInitialSelection(theSelection);
    }

    public boolean finish() {
        boolean result = true;
        this.autoBuildOn = ModelerCore.getWorkspace().isAutoBuilding();
        if (this.autoBuildOn) {
            JobUtils.setAutoBuild((boolean)false);
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                boolean started = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Create WS from WSDL on File System", (Object)new DefaultIgnorableNotificationSource((Object)WsdlFileSystemImportWizard.this));
                boolean succeeded = false;
                boolean overrideRollback = false;
                if (started) {
                    overrideRollback = true;
                    ((UnitOfWorkImpl)ModelerCore.getCurrentUoW()).setOverrideRollback(overrideRollback);
                }
                try {
                    succeeded = !WsdlFileSystemImportWizard.this.runFinish(monitor);
                }
                finally {
                    if (started) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            if (overrideRollback) {
                                WsdlFileSystemImportWizard.this.rollbackNewResources = true;
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
        };
        try {
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, op);
                switch (this.status.getSeverity()) {
                    case 0: 
                    case 1: 
                    case 2: {
                        break;
                    }
                    default: {
                        IInternalUiConstants.UTIL.log(this.status);
                    }
                }
                result = true;
            }
            catch (Throwable throwable) {
                if (this.rollbackNewResources) {
                    List newResources = this.builder.getAllNewResources();
                    if (newResources != null && !newResources.isEmpty()) {
                        DeleteAction action = new DeleteAction();
                        action.selectionChanged(null, (ISelection)new StructuredSelection(newResources));
                        action.run();
                        if (this.autoBuildOn) {
                            if (JobUtils.jobExists((String)IDEWorkbenchMessages.DeleteResourceAction_jobName)) {
                                Job.getJobManager().addJobChangeListener((IJobChangeListener)new SetAutobuildOnJobListener());
                            } else {
                                JobUtils.setAutoBuild((boolean)true);
                            }
                        }
                    }
                } else {
                    JobUtils.setAutoBuild((boolean)this.autoBuildOn);
                }
                this.dispose();
            }
        }
        finally {
            if (this.rollbackNewResources) {
                List newResources = this.builder.getAllNewResources();
                if (newResources != null && !newResources.isEmpty()) {
                    DeleteAction action = new DeleteAction();
                    action.selectionChanged(null, (ISelection)new StructuredSelection(newResources));
                    action.run();
                    if (this.autoBuildOn) {
                        if (JobUtils.jobExists((String)IDEWorkbenchMessages.DeleteResourceAction_jobName)) {
                            Job.getJobManager().addJobChangeListener((IJobChangeListener)new SetAutobuildOnJobListener());
                        } else {
                            JobUtils.setAutoBuild((boolean)true);
                        }
                    }
                }
            } else {
                JobUtils.setAutoBuild((boolean)this.autoBuildOn);
            }
            this.dispose();
        }
        return result;
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    public void dispose() {
        super.dispose();
    }

    public boolean runFinish(IProgressMonitor theMonitor) {
        boolean wasCancelled;
        block7: {
            wasCancelled = false;
            int severity = this.builder.validateWSDLNamespaces().getSeverity();
            CoreArgCheck.isTrue((severity < 4 ? 1 : 0) != 0, (String)"ERROR validating WSDL Namespaces");
            severity = this.builder.validateXSDNamespaces().getSeverity();
            CoreArgCheck.isTrue((severity < 4 ? 1 : 0) != 0, (String)"ERROR validating XSD Namespaces");
            if (!theMonitor.isCanceled()) {
                try {
                    this.status = this.builder.getModelGenerator(true).execute(theMonitor);
                    if (!wasCancelled && !theMonitor.isCanceled()) {
                        if (this.status != null) {
                            this.logMessage(this.status);
                            final IStatus filteredStatus = this.filterStatus(this.status);
                            if (filteredStatus != null) {
                                UiUtil.getWorkbenchShellOnlyIfUiThread().getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        ErrorDialog.openError((Shell)UiUtil.getWorkbenchShellOnlyIfUiThread(), (String)UTIL.getString(String.valueOf(I18N_PREFIX) + "dialog.messages.title", new Object[0]), null, (IStatus)filteredStatus, (int)7);
                                    }
                                });
                            }
                        }
                        break block7;
                    }
                    wasCancelled = true;
                }
                catch (CoreException theException) {
                    UTIL.log((Throwable)theException);
                    WidgetUtil.showError((String)UTIL.getString(String.valueOf(I18N_PREFIX) + "generateModelProblem", new Object[0]));
                }
            } else {
                wasCancelled = true;
            }
        }
        return wasCancelled;
    }

    private IStatus filterStatus(IStatus theStatus) {
        int code;
        Object result = null;
        result = theStatus instanceof MultiStatus ? new MultiStatus(theStatus.getPlugin(), theStatus.getCode(), theStatus.getMessage(), theStatus.getException()) : theStatus;
        if (result instanceof MultiStatus) {
            MultiStatus multiStatus = (MultiStatus)result;
            IStatus[] kids = multiStatus.getChildren();
            int i = 0;
            while (i < kids.length) {
                IStatus kidStatus = this.filterStatus(kids[i]);
                if (kidStatus != null) {
                    multiStatus.add(kidStatus);
                }
                ++i;
            }
            if (multiStatus.getChildren().length == 0) {
                result = null;
            }
        } else if (result.getSeverity() == 2 && ((code = result.getCode()) == 31301 || code == 58005)) {
            result = null;
        }
        return result;
    }

    private void logMessage(IStatus theStatus) {
        if (theStatus.getSeverity() != 0) {
            UTIL.log(theStatus.getSeverity(), UTIL.getString(String.valueOf(I18N_PREFIX) + "logMessage", new Object[]{String.valueOf(theStatus.getCode()), theStatus.getMessage()}));
            if (theStatus.isMultiStatus()) {
                IStatus[] kids = theStatus.getChildren();
                int i = 0;
                while (i < kids.length) {
                    this.logMessage(kids[i]);
                    ++i;
                }
            }
        }
    }

    protected MetamodelDescriptor getGenerateFromWsdlDescriptor() {
        List<MetamodelDescriptor> mmdescs = Arrays.asList(ModelerCore.getMetamodelRegistry().getMetamodelDescriptors());
        MetamodelDescriptor wsmmd = null;
        Iterator it = mmdescs.iterator();
        while (it.hasNext() && wsmmd == null) {
            MetamodelDescriptor mmd = (MetamodelDescriptor)it.next();
            if (!UiPlugin.getDefault().isProductContextValueSupported(IModelerProductContexts.Metamodel.URI, (Object)mmd.getNamespaceURI()) || !mmd.supportsNewModel()) continue;
            ArrayList<ModelType> typeList = new ArrayList<ModelType>(Arrays.asList(mmd.getAllowableModelTypes()));
            typeList.remove(ModelType.METAMODEL_LITERAL);
            if (!mmd.getName().equalsIgnoreCase(WEB_SERVICES_CLASS_ID) && !mmd.getDisplayName().equalsIgnoreCase(WEB_SERVICES_CLASS_ID)) continue;
            wsmmd = mmd;
        }
        return wsmmd;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        CoreArgCheck.isNotNull((Object)page);
        int ndx = this.indexOf(page);
        List<IWizardPage> pgs = Arrays.asList(this.getPages());
        if (ndx == pgs.size() - 1 || ndx < 0) {
            return null;
        }
        IWizardPage nextPage = pgs.get(ndx + 1);
        if (nextPage instanceof ImportWsdlValidationPage) {
            Map wsdlMessages = ((WsdlSelectionPage)page).getWsdlValidationMessages();
            ImportWsdlValidationPage validationPage = (ImportWsdlValidationPage)nextPage;
            validationPage.clearValidationMessages();
            if (wsdlMessages.size() > 0) {
                validationPage.setValidationMessages(wsdlMessages);
                validationPage.setPageComplete(false);
            } else {
                validationPage.setPageComplete(true);
                nextPage = pgs.get(ndx + 2);
            }
        }
        return nextPage;
    }

    class SetAutobuildOnJobListener
    extends JobChangeAdapter {
        SetAutobuildOnJobListener() {
        }

        public void done(IJobChangeEvent theEvent) {
            if (theEvent.getJob().getName() != null && theEvent.getJob().getName().equals(IDEWorkbenchMessages.DeleteResourceAction_jobName)) {
                Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        JobUtils.setAutoBuild((boolean)true);
                    }
                });
            }
        }
    }
}

