/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.wizard;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.wst.wsdl.validation.internal.IValidationReport;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidationConfiguration;
import org.eclipse.wst.wsdl.validation.internal.WSDLValidator;
import org.jdom.JDOMException;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.util.FileUrl;
import org.teiid.designer.core.util.URLHelper;
import org.teiid.designer.metamodels.wsdl.io.WsdlHelper;
import org.teiid.designer.ui.common.ICredentialsCommon;
import org.teiid.designer.ui.common.dialog.FolderSelectionDialog;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WizardUtil;
import org.teiid.designer.ui.common.widget.ListMessageDialog;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;
import org.teiid.designer.ui.viewsupport.ModelProjectSelectionStatusValidator;
import org.teiid.designer.ui.viewsupport.ModelingResourceFilter;
import org.teiid.designer.ui.wizards.wsdl.WsdlFileSelectionComposite;
import org.teiid.designer.ui.wizards.wsdl.WsdlFilter;
import org.teiid.designer.webservice.IWebServiceModelBuilder;
import org.teiid.designer.webservice.IWebServiceResource;
import org.teiid.designer.webservice.WebServicePlugin;
import org.teiid.designer.webservice.ui.IInternalUiConstants;
import org.teiid.designer.webservice.ui.util.WebServiceUiUtil;

public final class WsdlSelectionPage
extends AbstractWizardPage
implements FileUtils.Constants,
IInternalUiConstants,
IInternalUiConstants.HelpContexts,
IInternalUiConstants.Images,
Listener {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(WsdlSelectionPage.class);
    private static final String DIALOG_HEIGHT = "dialogHeight";
    private static final String DIALOG_WIDTH = "dialogWidth";
    private static final String DIALOG_X = "dialogX";
    private static final String DIALOG_Y = "dialogY";
    private static final String WSDL_SUFFIX = ".wsdl";
    private Text textName;
    private IWebServiceModelBuilder builder;
    private Map urlMap;
    private Map wsdlValidationMessages = new HashMap();
    private IAction copyAction;
    private IBaseLabelProvider labelProvider;
    private Object[] startupWsdls;
    private IAction removeWsdlAction;
    private IAction viewWsdlAction;
    private EditableNameField modelNameTextFieldEditable;
    private Button buttonSelectTargetModelLocation;
    private Text textFieldTargetProjectLocation;
    private IContainer targetModelLocation;
    private ViewerFilter wsdlFilter = new WsdlFilter();
    private Map wsdlMap;
    private TableViewer viewer;
    private WsdlFileSelectionComposite fileSelectionComposite;
    private ViewerFilter targetLocationFilter = new ViewerFilter(){

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean projectOpen;
            boolean result = false;
            if (element instanceof IResource && (projectOpen = ((IResource)element).getProject().isOpen())) {
                if (element instanceof IProject) {
                    result = true;
                } else if (element instanceof IFolder) {
                    result = true;
                }
            }
            return result;
        }
    };

    public WsdlSelectionPage(IWebServiceModelBuilder theBuilder, EditableNameField nameFieldEditable) {
        super(WsdlSelectionPage.class.getSimpleName(), WsdlSelectionPage.getString("title"));
        this.builder = theBuilder;
        this.wsdlMap = new HashMap();
        this.modelNameTextFieldEditable = nameFieldEditable;
        this.setImageDescriptor(WebServiceUiUtil.getImageDescriptor("icons/full/wizban/WebService.gif"));
    }

    private void addWsdlFiles(Object[] theFiles, boolean theWorkspaceResourceFlag) {
        boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Add WSDL Files", (Object)this);
        boolean succeeded = false;
        try {
            this.addWsdlFilesInternal(theFiles, theWorkspaceResourceFlag);
            succeeded = true;
        }
        finally {
            if (requiredStart) {
                if (succeeded) {
                    ModelerCore.commitTxn();
                } else {
                    ModelerCore.rollbackTxn();
                }
            }
        }
    }

    private void addWsdlFilesInternal(Object[] theFiles, boolean theWorkspaceResourceFlag) {
        Map map = this.getWsdlMap();
        ArrayList<Object> problems = null;
        ArrayList<Object> newWsdls = new ArrayList<Object>(theFiles.length);
        int i = 0;
        while (i < theFiles.length) {
            boolean okToAdd = true;
            String newPath = null;
            Iterator itr = map.keySet().iterator();
            newPath = theWorkspaceResourceFlag ? ((IFile)theFiles[i]).getLocation().toOSString() : (theFiles[i] instanceof FileUrl ? ((FileUrl)theFiles[i]).getOriginalUrlString() : ((File)theFiles[i]).getAbsolutePath());
            while (itr.hasNext()) {
                Object wsdl = itr.next();
                String path = null;
                if (wsdl instanceof IFile) {
                    path = ((IFile)wsdl).getLocation().toOSString();
                } else if (wsdl instanceof FileUrl) {
                    path = ((FileUrl)wsdl).getOriginalUrlString();
                } else if (wsdl instanceof File) {
                    path = ((File)wsdl).getAbsolutePath();
                } else {
                    CoreArgCheck.isTrue((boolean)false, (String)("Unexpected WSDL object type of " + wsdl.getClass()));
                }
                if (path == null || !path.equals(newPath)) continue;
                okToAdd = false;
                if (problems == null) {
                    problems = new ArrayList();
                }
                problems.add(theFiles[i]);
                break;
            }
            if (okToAdd) {
                IWebServiceResource resource = null;
                try {
                    resource = theWorkspaceResourceFlag ? this.builder.addResource((IFile)theFiles[i]) : this.builder.addResource((File)theFiles[i]);
                    map.put(theFiles[i], resource);
                    newWsdls.add(theFiles[i]);
                    this.validateWSDL(resource);
                }
                catch (Exception theException) {
                    UTIL.log((Throwable)theException);
                    if (problems == null) {
                        problems = new ArrayList<Object>();
                    }
                    problems.add(theFiles[i]);
                }
            }
            ++i;
        }
        if (!newWsdls.isEmpty()) {
            this.getViewer().refresh();
            this.getViewer().setSelection((ISelection)new StructuredSelection(newWsdls), true);
            this.setPageStatus();
        }
        if (problems != null) {
            ListMessageDialog.openInformation((Shell)this.getShell(), (String)WsdlSelectionPage.getString("dialog.problems.title"), null, (String)WsdlSelectionPage.getString("dialog.problems.msg"), problems, (IBaseLabelProvider)this.getLabelProvider());
        }
    }

    private void setBuilderXmlResponseDocModel() {
        IPath modelPath = this.builder.getModelPath();
        String name = String.valueOf(modelPath.removeFileExtension().lastSegment()) + WsdlSelectionPage.getString("xmlModelSuffix");
        this.builder.setXmlModel(modelPath.removeLastSegments(1).append(name).addFileExtension(modelPath.getFileExtension()));
    }

    private void validateWSDL(IWebServiceResource resource) {
        WSDLValidator validator = new WSDLValidator();
        IValidationReport report = null;
        try {
            report = validator.validate(resource.getFile().toURI().toString(), (InputStream)new FileInputStream(resource.getFile()), new WSDLValidationConfiguration());
        }
        catch (FileNotFoundException fileNotFoundException) {}
        if (report != null && report.getValidationMessages().length > 0) {
            this.wsdlValidationMessages.put(resource, report);
        }
    }

    private IContainer validateTargetFolder() {
        String folderName = this.textFieldTargetProjectLocation.getText();
        if (CoreStringUtil.isEmpty((String)folderName)) {
            WizardUtil.setPageComplete((WizardPage)this, (String)WsdlSelectionPage.getString("page.selectProject.msg"), (int)3);
        } else {
            IResource resrc = ModelerCore.getWorkspace().getRoot().findMember(folderName);
            if (resrc == null || !(resrc instanceof IContainer) || resrc.getProject() == null) {
                WizardUtil.setPageComplete((WizardPage)this, (String)WsdlSelectionPage.getString("invalidFolderMessage"), (int)3);
            } else if (!resrc.getProject().isOpen()) {
                WizardUtil.setPageComplete((WizardPage)this, (String)WsdlSelectionPage.getString("closedProjectMessage"), (int)3);
            } else {
                try {
                    if (resrc.getProject().getNature("org.teiid.designer.core.modelNature") != null) {
                        IContainer folder = (IContainer)resrc;
                        WizardUtil.setPageComplete((WizardPage)this);
                        return folder;
                    }
                    WizardUtil.setPageComplete((WizardPage)this, (String)WsdlSelectionPage.getString("notModelProjectMessage"), (int)3);
                }
                catch (CoreException err) {
                    UTIL.log((Throwable)err);
                    WizardUtil.setPageComplete((WizardPage)this, (String)err.getLocalizedMessage(), (int)3);
                }
            }
        }
        return null;
    }

    private String validateModelName() {
        String name = this.textName.getText();
        IStatus status = ModelNameUtil.validate((String)name, (String)".xmi", (IContainer)this.targetModelLocation, (int)7);
        if (status.getSeverity() == 4) {
            WizardUtil.setPageComplete((WizardPage)this, (String)(String.valueOf(ModelNameUtil.MESSAGES.INVALID_MODEL_NAME) + status.getMessage()), (int)3);
            return null;
        }
        WizardUtil.setPageComplete((WizardPage)this);
        return String.valueOf(name) + ".xmi";
    }

    public Map getWsdlValidationMessages() {
        return this.wsdlValidationMessages;
    }

    public void createControl(Composite theParent) {
        Composite pnlMain = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        pnlMain.setLayout((Layout)new GridLayout(1, false));
        this.setControl((Control)pnlMain);
        IWorkbenchHelpSystem helpSystem = UiUtil.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)pnlMain, "org.teiid.designer.webservice.ui.wsdlSelectionPage");
        this.createFileAndLocationPanel(pnlMain);
        this.fileSelectionComposite = new WsdlFileSelectionComposite(pnlMain, 0);
        GridDataFactory.fillDefaults().applyTo((Control)this.fileSelectionComposite);
        WsdlFileSelectionComposite.IFileSelectionCallback fileSelectionCallback = new WsdlFileSelectionComposite.IFileSelectionCallback(){

            public void execute(File wsdlFile) {
                WsdlSelectionPage.this.addWsdlFiles(new Object[]{wsdlFile}, false);
                WsdlSelectionPage.this.validatePage();
            }

            public Display getDisplay() {
                return WsdlSelectionPage.this.getShell().getDisplay();
            }
        };
        WsdlFileSelectionComposite.IURLSelectionCallback urlSelectionCallback = new WsdlFileSelectionComposite.IURLSelectionCallback(){

            public void execute(URL url, ICredentialsCommon.SecurityType securityType, String userName, String password) {
                WsdlSelectionPage.this.addURLWsdlFile(url, securityType, userName, password);
            }

            public Display getDisplay() {
                return WsdlSelectionPage.this.getShell().getDisplay();
            }
        };
        this.fileSelectionComposite.setCallbacks(fileSelectionCallback, fileSelectionCallback, urlSelectionCallback);
        this.createTablePanel(pnlMain);
    }

    public boolean canFlipToNextPage() {
        return this.viewer.getTable().getItemCount() > 0 && super.canFlipToNextPage();
    }

    private void createFileAndLocationPanel(Composite theParent) {
        Composite pnl = WidgetFactory.createPanel((Composite)theParent, (int)4, (int)768);
        pnl.setLayout((Layout)new GridLayout(2, false));
        this.createTargetSelectionComposite(theParent);
        WidgetFactory.createLabel((Composite)pnl, (String)WsdlSelectionPage.getString("modelName"));
        this.textName = WidgetFactory.createTextField((Composite)pnl, (int)768, (int)1);
        if (EditableNameField.UNEDITABLE.equals((Object)this.modelNameTextFieldEditable)) {
            this.textName.setEditable(false);
            String modelName = this.builder.getModelPath().removeFileExtension().lastSegment();
            this.textName.setText(modelName);
        }
        this.textName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                WsdlSelectionPage.this.nameModified();
            }
        });
    }

    private void createTargetSelectionComposite(Composite theParent) {
        Composite pnl = WidgetFactory.createPanel((Composite)theParent, (int)4, (int)768);
        pnl.setLayout((Layout)new GridLayout(1, false));
        Group optionsGroup = WidgetFactory.createGroup((Composite)pnl, (String)WsdlSelectionPage.getString("targetLocationGroup.text"), (int)0, (int)1, (int)2);
        GridData gdRadioGroup = new GridData(768);
        optionsGroup.setLayoutData((Object)gdRadioGroup);
        String location = this.builder.getParentResource() == null ? null : this.builder.getParentResource().getFullPath().makeRelative().toOSString();
        this.textFieldTargetProjectLocation = WidgetFactory.createTextField((Composite)optionsGroup, (int)768);
        String text = WsdlSelectionPage.getString("targetModelLocationTextField.tooltip");
        this.textFieldTargetProjectLocation.setToolTipText(text);
        if (location != null) {
            this.textFieldTargetProjectLocation.setText(location);
        }
        this.textFieldTargetProjectLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                WsdlSelectionPage.this.setPageStatus();
            }
        });
        this.buttonSelectTargetModelLocation = WidgetFactory.createButton((Composite)optionsGroup, (String)WsdlSelectionPage.getString("targetModelLocationBrowseButton.text"), (int)4);
        this.buttonSelectTargetModelLocation.setToolTipText(WsdlSelectionPage.getString("targetModelLocationBrowseButton.tooltip"));
        this.buttonSelectTargetModelLocation.addListener(13, (Listener)this);
    }

    private void createTableActions(IToolBarManager theToolBarMgr) {
        this.copyAction = new Action(WsdlSelectionPage.getString("action.copy"), 1){

            public void run() {
                WsdlSelectionPage.this.handleCopyWsdlInfo();
            }
        };
        this.copyAction.setImageDescriptor(WebServiceUiUtil.getSharedImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setDisabledImageDescriptor(WebServiceUiUtil.getSharedImageDescriptor("IMG_TOOL_COPY_DISABLED"));
        this.copyAction.setHoverImageDescriptor(WebServiceUiUtil.getSharedImageDescriptor("IMG_TOOL_COPY"));
        this.copyAction.setToolTipText(WsdlSelectionPage.getString("action.copy.tip"));
        this.copyAction.setEnabled(false);
        theToolBarMgr.add(this.copyAction);
        this.removeWsdlAction = new Action(WsdlSelectionPage.getString("action.removeWsdlFile"), 1){

            public void run() {
                WsdlSelectionPage.this.handleRemoveWsdlFile();
            }
        };
        this.removeWsdlAction.setImageDescriptor(WebServiceUiUtil.getSharedImageDescriptor("IMG_TOOL_DELETE"));
        this.removeWsdlAction.setToolTipText(WsdlSelectionPage.getString("action.removeWsdlFile.tip"));
        this.removeWsdlAction.setEnabled(false);
        theToolBarMgr.add(this.removeWsdlAction);
        this.viewWsdlAction = new Action(WsdlSelectionPage.getString("action.viewWsdlFile"), 1){

            public void run() {
                WsdlSelectionPage.this.handleViewWsdlFile();
            }
        };
        this.viewWsdlAction.setImageDescriptor(WebServiceUiUtil.getSharedImageDescriptor("IMG_OBJ_FILE"));
        this.viewWsdlAction.setToolTipText(WsdlSelectionPage.getString("action.viewWsdlFile.tip"));
        this.viewWsdlAction.setEnabled(false);
        theToolBarMgr.add(this.viewWsdlAction);
        theToolBarMgr.update(true);
    }

    protected void createTableContextMenu() {
        MenuManager mgr = new MenuManager();
        mgr.add(this.copyAction);
        mgr.add(this.removeWsdlAction);
        mgr.add(this.viewWsdlAction);
        Control table = this.viewer.getControl();
        table.setMenu(mgr.createContextMenu(table));
    }

    private void createTablePanel(Composite theParent) {
        ViewForm viewForm = WidgetFactory.createViewForm((Composite)theParent, (int)2048, (int)1808, (int)1);
        viewForm.setTopLeft((Control)WidgetFactory.createLabel((Composite)viewForm, (String)WsdlSelectionPage.getString("label.table")));
        Composite pnl = WidgetFactory.createPanel((Composite)viewForm, (int)0, (int)1808);
        viewForm.setContent((Control)pnl);
        this.viewer = WidgetFactory.createTableViewer((Composite)pnl, (int)770);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.labelProvider = new LabelProvider(){

            public String getText(Object theElement) {
                return WebServiceUiUtil.getText(theElement);
            }
        };
        this.viewer.setLabelProvider(this.labelProvider);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent theEvent) {
                WsdlSelectionPage.this.handleTableSelectionChanged();
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent theEvent) {
                WsdlSelectionPage.this.handleViewWsdlFile();
            }
        });
        this.viewer.addFilter(this.wsdlFilter);
        this.createTableActions(WidgetFactory.createViewFormToolBar((ViewForm)viewForm));
        this.createTableContextMenu();
    }

    public void dispose() {
        this.saveState();
    }

    void nameModified() {
        this.validatePage();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = super.getDialogSettings();
        if (settings != null) {
            IDialogSettings temp = settings.getSection("WebServiceModel");
            settings = temp == null ? settings.addNewSection("WebServiceModel") : temp;
        }
        return settings;
    }

    private IBaseLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    private TableViewer getViewer() {
        return this.viewer;
    }

    static String getString(String theKey) {
        return UTIL.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), new Object[0]);
    }

    private static String getString(String theKey, Object value1) {
        return UTIL.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), value1);
    }

    private Map getWsdlMap() {
        return this.wsdlMap;
    }

    protected Map getUrlMap() {
        return this.builder.getUrlMap();
    }

    private Object[] getWsdlResources() {
        return this.wsdlMap.keySet().toArray();
    }

    private void addURLWsdlFile(URL url, ICredentialsCommon.SecurityType securityType, String userName, String password) {
        ArrayList list = new ArrayList();
        this.urlMap = this.getUrlMap();
        try {
            String filePath = WsdlSelectionPage.formatPath(url);
            File wsdlFile = ICredentialsCommon.SecurityType.None.equals((Object)securityType) ? URLHelper.createFileFromUrl((URL)url, (String)CoreStringUtil.createFileName((String)filePath), (String)WSDL_SUFFIX) : URLHelper.createFileFromUrl((URL)url, (String)CoreStringUtil.createFileName((String)filePath), (String)WSDL_SUFFIX, (String)userName, (String)password);
            this.urlMap.put(wsdlFile.getName(), url.toString());
            WsdlHelper.convertImportsToAbsolutePaths((File)wsdlFile, (String)url.toExternalForm(), list, (Map)this.urlMap, (boolean)true);
        }
        catch (MalformedURLException theException) {
            UTIL.log((Throwable)theException);
        }
        catch (IOException theException) {
            UTIL.log((Throwable)theException);
        }
        catch (JDOMException theException) {
            UTIL.log((Throwable)theException);
        }
        Object[] wsdlFiles = list.toArray();
        this.addWsdlFiles(wsdlFiles, false);
        this.validatePage();
    }

    public static String formatPath(URL newUrl) {
        String filePath = newUrl.getPath();
        while (filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        int dotLocation = filePath.indexOf(".");
        if (dotLocation > -1) {
            filePath = filePath.substring(0, dotLocation);
        }
        return filePath;
    }

    private void handleCopyWsdlInfo() {
        WebServiceUiUtil.copyToClipboard(this.viewer.getSelection());
    }

    private void handleRemoveWsdlFile() {
        Object[] selectedWsdlFiles = ((IStructuredSelection)this.viewer.getSelection()).toArray();
        int i = 0;
        while (i < selectedWsdlFiles.length) {
            IWebServiceResource resource = (IWebServiceResource)this.wsdlMap.get(selectedWsdlFiles[i]);
            this.builder.remove(resource);
            this.wsdlValidationMessages.remove(resource);
            Iterator itr = this.wsdlMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                if (entry.getValue() != resource) continue;
                itr.remove();
                break;
            }
            ++i;
        }
        this.viewer.remove(selectedWsdlFiles);
        this.handleTableSelectionChanged();
        this.setPageStatus();
    }

    private void handleTableSelectionChanged() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        this.copyAction.setEnabled(!selection.isEmpty());
        this.removeWsdlAction.setEnabled(this.copyAction.isEnabled());
        this.viewWsdlAction.setEnabled(selection.size() == 1);
    }

    private void handleViewWsdlFile() {
        WebServiceUiUtil.viewFile(this.getShell(), this.viewer.getSelection());
    }

    private void restoreState() {
        Shell shell;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (shell = this.getContainer().getShell()) != null) {
            try {
                int x = settings.getInt(DIALOG_X);
                int y = settings.getInt(DIALOG_Y);
                int width = settings.getInt(DIALOG_WIDTH);
                int height = settings.getInt(DIALOG_HEIGHT);
                shell.setBounds(x, y, width, height);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private void saveState() {
        Shell shell;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && this.getContainer() != null && (shell = this.getContainer().getShell()) != null) {
            Rectangle r = shell.getBounds();
            settings.put(DIALOG_X, r.x);
            settings.put(DIALOG_Y, r.y);
            settings.put(DIALOG_WIDTH, r.width);
            settings.put(DIALOG_HEIGHT, r.height);
        }
    }

    private void setPageStatus() {
        String msg = null;
        int wsdlCount = this.wsdlMap.size();
        msg = wsdlCount > 0 ? UTIL.getString(String.valueOf(PREFIX) + "page.wsdlsIncluded.msg", new Object[]{new Integer(wsdlCount)}) : WsdlSelectionPage.getString("page.noWsdls.msg");
        boolean valid = this.validatePage();
        if (!valid) {
            return;
        }
        this.setMessage(msg, 0);
        this.getContainer().updateButtons();
    }

    public void setInitialSelection(ISelection theSelection) {
        if (!theSelection.isEmpty() && theSelection instanceof IStructuredSelection) {
            Object[] selectedObjects = ((IStructuredSelection)theSelection).toArray();
            ArrayList<File> wsdls = new ArrayList<File>();
            int i = 0;
            while (i < selectedObjects.length) {
                if (selectedObjects[i] instanceof IFile && WebServicePlugin.isWsdlFile((IFile)((IFile)selectedObjects[i]))) {
                    File fNew = ((IFile)selectedObjects[i]).getLocation().toFile();
                    wsdls.add(fNew);
                }
                ++i;
            }
            if (!wsdls.isEmpty()) {
                this.startupWsdls = wsdls.toArray();
            }
        }
    }

    public void setWsdlValidationMessages(Map wsdlValidationMessages) {
        this.wsdlValidationMessages = wsdlValidationMessages;
    }

    public void setVisible(boolean theShowFlag) {
        if (theShowFlag) {
            if (this.viewer.getInput() == null) {
                this.restoreState();
            }
            this.setPageComplete(true);
            if (this.startupWsdls != null) {
                this.addWsdlFiles(this.startupWsdls, false);
                this.startupWsdls = null;
            }
            this.viewer.setInput((Object)this);
            this.setPageStatus();
            if (this.fileSelectionComposite.isVisible(WsdlFileSelectionComposite.FileSelectionButtons.WORKSPACE)) {
                this.fileSelectionComposite.setFocus(WsdlFileSelectionComposite.FileSelectionButtons.WORKSPACE);
            }
        }
        super.setVisible(theShowFlag);
    }

    private boolean validatePage() {
        String pathString;
        boolean exists;
        this.targetModelLocation = this.validateTargetFolder();
        if (this.targetModelLocation == null) {
            return false;
        }
        String modelName = this.validateModelName();
        if (modelName == null) {
            return false;
        }
        IPath fullModelPath = this.targetModelLocation.getFullPath().append(modelName);
        String temp = null;
        IResource resource = ModelerCore.getWorkspace().getRoot().findMember(fullModelPath);
        if (resource != null) {
            IPath path = resource.getLocation();
            temp = path.toOSString();
        }
        if (exists = new File(pathString = this.getModelPath(temp, modelName)).exists()) {
            WizardUtil.setPageComplete((WizardPage)this, (String)WsdlSelectionPage.getString("page.existingWebServiceModel.msg", fullModelPath), (int)3);
        } else {
            WizardUtil.setPageComplete((WizardPage)this);
        }
        if (this.isPageComplete() && this.viewer.getTable().getItemCount() == 0) {
            WizardUtil.setPageComplete((WizardPage)this, (String)WsdlSelectionPage.getString("page.noWsdls.msg"), (int)3);
        }
        this.builder.setModelPath(fullModelPath);
        this.getContainer().updateButtons();
        if (this.isPageComplete()) {
            this.setBuilderXmlResponseDocModel();
        }
        return true;
    }

    private String getModelPath(String modelLocation, String modelName) {
        return new StringBuffer().append(modelLocation).append(File.separator).append(modelName).append('.').append("xmi").toString();
    }

    public void handleEvent(Event event) {
        if (event.widget == this.buttonSelectTargetModelLocation) {
            this.handleBrowseWorkspaceForTargetModelLocation();
        }
    }

    private void handleBrowseWorkspaceForTargetModelLocation() {
        IContainer location;
        FolderSelectionDialog dlg = new FolderSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dlg.setInitialSelection((Object)this.builder.getModelPath());
        dlg.addFilter((ViewerFilter)new ModelingResourceFilter(this.targetLocationFilter));
        dlg.setValidator((ISelectionStatusValidator)new ModelProjectSelectionStatusValidator());
        dlg.setAllowMultiple(false);
        dlg.setInput((Object)ModelerCore.getWorkspace().getRoot());
        Object[] objs = new Object[1];
        if (dlg.open() == 0) {
            objs = dlg.getResult();
        }
        this.targetModelLocation = location = objs.length == 0 ? null : (IContainer)objs[0];
        if (location != null) {
            this.textFieldTargetProjectLocation.setText(location.getFullPath().makeRelative().toString());
        }
        this.validatePage();
    }

    public static enum EditableNameField {
        EDITABLE,
        UNEDITABLE;

    }

    class TableContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object theInputElement) {
            return WsdlSelectionPage.this.getWsdlResources();
        }

        public void inputChanged(Viewer theViewer, Object theOldInput, Object theNewInput) {
        }
    }
}

