/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.wizard;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.teiid.core.designer.util.FileUtils;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.ui.common.InternalUiConstants;
import org.teiid.designer.ui.common.product.ProductCustomizerMgr;
import org.teiid.designer.ui.common.util.UiUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.common.viewsupport.StatusInfo;
import org.teiid.designer.ui.common.widget.Label;
import org.teiid.designer.ui.common.wizard.AbstractWizardPage;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelNameUtil;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceViewerFilter;
import org.teiid.designer.webservice.IWebServiceModelBuilder;
import org.teiid.designer.webservice.ui.IInternalUiConstants;
import org.teiid.designer.webservice.ui.util.WebServiceUiUtil;

public class XmlModelSelectionPage
extends AbstractWizardPage
implements FileUtils.Constants,
IInternalUiConstants,
IInternalUiConstants.HelpContexts,
IInternalUiConstants.Images {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(XmlModelSelectionPage.class);
    private static final String XML_FOLDER_MRU = "xmlFolderList";
    private IWebServiceModelBuilder builder;
    private boolean initialized;
    private String modelLocation;
    private String modelName;
    private ModelWorkspaceViewerFilter viewerFilter;
    private Button btnFolder;
    private Combo cbxFolder;
    private Text txfModel;
    private Button chkGenerateModel;

    public XmlModelSelectionPage(IWebServiceModelBuilder theBuilder) {
        super(XmlModelSelectionPage.class.getSimpleName(), XmlModelSelectionPage.getString("title"));
        this.builder = theBuilder;
        this.viewerFilter = new ModelWorkspaceViewerFilter();
        this.setImageDescriptor(WebServiceUiUtil.getImageDescriptor("icons/full/wizban/WebService.gif"));
        this.setPageComplete(true);
    }

    public void createControl(Composite theParent) {
        Composite pnl = WidgetFactory.createPanel((Composite)theParent, (int)0, (int)1808);
        pnl.setLayout((Layout)new GridLayout(3, false));
        this.setControl((Control)pnl);
        IWorkbenchHelpSystem helpSystem = UiUtil.getWorkbench().getHelpSystem();
        helpSystem.setHelp((Control)pnl, "org.teiid.designer.webservice.ui.xmlModelSelectionPage");
        this.chkGenerateModel = WidgetFactory.createCheckBox((Composite)pnl, (String)XmlModelSelectionPage.getString("checkbox.generateModel"), (int)0, (int)3, (boolean)true);
        this.chkGenerateModel.setToolTipText(XmlModelSelectionPage.getString("checkbox.generateModel.tip"));
        this.chkGenerateModel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                XmlModelSelectionPage.this.handleGenerateModelSelected();
            }
        });
        Label folderLabel = WidgetFactory.createLabel((Composite)pnl, (String)XmlModelSelectionPage.getString("label.folder"));
        this.cbxFolder = WidgetFactory.createCombo((Composite)pnl, (int)8, (int)768);
        this.cbxFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent theEvent) {
                XmlModelSelectionPage.this.handleFolderChanged();
            }
        });
        this.btnFolder = WidgetFactory.createButton((Composite)pnl, (String)InternalUiConstants.Widgets.BROWSE_BUTTON);
        this.btnFolder.setToolTipText(XmlModelSelectionPage.getString("button.browse.folder.tip"));
        this.btnFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent theEvent) {
                XmlModelSelectionPage.this.handleBrowseFolderSelected();
            }
        });
        WidgetFactory.createLabel((Composite)pnl, (String)XmlModelSelectionPage.getString("label.xmlModel"));
        this.txfModel = WidgetFactory.createTextField((Composite)pnl, (int)768);
        this.txfModel.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent theEvent) {
                XmlModelSelectionPage.this.handleModelChanged();
            }
        });
        if (ProductCustomizerMgr.getInstance().getProductCharacteristics().isHiddenProjectCentric()) {
            folderLabel.setVisible(false);
            this.btnFolder.setVisible(false);
            this.cbxFolder.setVisible(false);
        }
    }

    public void dispose() {
        this.saveFolderMru();
        super.dispose();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = super.getDialogSettings();
        if (settings != null) {
            IDialogSettings temp = settings.getSection("WebServiceModel");
            settings = temp == null ? settings.addNewSection("WebServiceModel") : temp;
        }
        return settings;
    }

    private String getLocationText(IContainer theContainer) {
        return theContainer == null ? "" : theContainer.getFullPath().makeRelative().toString();
    }

    private IPath getModelPath() {
        return this.chkGenerateModel.getSelection() && this.isModelInfoComplete() ? new Path(this.getModelPath(this.modelLocation, this.modelName)) : null;
    }

    private String getModelPath(String modelLocation, String modelName) {
        return new StringBuffer().append(modelLocation).append(File.separator).append(modelName).append('.').append("xmi").toString();
    }

    private static String getString(String theKey) {
        return UTIL.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), new Object[0]);
    }

    void handleBrowseFolderSelected() {
        this.viewerFilter.setShowModels(false);
        Object[] resources = WidgetUtil.showWorkspaceObjectSelectionDialog((String)XmlModelSelectionPage.getString("dialog.xmlModelLocationChooser.title"), (String)XmlModelSelectionPage.getString("dialog.xmlModelLocationChooser.msg"), (boolean)false, (Object)this.modelLocation, (ViewerFilter)this.viewerFilter, null, (ILabelProvider)new ModelExplorerLabelProvider());
        if (resources != null && resources.length > 0) {
            this.setFolder(this.getLocationText((IContainer)resources[0]));
        }
    }

    void handleFolderChanged() {
        this.modelLocation = this.cbxFolder.getText();
        this.updateModelInfo();
    }

    void handleGenerateModelSelected() {
        boolean enable = this.chkGenerateModel.getSelection();
        this.cbxFolder.setEnabled(enable);
        this.btnFolder.setEnabled(enable);
        this.txfModel.setEnabled(enable);
        this.updateModelInfo();
    }

    void handleModelChanged() {
        this.modelName = this.txfModel.getText();
        this.updateModelInfo();
    }

    private boolean isModelInfoComplete() {
        return this.modelName != null && this.modelName.length() > 0 && this.modelLocation != null && this.modelLocation.length() > 0;
    }

    private void loadFolderMru() {
        String[] temp;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (temp = settings.getArray(XML_FOLDER_MRU)) != null) {
            ArrayList<String> folders = new ArrayList<String>(temp.length);
            int i = 0;
            while (i < temp.length) {
                if (ModelerCore.getWorkspace().getRoot().findMember(temp[i]) != null) {
                    folders.add(temp[i]);
                }
                ++i;
            }
            WidgetUtil.setComboItems((Combo)this.cbxFolder, folders, null, (boolean)true);
        }
    }

    private void saveFolderMru() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && this.cbxFolder != null) {
            WidgetUtil.saveSettings((IDialogSettings)settings, (String)XML_FOLDER_MRU, (Combo)this.cbxFolder);
        }
    }

    private void setFolder(String thePath) {
        if (thePath != null) {
            int index = this.cbxFolder.indexOf(thePath);
            if (index == -1) {
                this.cbxFolder.add(thePath);
                index = this.cbxFolder.indexOf(thePath);
            }
            this.cbxFolder.select(index);
        }
    }

    private void setModelName(String theName) {
        this.txfModel.setText(theName);
    }

    private void setPageStatus(IStatus theStatus) {
        if (theStatus.getSeverity() == 4) {
            this.setErrorMessage(theStatus.getMessage());
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setMessage(theStatus.getMessage(), theStatus.getSeverity());
            this.setPageComplete(true);
        }
    }

    private void setPageStatus(int theSeverity, String theMessage) {
        IStatus builderStatus = this.builder.validateXSDNamespaces();
        int builderSeverity = builderStatus.getSeverity();
        if (theSeverity > builderSeverity) {
            this.setPageStatus((IStatus)new StatusInfo("org.teiid.designer.webservice.ui", theSeverity, theMessage == null ? "" : theMessage));
        } else if (theSeverity < builderSeverity) {
            this.setPageStatus(builderStatus);
        } else {
            String msg = null;
            msg = theMessage == null || theMessage.length() == 0 ? builderStatus.getMessage() : new StringBuffer().append(builderStatus.getMessage()).append(" : ").append(theMessage).toString();
            this.setPageStatus((IStatus)new StatusInfo("org.teiid.designer.webservice.ui", theSeverity, msg));
        }
    }

    public void setVisible(boolean theShowFlag) {
        if (theShowFlag) {
            IPath xmlModel;
            if (!this.initialized) {
                this.loadFolderMru();
                IPath modelPath = this.builder.getModelPath();
                String name = String.valueOf(modelPath.removeFileExtension().lastSegment()) + XmlModelSelectionPage.getString("xmlModelSuffix");
                this.builder.setXmlModel(modelPath.removeLastSegments(1).append(name).addFileExtension(modelPath.getFileExtension()));
                this.initialized = true;
            }
            if ((xmlModel = this.builder.getXmlModel()) != null) {
                this.setFolder(xmlModel.removeLastSegments(1).toOSString());
                this.setModelName(xmlModel.removeFileExtension().lastSegment());
            }
            this.updateModelInfo();
            this.chkGenerateModel.setFocus();
        } else {
            this.saveFolderMru();
            this.setPageComplete(true);
        }
        super.setVisible(theShowFlag);
    }

    private void updateModelInfo() {
        if (this.chkGenerateModel.getSelection()) {
            if (this.isModelInfoComplete()) {
                IStatus status;
                String temp = null;
                Path containerPath = new Path(this.modelLocation);
                IResource resource = ModelerCore.getWorkspace().getRoot().findMember((IPath)containerPath);
                if (resource != null) {
                    IPath path = resource.getLocation();
                    temp = path.toOSString();
                }
                if ((status = ModelNameUtil.validate((String)this.modelName, (String)".xmi", (IContainer)(resource != null ? resource.getParent() : null), (int)7)).getSeverity() != 4) {
                    String name = this.getModelPath(temp, this.modelName);
                    boolean exists = new File(name).exists();
                    if (exists) {
                        this.builder.setXmlModel(null);
                        this.setPageStatus(4, XmlModelSelectionPage.getString("page.msg.modelExists"));
                    } else if (this.builder.getModelPath().equals((Object)this.getModelPath())) {
                        this.builder.setXmlModel(null);
                        this.setPageStatus(4, XmlModelSelectionPage.getString("page.msg.sameAsWebServiceModelName"));
                    } else {
                        this.builder.setXmlModel(this.getModelPath());
                        this.setPageStatus(0, null);
                    }
                } else {
                    this.builder.setXmlModel(null);
                    this.setPageStatus(4, XmlModelSelectionPage.getString("page.msg.modelNameInvalid"));
                }
            } else {
                this.builder.setXmlModel(null);
                this.setPageStatus(4, XmlModelSelectionPage.getString("page.msg.modelIncomplete"));
            }
        } else {
            this.builder.setXmlModel(null);
            this.setPageStatus(0, XmlModelSelectionPage.getString("page.msg.xmlModelNotGenerated"));
        }
    }
}

