/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.webservice.ui.wizard;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.core.designer.event.EventObjectListener;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.workspace.ModelUtil;
import org.teiid.designer.ui.common.util.WidgetFactory;
import org.teiid.designer.ui.common.util.WidgetUtil;
import org.teiid.designer.ui.explorer.ModelExplorerContentProvider;
import org.teiid.designer.ui.explorer.ModelExplorerLabelProvider;
import org.teiid.designer.ui.viewsupport.ModelUtilities;
import org.teiid.designer.ui.viewsupport.ModelWorkspaceViewerFilter;
import org.teiid.designer.webservice.ui.IInternalUiConstants;

public class XsdElementChooserPanel
extends Composite
implements IInternalUiConstants {
    private static final String PREFIX = I18nUtil.getPropertyPrefix(XsdElementChooserPanel.class);
    private static final String NO_SELECTION = XsdElementChooserPanel.getString("noSelection.text");
    private static final String SELECT_ELEMENT_TITLE = XsdElementChooserPanel.getString("selectElementDialog.title");
    private static final String SELECT_ELEMENT_MSG = XsdElementChooserPanel.getString("selectElementDialog.msg");
    static final String INTERFACE_SELECTION_INVALID_MESSAGE = XsdElementChooserPanel.getString("selectElementDialog.selectionInvalid.msg");
    private XSDElementDeclaration currentElem;
    private XSDElementDeclaration originalElem;
    private CLabel elementLabel;
    private Button showElementDialogButton;
    private List eventListeners;
    final ViewerFilter interfaceFilter = new ModelWorkspaceViewerFilter(true){

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean doSelect = false;
            if (element instanceof IResource) {
                boolean projectOpen = ((IResource)element).getProject().isOpen();
                if (projectOpen) {
                    if (element instanceof IProject) {
                        doSelect = true;
                    } else if (element instanceof IContainer) {
                        doSelect = true;
                    } else if (element instanceof IFile && ModelUtil.isXsdFile((IResource)((IFile)element))) {
                        doSelect = true;
                    }
                }
            } else if (element instanceof IContainer) {
                doSelect = true;
            } else if (element instanceof XSDComponent && !(element instanceof XSDAnnotation) && !(element instanceof XSDSimpleTypeDefinition)) {
                doSelect = true;
            }
            return doSelect;
        }
    };
    final ISelectionStatusValidator interfaceValidator = new ISelectionStatusValidator(){

        public IStatus validate(Object[] selection) {
            if (selection.length == 1) {
                XSDParticle particle;
                XSDParticleContent content;
                if (selection[0] instanceof XSDElementDeclaration) {
                    return new Status(0, "org.teiid.designer.webservice.ui", 0, "", null);
                }
                if (selection[0] instanceof XSDParticle && (content = (particle = (XSDParticle)selection[0]).getContent()) instanceof XSDElementDeclaration) {
                    return new Status(0, "org.teiid.designer.webservice.ui", 0, "", null);
                }
            }
            return new Status(4, "org.teiid.designer.webservice.ui", 0, INTERFACE_SELECTION_INVALID_MESSAGE, null);
        }
    };

    public XsdElementChooserPanel(Composite parent) {
        super(parent, 0);
        this.initialize();
    }

    public void setSelectedElem(XSDElementDeclaration elem) {
        this.originalElem = elem;
        this.currentElem = elem;
        this.elementLabel.setText(this.getElementText(elem));
        this.elementLabel.setImage(this.getElementImage(elem));
        this.layout();
        this.notifyEventListeners();
    }

    public XSDElementDeclaration getSelectedElement() {
        return this.currentElem;
    }

    private static String getString(String theKey) {
        return UTIL.getString(new StringBuffer().append(PREFIX).append(theKey).toString(), new Object[0]);
    }

    public void addEventListener(EventObjectListener listener) {
        if (this.eventListeners == null) {
            this.eventListeners = new ArrayList();
        }
        this.eventListeners.add(listener);
    }

    public void removeEventListener(EventObjectListener listener) {
        if (this.eventListeners != null) {
            this.eventListeners.remove(listener);
        }
    }

    private void notifyEventListeners() {
        if (this.eventListeners != null) {
            for (EventObjectListener listener : this.eventListeners) {
                if (listener == null) continue;
                listener.processEvent(new EventObject(this));
            }
        }
    }

    private void initialize() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.setLayoutData(new GridData(768));
        String text = this.getElementText(this.currentElem);
        Image image = this.getElementImage(this.currentElem);
        this.elementLabel = WidgetFactory.createLabel((Composite)this, (String)text, (Image)image, (int)544);
        this.showElementDialogButton = WidgetFactory.createButton((Composite)this, (String)"...", (int)640);
        this.showElementDialogButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                XsdElementChooserPanel.this.showElementDialogPressed();
            }
        });
        this.layout();
    }

    private String getElementText(Object object) {
        String result = NO_SELECTION;
        if (object != null && object instanceof EObject) {
            result = ModelUtilities.getEMFLabelProvider().getText(object);
        }
        return result;
    }

    private Image getElementImage(Object object) {
        Image result = null;
        if (object != null && object instanceof EObject) {
            result = ModelUtilities.getEMFLabelProvider().getImage(object);
        }
        return result;
    }

    void showElementDialogPressed() {
        Object[] selections = WidgetUtil.showWorkspaceObjectSelectionDialog((String)SELECT_ELEMENT_TITLE, (String)SELECT_ELEMENT_MSG, (boolean)true, null, (ViewerFilter)this.interfaceFilter, (ISelectionStatusValidator)this.interfaceValidator, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        if (selections.length == 1) {
            XSDParticleContent content;
            Object selection = selections[0];
            XSDElementDeclaration newElem = null;
            if (selection instanceof XSDElementDeclaration) {
                newElem = (XSDElementDeclaration)selection;
            } else if (selection instanceof XSDParticle && (content = ((XSDParticle)selection).getContent()) instanceof XSDElementDeclaration) {
                newElem = (XSDElementDeclaration)content;
            }
            if (newElem != null && !newElem.equals(this.originalElem)) {
                this.setSelectedElem(newElem);
            }
        }
    }
}

