/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.webservice.aspects.validation.rules;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.webservice.Input;
import org.teiid.designer.metamodels.webservice.Message;
import org.teiid.designer.metamodels.webservice.WebServiceMetamodelPlugin;

public class MessageContentRule
implements ObjectValidationRule {
    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(Message.class, (Object)eObject);
        CoreArgCheck.isNotNull((Object)context);
        Message message = (Message)eObject;
        XSDElementDeclaration xsdElement = message.getContentElement();
        XSDSimpleTypeDefinition xsdSimpleType = message.getContentSimpleType();
        XSDComplexTypeDefinition xsdComplexType = message.getContentComplexType();
        ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
        if (xsdElement == null && xsdSimpleType == null && xsdComplexType == null) {
            String msg = null;
            msg = eObject instanceof Input ? WebServiceMetamodelPlugin.Util.getString("MessageContentRule.InputMissingTypeAndElement", new Object[0]) : WebServiceMetamodelPlugin.Util.getString("MessageContentRule.OutputMissingTypeAndElement", new Object[0]);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem((ValidationProblem)problem);
        } else if (xsdElement != null && xsdSimpleType != null || xsdElement != null && xsdComplexType != null || xsdSimpleType != null && xsdComplexType != null) {
            String msg = null;
            msg = eObject instanceof Input ? WebServiceMetamodelPlugin.Util.getString("MessageContentRule.InputHasSimpleTypeAndComplexTypeAndElement", new Object[0]) : WebServiceMetamodelPlugin.Util.getString("MessageContentRule.OutputHasSimpleTypeAndComplexTypeAndElement", new Object[0]);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem((ValidationProblem)problem);
        } else if (xsdSimpleType != null) {
            String msg = null;
            msg = eObject instanceof Input ? WebServiceMetamodelPlugin.Util.getString("MessageContentRule.InputHasSimpleType", new Object[0]) : WebServiceMetamodelPlugin.Util.getString("MessageContentRule.OutputHasSimpleType", new Object[0]);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem((ValidationProblem)problem);
        }
        context.addResult((ValidationResult)result);
    }
}

