/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.webservice.aspects.validation.rules;

import java.net.URL;
import java.net.URLConnection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.teiid.designer.core.validation.StructuralFeatureValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.webservice.WebServiceMetamodelPlugin;

public class SampleFileUrlRule
implements StructuralFeatureValidationRule {
    private final int featureID;

    public SampleFileUrlRule(int featureID) {
        this.featureID = featureID;
    }

    public void validate(EStructuralFeature eStructuralFeature, EObject eObject, Object value, ValidationContext context) {
        if (eStructuralFeature.getFeatureID() != this.featureID) {
            return;
        }
        if (!(value instanceof String)) {
            return;
        }
        String urlString = (String)value;
        boolean validUrl = false;
        URLConnection connection = null;
        try {
            URL url = new URL(urlString);
            connection = url.openConnection();
        }
        catch (Exception exception) {}
        if (connection != null) {
            validUrl = true;
        }
        if (!validUrl) {
            String msg = WebServiceMetamodelPlugin.Util.getString("SampleFileUrlRule.SampleFileHasInvalidUrl", new Object[0]);
            ValidationResultImpl validationResult = new ValidationResultImpl((Object)eObject);
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            validationResult.addProblem((ValidationProblem)problem);
            context.addResult((ValidationResult)validationResult);
        }
    }
}

