/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.webservice.aspects.validation.rules;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xsd.XSDElementDeclaration;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.core.validation.ObjectValidationRule;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.metamodels.webservice.Message;
import org.teiid.designer.metamodels.webservice.WebServiceMetamodelPlugin;

public final class TargetNamespaceRule
implements ObjectValidationRule {
    private static final String NO_TARGET_NAMESPACE_KEY = WebServiceMetamodelPlugin.Util.getString("TargetNamespaceRule.noTargetNamespace", new Object[0]);

    public void validate(EObject eObject, ValidationContext context) {
        CoreArgCheck.isInstanceOf(Message.class, (Object)eObject);
        CoreArgCheck.isNotNull((Object)context);
        Message msg = (Message)eObject;
        XSDElementDeclaration comp = msg.getContentElement();
        if (comp == null && (comp = msg.getContentSimpleType()) == null && (comp = msg.getContentComplexType()) == null) {
            return;
        }
        if (comp.getSchema().getTargetNamespace() == null) {
            ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
            result.addProblem((ValidationProblem)new ValidationProblemImpl(0, 4, NO_TARGET_NAMESPACE_KEY));
            context.addResult((ValidationResult)result);
        }
    }
}

