/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.metamodels.webservice.aspects.validation.rules;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.xerces.util.XMLChar;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.util.XSDResourceImpl;
import org.teiid.designer.common.xmi.XMIHeader;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.container.Container;
import org.teiid.designer.core.resource.EmfResource;
import org.teiid.designer.core.validation.ValidationContext;
import org.teiid.designer.core.validation.ValidationProblem;
import org.teiid.designer.core.validation.ValidationProblemImpl;
import org.teiid.designer.core.validation.ValidationResult;
import org.teiid.designer.core.validation.ValidationResultImpl;
import org.teiid.designer.core.validation.rules.StringNameRule;
import org.teiid.designer.core.validation.rules.StringNameValidator;
import org.teiid.designer.core.workspace.ModelFileUtil;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.webservice.Input;
import org.teiid.designer.metamodels.webservice.Interface;
import org.teiid.designer.metamodels.webservice.Message;
import org.teiid.designer.metamodels.webservice.Operation;
import org.teiid.designer.metamodels.webservice.Output;
import org.teiid.designer.metamodels.webservice.WebServiceMetamodelPlugin;
import org.teiid.designer.metamodels.webservice.util.WebServiceUtil;

public class WebServiceComponentNameRule
extends StringNameRule {
    public WebServiceComponentNameRule(int featureID) {
        super(featureID);
    }

    public void validate(EStructuralFeature eStructuralFeature, EObject eObject, Object value, ValidationContext context) {
        if (super.getFeatureID() != eStructuralFeature.getFeatureID()) {
            return;
        }
        super.validate(eStructuralFeature, eObject, value, context);
        Collection results = context.getTargetResults(eObject);
        if (results != null && !results.isEmpty()) {
            return;
        }
        String name = (String)value;
        InvalidCharacter invalidCharInName = null;
        if (name != null) {
            invalidCharInName = this.isValidNCName(name);
        }
        ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
        if (invalidCharInName != null) {
            String msg = null;
            if (invalidCharInName.index == 0) {
                msg = WebServiceMetamodelPlugin.Util.getString("WebServiceComponentNameRule.NameHasInvalidFirstCharacter", (Object)Character.valueOf(invalidCharInName.character));
            } else if (invalidCharInName.index == 1) {
                msg = WebServiceMetamodelPlugin.Util.getString("WebServiceComponentNameRule.NameHasInvalidSecondCharacter", (Object)Character.valueOf(invalidCharInName.character));
            } else if (invalidCharInName.index == 2) {
                msg = WebServiceMetamodelPlugin.Util.getString("WebServiceComponentNameRule.NameHasInvalidThirdCharacter", (Object)Character.valueOf(invalidCharInName.character));
            } else {
                Object[] params = new Object[]{new Integer(invalidCharInName.index + 1), new Character(invalidCharInName.character)};
                msg = WebServiceMetamodelPlugin.Util.getString("WebServiceComponentNameRule.NameHasInvalidNthCharacter", params);
            }
            ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, msg);
            result.addProblem((ValidationProblem)problem);
            return;
        }
        List siblings = this.getSiblingsForUniquenessCheck(eObject, context);
        if (siblings.isEmpty()) {
            return;
        }
        this.validateUniqueness(context, siblings, eStructuralFeature.getFeatureID());
    }

    protected InvalidCharacter isValidNCName(String ncName) {
        if (ncName.length() == 0) {
            return null;
        }
        char ch = ncName.charAt(0);
        if (!XMLChar.isNCNameStart((int)ch)) {
            return new InvalidCharacter(ch, 0);
        }
        int i = 1;
        while (i < ncName.length()) {
            ch = ncName.charAt(i);
            if (!XMLChar.isNCName((int)ch)) {
                return new InvalidCharacter(ch, i);
            }
            ++i;
        }
        return null;
    }

    protected boolean validateUniqueness() {
        return false;
    }

    protected List getSiblingsForUniquenessCheck(EObject eObject, ValidationContext context) {
        String objType = eObject.eClass().getName();
        String ruleName = String.valueOf(this.getRuleName()) + objType;
        if (eObject instanceof Interface) {
            String containerInfo;
            Container container = context.getResourceContainer();
            boolean modelContainer = ModelerCore.isModelContainer((Container)container);
            String string = containerInfo = modelContainer ? eObject.eResource().getURI().toString() : Interface.class.getName();
            if (!context.hasRunRule(containerInfo, ruleName)) {
                ArrayList<Resource> resources = new ArrayList<Resource>();
                if (modelContainer) {
                    resources.add(eObject.eResource());
                } else {
                    EList containerResources = container.getResources();
                    int size = containerResources.size();
                    int i = 0;
                    while (i < size) {
                        Resource resource = (Resource)containerResources.get(i);
                        if (this.isWebServiceModel(resource)) {
                            resources.add(resource);
                        }
                        ++i;
                    }
                }
                context.recordRuleRun(containerInfo, ruleName);
                List results = WebServiceUtil.findInterfaces(resources, 1);
                return results;
            }
        } else if (eObject instanceof Operation) {
            if (!context.hasRunRule(eObject, ruleName)) {
                context.recordRuleRun(eObject, ruleName);
                Interface parent = ((Operation)eObject).getInterface();
                List results = WebServiceUtil.findOperations(parent, 2);
                return results;
            }
        } else if (eObject instanceof Input) {
            if (!context.hasRunRule(eObject, ruleName)) {
                context.recordRuleRun(eObject, ruleName);
                EObject parent = eObject.eContainer();
                return WebServiceUtil.findMessages(parent);
            }
        } else if (eObject instanceof Output && !context.hasRunRule(eObject, ruleName)) {
            context.recordRuleRun(eObject, ruleName);
            EObject parent = eObject.eContainer();
            return WebServiceUtil.findMessages(parent);
        }
        return Collections.EMPTY_LIST;
    }

    private boolean isWebServiceModel(Resource theResource) {
        XMIHeader header;
        File file;
        URI uri;
        boolean result = false;
        String metamodelUri = null;
        if (theResource instanceof EmfResource) {
            ModelAnnotation annotation = ((EmfResource)theResource).getModelAnnotation();
            if (annotation != null) {
                metamodelUri = annotation.getPrimaryMetamodelUri();
            }
        } else if (theResource instanceof XSDResourceImpl) {
            return false;
        }
        if (metamodelUri == null && (uri = theResource.getURI()) != null && (file = new File(uri.toFileString())).exists() && (header = ModelFileUtil.getXmiHeader((File)file)) != null) {
            metamodelUri = header.getPrimaryMetamodelURI();
        }
        if (metamodelUri != null && "http://www.metamatrix.com/metamodels/WebService".equals(metamodelUri)) {
            result = true;
        }
        return result;
    }

    public void validateUniqueness(ValidationContext context, List siblings, int nameFeatureID) {
        StringNameValidator validator = new StringNameValidator();
        Map objectCountMap = validator.getDuplicateNamesMap(siblings, nameFeatureID);
        if (objectCountMap.size() > 0) {
            for (EObject eObject : objectCountMap.keySet()) {
                EStructuralFeature eFeature = eObject.eClass().getEStructuralFeature(nameFeatureID);
                String name = (String)eObject.eGet(eFeature);
                Integer count = (Integer)objectCountMap.get(eObject);
                ValidationResultImpl result = new ValidationResultImpl((Object)eObject);
                String message = this.getUniquenessMessage(context, eObject, name, count);
                if (message == null) continue;
                ValidationProblemImpl problem = new ValidationProblemImpl(0, 4, message);
                result.addProblem((ValidationProblem)problem);
                context.addResult((ValidationResult)result);
            }
        }
    }

    protected String getUniquenessMessage(ValidationContext context, EObject eObject, String name, Integer count) {
        int numModels = context.getResourcesToValidate().length;
        String msg = null;
        if (eObject instanceof Interface) {
            msg = numModels > 1 ? WebServiceMetamodelPlugin.Util.getString("WebServiceComponentNameRule.InterfaceNameMustBeUniqueInVdb", new Object[]{name, count}) : WebServiceMetamodelPlugin.Util.getString("WebServiceComponentNameRule.InterfaceNameMustBeUniqueInModel", new Object[]{name, count});
        } else if (eObject instanceof Operation) {
            msg = numModels > 1 ? WebServiceMetamodelPlugin.Util.getString("WebServiceComponentNameRule.OperationNameMustBeUniqueInVdb", new Object[]{name, count}) : WebServiceMetamodelPlugin.Util.getString("WebServiceComponentNameRule.OperationNameMustBeUniqueInModel", new Object[]{name, count});
        } else if (eObject instanceof Message) {
            msg = WebServiceMetamodelPlugin.Util.getString("WebServiceComponentNameRule.InputAndOutputNamesMustBeUnique", new Object[]{name, count});
        }
        return msg;
    }

    class InvalidCharacter {
        public final char character;
        public final int index;

        public InvalidCharacter(char character, int index) {
            this.character = character;
            this.index = index;
        }
    }
}

