/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc;

import java.sql.DriverPropertyInfo;

public class JdbcDriverProperty {
    private final String name;
    private final String desc;
    private final String[] allowableValues;
    private final boolean required;
    private final String currentValue;

    public JdbcDriverProperty(String name, String desc, String[] allowableValues, boolean required, String currentValue) {
        this.name = name;
        this.desc = desc == null ? "" : desc;
        this.allowableValues = allowableValues;
        this.required = required;
        this.currentValue = currentValue;
    }

    public JdbcDriverProperty(String name, String desc, String[] allowableValues, boolean required) {
        this(name, desc, allowableValues, required, null);
    }

    public JdbcDriverProperty(DriverPropertyInfo info) {
        this.name = info.name;
        this.desc = info.description != null ? info.description : "";
        this.allowableValues = info.choices;
        this.required = info.required;
        this.currentValue = info.value;
    }

    public String[] getAllowableValues() {
        return this.allowableValues;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }
}

