/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.metadata.impl;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.JdbcUtil;
import org.teiid.designer.jdbc.data.MetadataRequest;
import org.teiid.designer.jdbc.data.Response;

public class GetAccessForeignKeysRequest
extends MetadataRequest {
    public static final String NAME = JdbcPlugin.Util.getString("GetAccessForeignKeysRequestName", new Object[0]);

    public GetAccessForeignKeysRequest(Connection connection, String catalogNamePattern, String schemaNamePattern, String tableNamePattern) {
        super(NAME, connection, "getAccessForeignKeys", new Object[]{catalogNamePattern, schemaNamePattern, tableNamePattern});
    }

    @Override
    protected IStatus performInvocation(Response results) {
        IStatus status;
        block13: {
            Connection connection = (Connection)this.getTarget();
            status = null;
            ResultSet foreignKeys = null;
            try {
                try {
                    String catalogPattern = (String)this.getParameters()[0];
                    String schemaPattern = (String)this.getParameters()[1];
                    String tablePattern = (String)this.getParameters()[2];
                    Statement stmt = connection.createStatement();
                    foreignKeys = stmt.executeQuery("SELECT szRelationship, szReferencedObject, szColumn, szReferencedColumn FROM MSysRelationships WHERE szObject like '" + tablePattern + "'");
                    while (foreignKeys.next()) {
                        String fkName = foreignKeys.getString(1);
                        String pkTableName = foreignKeys.getString(2);
                        String fkey = foreignKeys.getString(3);
                        String pkey = foreignKeys.getString(4);
                        ArrayList<String> row = new ArrayList<String>();
                        row.add(catalogPattern);
                        row.add(schemaPattern);
                        row.add(pkTableName);
                        row.add(pkey);
                        row.add(catalogPattern);
                        row.add(schemaPattern);
                        row.add(tablePattern);
                        row.add(fkey);
                        row.add(null);
                        row.add(null);
                        row.add(null);
                        row.add(fkName);
                        row.add("Primary key");
                        row.add(null);
                        results.addRecord(row);
                    }
                }
                catch (SQLException e) {
                    status = JdbcUtil.createIStatus(e, e.getLocalizedMessage());
                    if (foreignKeys == null) break block13;
                    try {
                        foreignKeys.close();
                    }
                    catch (SQLException e2) {
                        JdbcPlugin.Util.log((Throwable)e2);
                    }
                }
            }
            finally {
                if (foreignKeys != null) {
                    try {
                        foreignKeys.close();
                    }
                    catch (SQLException e) {
                        JdbcPlugin.Util.log((Throwable)e);
                    }
                }
            }
        }
        return status;
    }
}

