/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.metadata.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.JdbcUtil;
import org.teiid.designer.jdbc.data.MetadataRequest;
import org.teiid.designer.jdbc.data.Response;
import org.teiid.designer.jdbc.data.TupleValidator;

public class GetImportedForeignKeysRequest
extends MetadataRequest {
    public static final String NAME = JdbcPlugin.Util.getString("GetImportedForeignKeysRequestName", new Object[0]);
    private static final String METHOD_NAME = "getImportedKeys";

    public GetImportedForeignKeysRequest(DatabaseMetaData metadata, String catalogNamePattern, String schemaNamePattern, String tableNamePattern) {
        super(NAME, metadata, METHOD_NAME, new Object[]{catalogNamePattern, schemaNamePattern, tableNamePattern});
    }

    @Override
    protected IStatus performInvocation(Response results) {
        IStatus status;
        block14: {
            DatabaseMetaData dbmd = this.getDatabaseMetaData();
            ResultSet resultSet = null;
            status = null;
            try {
                try {
                    String catalogPattern = (String)this.getParameters()[0];
                    final String schemaPattern = (String)this.getParameters()[1];
                    String tablePattern = (String)this.getParameters()[2];
                    resultSet = dbmd.getImportedKeys(catalogPattern, schemaPattern, tablePattern);
                    Response.addResults(results, resultSet, this.isMetadataRequested(), new TupleValidator(){

                        @Override
                        public boolean isTupleValid(List tuple) {
                            if (schemaPattern == null || schemaPattern.length() == 0) {
                                return true;
                            }
                            String schemaValue = (String)tuple.get(1);
                            return schemaValue != null && schemaPattern.equalsIgnoreCase(schemaValue);
                        }
                    });
                }
                catch (SQLException e) {
                    status = JdbcUtil.createIStatus(e, e.getLocalizedMessage());
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException sQLException) {}
                }
                throw throwable;
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return status;
    }
}

