/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.metadata.impl;

import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.jdbc.JdbcImportSettings;
import org.teiid.designer.jdbc.metadata.JdbcCatalog;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.metadata.JdbcNodeVisitor;
import org.teiid.designer.jdbc.metadata.JdbcSchema;

public class ImportSettingsSelectionVisitor
implements JdbcNodeVisitor {
    private final JdbcImportSettings settings;
    private boolean settingsHaveBeenCleared = false;

    public ImportSettingsSelectionVisitor(JdbcImportSettings settings) {
        CoreArgCheck.isNotNull((Object)settings);
        this.settings = settings;
    }

    @Override
    public boolean visit(JdbcNode node) {
        if (node == null) {
            return false;
        }
        if (!this.settingsHaveBeenCleared) {
            this.settings.getIncludedCatalogPaths().clear();
            this.settings.getIncludedSchemaPaths().clear();
            this.settings.getExcludedObjectPaths().clear();
            this.settingsHaveBeenCleared = true;
        }
        if (node instanceof JdbcDatabase) {
            return true;
        }
        if (node instanceof JdbcCatalog) {
            if (node.getSelectionMode() == 0) {
                return false;
            }
            String pathStr = node.getPath().toString();
            this.settings.getIncludedCatalogPaths().add((Object)pathStr);
            return true;
        }
        if (node instanceof JdbcSchema) {
            if (node.getSelectionMode() == 0) {
                return false;
            }
            String pathStr = node.getPath().toString();
            this.settings.getIncludedSchemaPaths().add((Object)pathStr);
            return true;
        }
        if (node.allowsChildren()) {
            return node.getSelectionMode() != 0;
        }
        int selectionMode = node.getSelectionMode();
        if (selectionMode != 1) {
            String pathStr = node.getPath().toString();
            this.settings.getExcludedObjectPaths().add((Object)pathStr);
        }
        return false;
    }
}

