/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.metadata.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.metadata.Capabilities;
import org.teiid.designer.jdbc.metadata.JdbcCatalog;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.metadata.impl.JdbcNodeImpl;
import org.teiid.designer.jdbc.metadata.impl.JdbcProcedureTypeImpl;
import org.teiid.designer.jdbc.metadata.impl.JdbcSchemaImpl;
import org.teiid.designer.jdbc.metadata.impl.JdbcTableTypeImpl;

public class JdbcCatalogImpl
extends JdbcNodeImpl
implements JdbcCatalog {
    static final String TABLE_SCHEM_STR = "TABLE_SCHEM";
    static final String TABLE_CATALOG_STR = "TABLE_CATALOG";
    static final String SQL_SERVER_DB_METADATA = "SQLServerDatabaseMetaData";
    static final String SQL_SERVER_EXCEPTION = "SQLServerException";

    public JdbcCatalogImpl(JdbcNode parent, String name) {
        super(102, name, parent);
        CoreArgCheck.isNotNull((Object)parent);
    }

    @Override
    public JdbcDatabase getJdbcDatabase() {
        return this.getParent().getJdbcDatabase();
    }

    @Override
    protected JdbcNode[] computeChildren() throws JdbcException {
        String msg;
        Object[] params;
        DatabaseMetaData metadata = this.getJdbcDatabase().getDatabaseMetaData();
        ArrayList<JdbcNodeImpl> children = new ArrayList<JdbcNodeImpl>();
        JdbcDatabase database = this.getJdbcDatabase();
        Capabilities capabilities = database.getCapabilities();
        boolean supportsSchemas = false;
        try {
            supportsSchemas = capabilities.supportsSchemas();
        }
        catch (Throwable t) {
            params = new Object[]{database.getConnection()};
            msg = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Unexpected_exception_while_discovering_support_for_schemas", params);
            JdbcPlugin.Util.log(2, t, msg);
        }
        if (supportsSchemas) {
            supportsSchemas = this.addSchemaChildren(metadata, children);
        }
        if (!supportsSchemas) {
            try {
                String[] tableTypes = database.getIncludes().getIncludedTableTypes();
                if (tableTypes == null) {
                    tableTypes = database.getCapabilities().getTableTypes();
                }
                int i = 0;
                while (i < tableTypes.length) {
                    children.add(new JdbcTableTypeImpl(this, tableTypes[i]));
                    ++i;
                }
            }
            catch (Throwable t) {
                params = new Object[]{metadata.getClass().getName(), database};
                msg = JdbcPlugin.Util.getString("JdbcCatalogImpl.Unexpected_exception_while_calling_getTableTypes()_and_processing_results", params);
                JdbcPlugin.Util.log(2, t, msg);
            }
            if (database.getIncludes().includeProcedures()) {
                String procTerm = null;
                try {
                    procTerm = database.getCapabilities().getProcedureTerm();
                }
                catch (Throwable throwable) {
                    procTerm = JdbcPlugin.Util.getString("JdbcCatalogImpl.ProcedureTypeName", new Object[0]);
                }
                children.add(new JdbcProcedureTypeImpl(this, procTerm));
            }
        }
        return children.toArray(new JdbcNode[children.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean addSchemaChildren(DatabaseMetaData metadata, List children) {
        boolean supportsSchemas = true;
        ResultSet resultSet = null;
        try {
            try {
                if (this.getName() == null) return supportsSchemas;
                resultSet = metadata.getSchemas();
                while (resultSet.next()) {
                    String catalogName = resultSet.getString(1);
                    children.add(new JdbcSchemaImpl(this, catalogName));
                }
                return supportsSchemas;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                supportsSchemas = false;
                if (resultSet == null) return supportsSchemas;
                try {
                    resultSet.close();
                    return supportsSchemas;
                }
                catch (SQLException e) {
                    JdbcPlugin.Util.log((Throwable)e);
                }
                return supportsSchemas;
            }
            catch (Throwable t) {
                if (!t.getClass().getName().endsWith(SQL_SERVER_EXCEPTION)) {
                    Object[] params = new Object[]{metadata.getClass().getName(), this.getJdbcDatabase().getConnection()};
                    String msg = JdbcPlugin.Util.getString("JdbcDatabaseImpl.Unexpected_exception_while_calling_getSchemas()_and_processing_results", params);
                    JdbcPlugin.Util.log(2, t, msg);
                }
                supportsSchemas = false;
                if (resultSet == null) return supportsSchemas;
                try {
                    resultSet.close();
                    return supportsSchemas;
                }
                catch (SQLException e) {
                    JdbcPlugin.Util.log((Throwable)e);
                }
                return supportsSchemas;
            }
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    JdbcPlugin.Util.log((Throwable)e);
                }
            }
        }
    }

    @Override
    public String getTypeName() {
        try {
            return this.getJdbcDatabase().getCapabilities().getCatalogTerm();
        }
        catch (Throwable throwable) {
            return JdbcPlugin.Util.getString("JdbcCatalogImpl.CatalogTypeName", new Object[0]);
        }
    }

    @Override
    public String getFullyQualifiedName() {
        boolean includeCatalogs = false;
        try {
            includeCatalogs = this.getJdbcDatabase().getCapabilities().supportsCatalogsInDataManipulation();
        }
        catch (JdbcException e) {
            JdbcPlugin.Util.log((Throwable)((Object)e));
        }
        catch (SQLException sQLException) {}
        if (includeCatalogs) {
            return this.getUnqualifiedName();
        }
        return "";
    }

    @Override
    public IPath getPathInSource() {
        return this.getPath();
    }

    @Override
    public IPath getPathInSource(boolean includeCatalog, boolean includeSchema) {
        if (includeCatalog) {
            return this.getPath();
        }
        return null;
    }

    @Override
    public JdbcNode getParentDatabaseObject(boolean includeCatalog, boolean includeSchema) {
        return null;
    }
}

