/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.metadata.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.jdbc.JdbcImportSettings;

public class JdbcNodeSelections {
    public static final int SELECTED = 1;
    public static final int UNSELECTED = 0;
    public static final int PARTIALLY_SELECTED = 2;
    public static final int UNKNOWN = -1;
    private final Set selecteds = new HashSet();
    private final Set unselecteds = new HashSet();
    private final Set partiallySelected = new HashSet();

    public void initialize(JdbcImportSettings settings) {
        CoreArgCheck.isNotNull((Object)settings);
        for (String pathStr : settings.getExcludedObjectPaths()) {
            Path path = new Path(pathStr);
            this.unselecteds.add(path);
            while (path.segmentCount() > 1) {
                IPath parentPath = path.removeLastSegments(1);
                this.partiallySelected.add(parentPath);
                path = parentPath;
            }
        }
        HashSet<Path> ignoreCatalogsAboveSchemas = new HashSet<Path>();
        for (String pathStr : settings.getIncludedSchemaPaths()) {
            Path path = new Path(pathStr);
            if (this.partiallySelected.contains(path)) continue;
            this.selecteds.add(path);
            Path tempPath = path;
            while (tempPath.segmentCount() > 1) {
                tempPath = tempPath.removeLastSegments(1);
                ignoreCatalogsAboveSchemas.add(tempPath);
            }
        }
        for (String pathStr : settings.getIncludedCatalogPaths()) {
            Path path = new Path(pathStr);
            if (ignoreCatalogsAboveSchemas.contains(path)) {
                this.partiallySelected.add(path);
                continue;
            }
            if (this.partiallySelected.contains(path)) continue;
            this.selecteds.add(path);
        }
    }

    public boolean hasSelectionModes() {
        return this.selecteds.size() != 0 || this.partiallySelected.size() != 0 || this.unselecteds.size() != 0;
    }

    public int getSelectionMode(IPath path) {
        CoreArgCheck.isNotNull((Object)path);
        if (this.selecteds.contains(path)) {
            return 1;
        }
        if (this.unselecteds.contains(path)) {
            return 0;
        }
        if (this.partiallySelected.contains(path)) {
            return 2;
        }
        if (path.segmentCount() == 0) {
            this.unselecteds.add(path);
            return 0;
        }
        if (path.segmentCount() == 1) {
            this.unselecteds.add(path);
            return 0;
        }
        IPath parentPath = path.removeLastSegments(1);
        int parentMode = this.getSelectionMode(parentPath);
        if (parentMode == 1) {
            this.selecteds.add(path);
            return 1;
        }
        if (parentMode == 2) {
            return -1;
        }
        return 0;
    }

    public void setSelected(IPath path, int selectionMode) {
        CoreArgCheck.isNotNull((Object)path);
        if (selectionMode == 1) {
            this.selecteds.add(path);
            this.unselecteds.remove(path);
            this.partiallySelected.remove(path);
        } else if (selectionMode == 0) {
            this.selecteds.remove(path);
            this.unselecteds.add(path);
            this.partiallySelected.remove(path);
        } else if (selectionMode == 2) {
            this.selecteds.remove(path);
            this.unselecteds.remove(path);
            this.partiallySelected.add(path);
        }
    }
}

