/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.metadata.impl;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.data.MetadataRequest;
import org.teiid.designer.jdbc.data.Request;
import org.teiid.designer.jdbc.metadata.JdbcCatalog;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.metadata.JdbcProcedure;
import org.teiid.designer.jdbc.metadata.JdbcProcedureType;
import org.teiid.designer.jdbc.metadata.JdbcSchema;
import org.teiid.designer.jdbc.metadata.impl.DisabledRequest;
import org.teiid.designer.jdbc.metadata.impl.GetDescriptionRequest;
import org.teiid.designer.jdbc.metadata.impl.GetProcedureParametersRequest;
import org.teiid.designer.jdbc.metadata.impl.JdbcNodeImpl;

public class JdbcProcedureImpl
extends JdbcNodeImpl
implements JdbcProcedure {
    private String remarks;
    private short procType;
    private String[] properties;
    private boolean isOracle = false;

    public JdbcProcedureImpl(JdbcProcedureType parent, String name) {
        super(106, name, parent);
        CoreArgCheck.isNotNull((Object)parent);
    }

    @Override
    protected JdbcNode[] computeChildren() {
        return null;
    }

    @Override
    public String getTypeName() {
        return this.getParent().getName();
    }

    @Override
    public boolean allowsChildren() {
        return false;
    }

    @Override
    protected int getDefaultSelectionMode() {
        return 1;
    }

    @Override
    public String getFullyQualifiedName() {
        StringBuffer sb = new StringBuffer();
        String prefix = null;
        prefix = this.isOracle && this.properties != null && this.properties.length > 0 && this.properties[0] != null ? this.getUnqualifiedPackageName(this.properties[0]) : this.getParent().getFullyQualifiedName();
        if (prefix.length() != 0) {
            sb.append(prefix);
            sb.append(this.getQualifedNameDelimiter());
        }
        String unqualName = this.getUnqualifiedName();
        sb.append(unqualName);
        return sb.toString();
    }

    @Override
    protected String getQualifedNameDelimiter() {
        try {
            String productName = this.getJdbcDatabase().getDatabaseInfo().getProductName();
            if (productName.toUpperCase().indexOf("INFORMIX") > -1) {
                return ".";
            }
        }
        catch (JdbcException e) {
            JdbcPlugin.Util.log((Throwable)((Object)e));
        }
        return super.getQualifedNameDelimiter();
    }

    public String getUnqualifiedPackageName(String packageName) {
        String quoteString = null;
        try {
            quoteString = this.getJdbcDatabase().getCapabilities().getIdentifierQuoteString();
        }
        catch (JdbcException e) {
            JdbcPlugin.Util.log((Throwable)((Object)e));
        }
        catch (SQLException sQLException) {}
        if (quoteString == null || quoteString.trim().length() == 0) {
            return packageName;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(quoteString);
        sb.append(packageName);
        sb.append(quoteString);
        return sb.toString();
    }

    @Override
    public IPath getPathInSource() {
        return this.getPathInSource(true, true);
    }

    @Override
    public IPath getPathInSource(boolean includeCatalog, boolean includeSchema) {
        JdbcNode parent = this.getParent();
        while (!(parent instanceof JdbcSchema && includeSchema || parent instanceof JdbcCatalog && includeCatalog || parent instanceof JdbcDatabase)) {
            parent = parent.getParent();
        }
        if (parent instanceof JdbcDatabase) {
            return new Path(this.getName());
        }
        return parent.getPathInSource().append(this.getName());
    }

    @Override
    public JdbcNode getParentDatabaseObject(boolean includeCatalog, boolean includeSchema) {
        JdbcNode parent = this.getParent();
        while (parent != null) {
            if (parent instanceof JdbcSchema && includeSchema || parent instanceof JdbcCatalog && includeCatalog || parent instanceof JdbcDatabase) break;
            parent = parent.getParent();
        }
        if (parent != null && parent.isDatabaseObject()) {
            return parent;
        }
        return null;
    }

    @Override
    public JdbcDatabase getJdbcDatabase() {
        return this.getParent().getJdbcDatabase();
    }

    @Override
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String string) {
        this.remarks = string;
    }

    public void setProperties(String[] strings) {
        this.properties = strings;
    }

    @Override
    public String[] getProperties() {
        return this.properties;
    }

    public void setIsOracle(boolean value) {
        this.isOracle = value;
    }

    @Override
    public boolean isOracle() {
        return this.isOracle;
    }

    @Override
    public short getProcedureType() {
        return this.procType;
    }

    public void setProcedureType(short type) {
        CoreArgCheck.isTrue((type == 0 || type == 2 || type == 1 ? 1 : 0) != 0, (String)JdbcPlugin.Util.getString("JdbcProcedureImpl.Invalid_procedure_type", new Object[0]));
        this.procType = type;
    }

    @Override
    protected Request[] createRequests() {
        DatabaseMetaData metadata = null;
        try {
            metadata = this.getJdbcDatabase().getDatabaseMetaData();
        }
        catch (JdbcException e) {
            JdbcPlugin.Util.log((Throwable)((Object)e));
        }
        DatabaseMetaData finalMetadata = metadata;
        String catalogNamePattern = JdbcNodeImpl.getCatalogPattern(this);
        String schemaNamePattern = JdbcNodeImpl.getSchemaPattern(this);
        String procedureNamePattern = this.getName();
        Request[] requests = new Request[]{new GetProcedureParametersRequest(finalMetadata, catalogNamePattern, schemaNamePattern, procedureNamePattern, "%"), new GetDescriptionRequest(this, "getRemarks")};
        if (!this.getJdbcDatabase().getIncludes().includeProcedures()) {
            requests[1] = new DisabledRequest((MetadataRequest)requests[1]);
        }
        return requests;
    }
}

