/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.metadata.impl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.metadata.JdbcProcedureType;
import org.teiid.designer.jdbc.metadata.impl.JdbcNodeImpl;
import org.teiid.designer.jdbc.metadata.impl.JdbcProcedureImpl;

public class JdbcProcedureTypeImpl
extends JdbcNodeImpl
implements JdbcProcedureType {
    static final String SQL_SERVER_DB_METADATA = "SQLServerDatabaseMetaData";
    static final String ORACLE_DB_METADATA = "OracleDatabaseMetaData";

    public JdbcProcedureTypeImpl(JdbcNode parent, String procTerm) {
        super(108, procTerm, parent);
    }

    @Override
    protected JdbcNode[] computeChildren() throws JdbcException {
        ArrayList<JdbcProcedureImpl> children;
        block16: {
            DatabaseMetaData metadata = this.getJdbcDatabase().getDatabaseMetaData();
            children = new ArrayList<JdbcProcedureImpl>();
            String schemaName = JdbcProcedureTypeImpl.getSchemaName(this);
            String catalogName = JdbcProcedureTypeImpl.getCatalogName(this);
            boolean isSqlServer = metadata.getClass().getName().endsWith(SQL_SERVER_DB_METADATA);
            boolean isOracle = metadata.getClass().getName().endsWith(ORACLE_DB_METADATA);
            ResultSet resultSet = null;
            try {
                try {
                    resultSet = metadata.getProcedures(catalogName, schemaName, "%");
                    while (resultSet.next()) {
                        String str1 = resultSet.getString(1);
                        String str2 = resultSet.getString(2);
                        String procName = resultSet.getString(3);
                        String str4 = resultSet.getString(4);
                        String str5 = resultSet.getString(5);
                        String str6 = resultSet.getString(6);
                        String remarks = resultSet.getString(7);
                        short procType = resultSet.getShort(8);
                        JdbcProcedureImpl proc = new JdbcProcedureImpl(this, procName);
                        proc.setProperties(new String[]{str1, str2, procName, str4, str5, str6, remarks});
                        proc.setIsOracle(isOracle);
                        proc.setRemarks(remarks);
                        proc.setProcedureType(procType);
                        children.add(proc);
                    }
                }
                catch (Throwable t) {
                    if (!isSqlServer) {
                        Object[] params = new Object[]{metadata.getClass().getName(), this.getJdbcDatabase()};
                        String msg = JdbcPlugin.Util.getString("JdbcProcedureTypeImpl.Unexpected_exception_while_calling_getProcedures()_and_processing_results", params);
                        JdbcPlugin.Util.log(2, t, msg);
                    }
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (SQLException e) {
                            JdbcPlugin.Util.log((Throwable)e);
                        }
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        JdbcPlugin.Util.log((Throwable)e);
                    }
                }
                throw throwable;
            }
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (SQLException e) {
                    JdbcPlugin.Util.log((Throwable)e);
                }
            }
        }
        return children.toArray(new JdbcNode[children.size()]);
    }

    @Override
    public String getTypeName() {
        return JdbcPlugin.Util.getString("JdbcProcedureTypeImpl.ProcedureTypeName", new Object[0]);
    }

    @Override
    public String getFullyQualifiedName() {
        return this.getParent().getFullyQualifiedName();
    }

    @Override
    public IPath getPathInSource() {
        return null;
    }

    @Override
    public IPath getPathInSource(boolean includeCatalog, boolean includeSchema) {
        return null;
    }

    @Override
    public JdbcNode getParentDatabaseObject(boolean includeCatalog, boolean includeSchema) {
        return null;
    }

    @Override
    public boolean isDatabaseObject() {
        return false;
    }

    @Override
    public JdbcDatabase getJdbcDatabase() {
        return this.getParent().getJdbcDatabase();
    }
}

