/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.metadata.impl;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.metadata.JdbcCatalog;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.metadata.JdbcSchema;
import org.teiid.designer.jdbc.metadata.impl.JdbcNodeImpl;
import org.teiid.designer.jdbc.metadata.impl.JdbcProcedureTypeImpl;
import org.teiid.designer.jdbc.metadata.impl.JdbcTableTypeImpl;

public class JdbcSchemaImpl
extends JdbcNodeImpl
implements JdbcSchema {
    public JdbcSchemaImpl(JdbcNode parent, String name) {
        super(103, name, parent);
        CoreArgCheck.isNotNull((Object)parent);
    }

    @Override
    protected JdbcNode[] computeChildren() throws JdbcException {
        DatabaseMetaData metadata = this.getJdbcDatabase().getDatabaseMetaData();
        ArrayList<JdbcNodeImpl> children = new ArrayList<JdbcNodeImpl>();
        JdbcDatabase database = this.getJdbcDatabase();
        try {
            String[] tableTypes = database.getIncludes().getIncludedTableTypes();
            if (tableTypes == null) {
                tableTypes = database.getCapabilities().getTableTypes();
            }
            int i = 0;
            while (i < tableTypes.length) {
                children.add(new JdbcTableTypeImpl(this, tableTypes[i]));
                ++i;
            }
        }
        catch (Throwable t) {
            Object[] params = new Object[]{metadata.getClass().getName(), database};
            String msg = JdbcPlugin.Util.getString("JdbcSchemaImpl.Unexpected_exception_while_calling_getTableTypes()_and_processing_results", params);
            JdbcPlugin.Util.log(2, t, msg);
        }
        if (database.getIncludes().includeProcedures()) {
            String procTerm = null;
            try {
                procTerm = database.getCapabilities().getProcedureTerm();
            }
            catch (Throwable throwable) {
                procTerm = JdbcPlugin.Util.getString("JdbcSchemaImpl.ProcedureTypeName", new Object[0]);
            }
            children.add(new JdbcProcedureTypeImpl(this, procTerm));
        }
        return children.toArray(new JdbcNode[children.size()]);
    }

    @Override
    public String getTypeName() {
        try {
            return this.getJdbcDatabase().getCapabilities().getSchemaTerm();
        }
        catch (Throwable throwable) {
            return JdbcPlugin.Util.getString("JdbcSchemaImpl.SchemaTypeName", new Object[0]);
        }
    }

    @Override
    public String getFullyQualifiedName() {
        boolean includeSchemas = false;
        try {
            includeSchemas = this.getJdbcDatabase().getCapabilities().supportsSchemasInDataManipulation();
        }
        catch (JdbcException e) {
            JdbcPlugin.Util.log((Throwable)((Object)e));
        }
        catch (SQLException sQLException) {}
        StringBuffer sb = new StringBuffer();
        String prefix = this.getParent().getFullyQualifiedName();
        if (prefix.length() != 0) {
            sb.append(prefix);
            sb.append(this.getQualifedNameDelimiter());
        }
        if (includeSchemas) {
            sb.append(this.getUnqualifiedName());
        }
        return sb.toString();
    }

    @Override
    public IPath getPathInSource() {
        return this.getPath();
    }

    @Override
    public IPath getPathInSource(boolean includeCatalog, boolean includeSchema) {
        if (includeSchema && includeCatalog) {
            return this.getPath();
        }
        if (includeSchema) {
            if (this.getParent() == this.getJdbcDatabase()) {
                return this.getPath();
            }
            return new Path(this.getName());
        }
        return null;
    }

    @Override
    public JdbcNode getParentDatabaseObject(boolean includeCatalog, boolean includeSchema) {
        if (this.getParent() instanceof JdbcCatalog) {
            return includeCatalog ? this.getParent() : null;
        }
        return null;
    }

    @Override
    public JdbcDatabase getJdbcDatabase() {
        return this.getParent().getJdbcDatabase();
    }
}

