/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.metadata.impl;

import java.sql.DatabaseMetaData;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.teiid.core.designer.util.CoreArgCheck;
import org.teiid.designer.jdbc.JdbcException;
import org.teiid.designer.jdbc.JdbcPlugin;
import org.teiid.designer.jdbc.data.MetadataRequest;
import org.teiid.designer.jdbc.data.Request;
import org.teiid.designer.jdbc.metadata.JdbcCatalog;
import org.teiid.designer.jdbc.metadata.JdbcDatabase;
import org.teiid.designer.jdbc.metadata.JdbcNode;
import org.teiid.designer.jdbc.metadata.JdbcSchema;
import org.teiid.designer.jdbc.metadata.JdbcTable;
import org.teiid.designer.jdbc.metadata.JdbcTableType;
import org.teiid.designer.jdbc.metadata.impl.DisabledRequest;
import org.teiid.designer.jdbc.metadata.impl.GetAccessForeignKeysRequest;
import org.teiid.designer.jdbc.metadata.impl.GetColumnsRequest;
import org.teiid.designer.jdbc.metadata.impl.GetDescriptionRequest;
import org.teiid.designer.jdbc.metadata.impl.GetExportedForeignKeysRequest;
import org.teiid.designer.jdbc.metadata.impl.GetImportedForeignKeysRequest;
import org.teiid.designer.jdbc.metadata.impl.GetIndexesRequest;
import org.teiid.designer.jdbc.metadata.impl.GetPrimaryKeyRequest;
import org.teiid.designer.jdbc.metadata.impl.JdbcNodeImpl;

public class JdbcTableImpl
extends JdbcNodeImpl
implements JdbcTable {
    private String remarks;

    public JdbcTableImpl(JdbcTableType parent, String name) {
        super(104, name, parent);
        CoreArgCheck.isNotNull((Object)parent);
    }

    @Override
    protected JdbcNode[] computeChildren() {
        return null;
    }

    @Override
    public String getTypeName() {
        return this.getParent().getName();
    }

    @Override
    public boolean allowsChildren() {
        return false;
    }

    @Override
    protected int getDefaultSelectionMode() {
        return 1;
    }

    @Override
    public String getFullyQualifiedName() {
        StringBuffer sb = new StringBuffer();
        String prefix = this.getParent().getFullyQualifiedName();
        if (prefix.length() != 0) {
            sb.append(prefix);
            sb.append(this.getQualifedNameDelimiter());
        }
        String unqualName = this.getUnqualifiedName();
        sb.append(unqualName);
        return sb.toString();
    }

    @Override
    protected String getQualifedNameDelimiter() {
        try {
            String productName = this.getJdbcDatabase().getDatabaseInfo().getProductName();
            if (productName.toUpperCase().indexOf("INFORMIX") > -1) {
                return ".";
            }
        }
        catch (JdbcException e) {
            JdbcPlugin.Util.log((Throwable)((Object)e));
        }
        return super.getQualifedNameDelimiter();
    }

    @Override
    public IPath getPathInSource() {
        return this.getPathInSource(true, true);
    }

    @Override
    public IPath getPathInSource(boolean includeCatalog, boolean includeSchema) {
        JdbcNode parent = this.getParent();
        while (!(parent instanceof JdbcSchema && includeSchema || parent instanceof JdbcCatalog && includeCatalog || parent instanceof JdbcDatabase)) {
            parent = parent.getParent();
        }
        if (parent instanceof JdbcDatabase) {
            return new Path(this.getName());
        }
        return parent.getPathInSource().append(this.getName());
    }

    @Override
    public JdbcNode getParentDatabaseObject(boolean includeCatalog, boolean includeSchema) {
        JdbcNode parent = this.getParent();
        while (parent != null) {
            if (parent instanceof JdbcSchema && includeSchema || parent instanceof JdbcCatalog && includeCatalog || parent instanceof JdbcDatabase) break;
            parent = parent.getParent();
        }
        if (parent != null && parent.isDatabaseObject()) {
            return parent;
        }
        return null;
    }

    @Override
    public String getRemarks() {
        return this.remarks;
    }

    public void setRemarks(String string) {
        this.remarks = string;
    }

    @Override
    public JdbcDatabase getJdbcDatabase() {
        return this.getParent().getJdbcDatabase();
    }

    @Override
    public void refresh() {
        super.refresh();
    }

    @Override
    protected Request[] createRequests() {
        DatabaseMetaData metadata = null;
        try {
            metadata = this.getJdbcDatabase().getDatabaseMetaData();
        }
        catch (JdbcException e) {
            JdbcPlugin.Util.log((Throwable)((Object)e));
        }
        DatabaseMetaData finalMetadata = metadata;
        String catalogNamePattern = JdbcNodeImpl.getCatalogPattern(this);
        String schemaNamePattern = JdbcNodeImpl.getSchemaPattern(this);
        String tableNamePattern = this.getName();
        Request[] requests = new Request[7];
        requests[0] = new GetColumnsRequest(finalMetadata, catalogNamePattern, schemaNamePattern, tableNamePattern, "%");
        boolean uniqueOnly = this.getJdbcDatabase().getIncludes().getUniqueIndexesOnly();
        boolean approxAllowed = this.getJdbcDatabase().getIncludes().getApproximateIndexes();
        requests[1] = new GetIndexesRequest(finalMetadata, catalogNamePattern, schemaNamePattern, tableNamePattern, uniqueOnly, approxAllowed);
        requests[2] = new GetPrimaryKeyRequest(finalMetadata, catalogNamePattern, schemaNamePattern, tableNamePattern);
        requests[3] = new GetImportedForeignKeysRequest(finalMetadata, catalogNamePattern, schemaNamePattern, tableNamePattern);
        requests[4] = new GetExportedForeignKeysRequest(finalMetadata, catalogNamePattern, schemaNamePattern, tableNamePattern);
        requests[5] = new GetDescriptionRequest(this, "getRemarks");
        if (!this.getJdbcDatabase().getIncludes().includeIndexes()) {
            requests[1] = new DisabledRequest((MetadataRequest)requests[1]);
        }
        if (!this.getJdbcDatabase().getIncludes().includeForeignKeys()) {
            requests[3] = new DisabledRequest((MetadataRequest)requests[3]);
            requests[4] = new DisabledRequest((MetadataRequest)requests[4]);
        }
        requests[6] = new GetAccessForeignKeysRequest(this.getJdbcDatabase().getConnection(), catalogNamePattern, schemaNamePattern, tableNamePattern);
        return requests;
    }
}

