/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.jdbc.metadata.impl;

import org.teiid.designer.jdbc.data.Request;

public class RequestContainer {
    private final Request[] requests;
    private String[] requestNames;

    public RequestContainer(Request[] requests) {
        this.requests = requests != null ? requests : new Request[]{};
    }

    public synchronized String[] getNamesOfResults() {
        if (this.requestNames == null) {
            String[] names = new String[this.requests.length];
            int i = 0;
            while (i < this.requests.length) {
                Request request = this.requests[i];
                names[i] = request.getName();
                ++i;
            }
            this.requestNames = names;
        }
        return this.requestNames;
    }

    public Request getRequest(String name) {
        return this.getRequest(name, true);
    }

    public Request getRequest(String name, boolean includeMetadata) {
        int i = 0;
        while (i < this.requests.length) {
            Request request = this.requests[i];
            if (request.getName().equals(name)) {
                if (!request.hasResults() && !request.hasProblems()) {
                    request.setMetadataRequested(includeMetadata);
                    request.invoke();
                }
                return request;
            }
            ++i;
        }
        return null;
    }
}

