/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.salesforce;

import com.sforce.soap.partner.QueryResult;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.ModelerCoreException;
import org.teiid.core.designer.util.CoreStringUtil;
import org.teiid.core.designer.util.I18nUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.types.DatatypeManager;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.extension.properties.ModelExtensionPropertyDefinition;
import org.teiid.designer.extension.properties.NamespaceProvider;
import org.teiid.designer.metamodels.core.CoreFactory;
import org.teiid.designer.metamodels.core.ModelAnnotation;
import org.teiid.designer.metamodels.core.ModelType;
import org.teiid.designer.metamodels.relational.BaseTable;
import org.teiid.designer.metamodels.relational.Column;
import org.teiid.designer.metamodels.relational.DirectionKind;
import org.teiid.designer.metamodels.relational.ForeignKey;
import org.teiid.designer.metamodels.relational.NullableType;
import org.teiid.designer.metamodels.relational.PrimaryKey;
import org.teiid.designer.metamodels.relational.Procedure;
import org.teiid.designer.metamodels.relational.ProcedureParameter;
import org.teiid.designer.metamodels.relational.ProcedureResult;
import org.teiid.designer.metamodels.relational.RelationalFactory;
import org.teiid.designer.metamodels.relational.RelationalPackage;
import org.teiid.designer.metamodels.relational.SearchabilityType;
import org.teiid.designer.metamodels.relational.UniqueKey;
import org.teiid.designer.modelgenerator.salesforce.Activator;
import org.teiid.designer.modelgenerator.salesforce.Messages;
import org.teiid.designer.modelgenerator.salesforce.SalesforceConstants;
import org.teiid.designer.modelgenerator.salesforce.SalesforceImportWizardManager;
import org.teiid.designer.modelgenerator.salesforce.model.Relationship;
import org.teiid.designer.modelgenerator.salesforce.model.SalesforceField;
import org.teiid.designer.modelgenerator.salesforce.model.SalesforceObject;
import org.teiid.designer.modelgenerator.salesforce.util.ModelBuildingException;
import org.teiid.designer.modelgenerator.salesforce.util.NameUtil;

public class RelationalModelgenerator {
    private IProgressMonitor monitor;
    private final ModelObjectExtensionAssistant assistant;
    private final ModelExtensionDefinition definition;
    private List relationships;
    private Map tablesByName;
    private SalesforceImportWizardManager wizardManager;

    public RelationalModelgenerator(SalesforceImportWizardManager wizardManager, IProgressMonitor monitor) {
        this.wizardManager = wizardManager;
        this.monitor = monitor;
        this.relationships = new ArrayList();
        this.tablesByName = new HashMap();
        this.assistant = (ModelObjectExtensionAssistant)ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(SalesforceConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
        if (this.assistant == null) {
            throw new IllegalStateException(Messages.getString(String.valueOf(I18nUtil.getPropertyPrefix(this.getClass())) + "modelExtensionAssistantNotFound"));
        }
        this.definition = this.assistant.getModelExtensionDefinition();
        if (this.definition == null) {
            throw new IllegalStateException(Messages.getString(String.valueOf(I18nUtil.getPropertyPrefix(this.getClass())) + "modelExtensionDefinitionNotFound"));
        }
    }

    public void createRelationalModel(ModelResource modelResource, Resource resource) throws Exception {
        ModelAnnotation annotation = CoreFactory.eINSTANCE.createModelAnnotation();
        annotation.setModelType(ModelType.PHYSICAL_LITERAL);
        annotation.setPrimaryMetamodelUri(RelationalPackage.eINSTANCE.getNsURI());
        resource.getContents().add((Object)annotation);
        this.assistant.saveModelExtensionDefinition((Object)modelResource);
        Object[] objects = this.wizardManager.getDataModel().getSalesforceObjects();
        int i = 0;
        while (i < objects.length) {
            SalesforceObject sfo = (SalesforceObject)objects[i];
            if (sfo.isSelected() && !this.monitor.isCanceled()) {
                this.monitor.subTask("Creating " + sfo.getName() + " table");
                this.addTableToModel(sfo, resource);
                this.monitor.worked(1);
            }
            ++i;
        }
        if (!this.monitor.isCanceled()) {
            this.createRelationships();
        }
        if (this.wizardManager.isGenerateUpdated() && !this.monitor.isCanceled()) {
            this.generateGetUpdated(resource);
        }
        if (this.wizardManager.isGenerateDeleted() && !this.monitor.isCanceled()) {
            this.generateGetDeleted(resource);
        }
    }

    private void addTableToModel(SalesforceObject sfo, Resource resource) throws ModelBuildingException {
        BaseTable newTable = RelationalFactory.eINSTANCE.createBaseTable();
        this.relationships.addAll(sfo.getSelectedRelationships());
        this.tablesByName.put(sfo.getName(), newTable);
        resource.getContents().add((Object)newTable);
        if (this.wizardManager.isSetNameAsLabel() && sfo.getLabel() != null) {
            newTable.setName(NameUtil.normalizeName(sfo.getLabel()));
        } else {
            newTable.setName(NameUtil.normalizeName(sfo.getName()));
        }
        newTable.setNameInSource(sfo.getName());
        if (this.wizardManager.getSupressCollectCardinalities()) {
            newTable.setCardinality(this.getCardinality(sfo));
        }
        newTable.setSupportsUpdate(sfo.isUpdateable());
        try {
            this.setInitialPropertyValue((EObject)newTable, "Custom", Boolean.toString(sfo.isCustom()));
            this.setInitialPropertyValue((EObject)newTable, "Supports Create", Boolean.toString(sfo.isCreateable()));
            this.setInitialPropertyValue((EObject)newTable, "Supports Delete", Boolean.toString(sfo.isDeleteable()));
            this.setInitialPropertyValue((EObject)newTable, "Supports Merge", Boolean.toString(sfo.isMergeable()));
            this.setInitialPropertyValue((EObject)newTable, "Supports Query", Boolean.toString(sfo.isQueryable()));
            this.setInitialPropertyValue((EObject)newTable, "Supports Replicate", Boolean.toString(sfo.isReplicateable()));
            this.setInitialPropertyValue((EObject)newTable, "Supports Retrieve", Boolean.toString(sfo.isRetrieveable()));
            this.setInitialPropertyValue((EObject)newTable, "Supports Search", Boolean.toString(sfo.isSearchable()));
        }
        catch (Exception e) {
            throw new ModelBuildingException(e);
        }
        this.addColumnsToTable(sfo, newTable);
    }

    private void setInitialPropertyValue(EObject eObject, String simplePropertyId, String expectedValue) throws Exception {
        String propId = ModelExtensionPropertyDefinition.Utils.getPropertyId((NamespaceProvider)SalesforceConstants.NAMESPACE_PROVIDER, (String)simplePropertyId);
        String currentValue = this.assistant.getPropertyValue((Object)eObject, propId);
        if (!CoreStringUtil.equals((String)expectedValue, (String)currentValue)) {
            this.assistant.setPropertyValue((Object)eObject, propId, expectedValue);
        }
    }

    private int getCardinality(SalesforceObject sfo) {
        int result = 0;
        try {
            if (sfo.isQueryable()) {
                StringBuffer query = new StringBuffer();
                query.append("SELECT COUNT() FROM ");
                query.append(sfo.getName());
                QueryResult queryResult = this.wizardManager.getConnection().getBinding().query(query.toString());
                result = queryResult.getSize();
            }
        }
        catch (Throwable throwable) {
            String pattern = Messages.getString("RelationalModelgenerator.error.calculating.cardinalities");
            String message = MessageFormat.format(pattern, sfo.getName());
            Status status = new Status(1, "org.teiid.designer.modelgenerator.salesforce", message);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return result;
    }

    private void addColumnsToTable(SalesforceObject sfo, BaseTable newTable) throws ModelBuildingException {
        boolean hasUpdateableColumn = false;
        SalesforceField[] fields = sfo.getFields();
        int i = 0;
        while (i < fields.length) {
            SalesforceField field = fields[i];
            if (this.wizardManager.isModelAuditFields() || !field.isAuditField()) {
                Column column = RelationalFactory.eINSTANCE.createColumn();
                newTable.getColumns().add((Object)column);
                if (this.wizardManager.isSetNameAsLabel() && field.getLabel() != null) {
                    column.setName(NameUtil.normalizeName(field.getLabel()));
                } else {
                    column.setName(NameUtil.normalizeName(field.getName()));
                }
                column.setNameInSource(field.getName());
                column.setLength(field.getLength());
                if (field.isUpdateable()) {
                    column.setUpdateable(true);
                    hasUpdateableColumn = true;
                }
                try {
                    this.setInitialPropertyValue((EObject)column, "Calculated", Boolean.toString(field.isCalculated()));
                    this.setInitialPropertyValue((EObject)column, "Custom", Boolean.toString(field.isCustom()));
                    this.setInitialPropertyValue((EObject)column, "Defaulted on Create", Boolean.toString(field.isDefaultedOnCreate()));
                }
                catch (Exception e) {
                    throw new ModelBuildingException(e);
                }
                this.setColumnType(field, column);
                if (field.isPrimaryKey()) {
                    column.setNullable(NullableType.NO_NULLS_LITERAL);
                    column.setDefaultValue("Generated upon creation");
                    PrimaryKey pKey = RelationalFactory.eINSTANCE.createPrimaryKey();
                    newTable.setPrimaryKey(pKey);
                    pKey.getColumns().add((Object)column);
                    pKey.setName(String.valueOf(NameUtil.normalizeName(field.getName())) + "_PK");
                }
                if (sfo.isQueryable() && this.wizardManager.isCollectColumnDistinctValue()) {
                    int distinctValues = this.getDistinctValueCount(sfo.getName(), field.getName());
                    column.setDistinctValueCount(distinctValues);
                }
            }
            ++i;
        }
        if (!hasUpdateableColumn) {
            newTable.setSupportsUpdate(false);
        }
    }

    private int getDistinctValueCount(String objectName, String columnName) {
        int resultSize = 0;
        try {
            StringBuffer query = new StringBuffer();
            query.append("SELECT ");
            query.append(columnName);
            query.append(" FROM ");
            query.append(objectName);
            QueryResult queryResult = this.wizardManager.getConnection().getBinding().query(query.toString());
            resultSize = queryResult.getSize();
        }
        catch (Throwable throwable) {
            String pattern = Messages.getString("RelationalModelgenerator.error.calculating.column.distinct");
            String message = MessageFormat.format(pattern, objectName, columnName);
            Status status = new Status(1, "org.teiid.designer.modelgenerator.salesforce", message);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        return resultSize;
    }

    private String createPickListString(List<String> allowedValues) {
        StringBuilder picklistValues = new StringBuilder();
        Iterator<String> iter = allowedValues.iterator();
        while (iter.hasNext()) {
            picklistValues.append(iter.next());
            if (!iter.hasNext()) continue;
            picklistValues.append(',');
        }
        return picklistValues.toString();
    }

    private void setColumnType(SalesforceField field, Column column) throws ModelBuildingException {
        DatatypeManager dtMgr = ModelerCore.getBuiltInTypesManager();
        String fieldType = field.getType();
        try {
            if (fieldType.equals("string")) {
                column.setType(dtMgr.getBuiltInDatatype("string"));
                column.setNativeType("string");
            } else if (fieldType.equals("picklist")) {
                column.setType(dtMgr.getBuiltInDatatype("string"));
                if (field.isRestrictedPicklist()) {
                    column.setNativeType("restrictedpicklist");
                } else {
                    column.setNativeType("picklist");
                }
                this.setInitialPropertyValue((EObject)column, "Picklist Values", this.createPickListString(field.getAllowedValues()));
            } else if (fieldType.equals("multipicklist")) {
                column.setType(dtMgr.getBuiltInDatatype("string"));
                if (field.isRestrictedPicklist()) {
                    column.setNativeType("restrictedmultiselectpicklist");
                } else {
                    column.setNativeType("multipicklist");
                }
                this.setInitialPropertyValue((EObject)column, "Picklist Values", this.createPickListString(field.getAllowedValues()));
            } else if (fieldType.equals("combobox")) {
                column.setType(dtMgr.getBuiltInDatatype("string"));
                column.setNativeType("combobox");
            } else if (fieldType.equals("reference")) {
                column.setType(dtMgr.getBuiltInDatatype("string"));
                column.setNativeType("id");
            } else if (fieldType.equals("base64")) {
                column.setType(dtMgr.getBuiltInDatatype("base64Binary"));
                column.setNativeType("base64");
            } else if (fieldType.equals("boolean")) {
                column.setType(dtMgr.getBuiltInDatatype("boolean"));
                column.setNativeType("boolean");
            } else if (fieldType.equals("currency")) {
                column.setType(dtMgr.getBuiltInDatatype("double"));
                column.setNativeType("currency");
                column.setCurrency(true);
                column.setScale(field.getScale());
                column.setPrecision(field.getPrecision());
            } else if (fieldType.equals("textarea")) {
                column.setType(dtMgr.getBuiltInDatatype("string"));
                column.setNativeType("textarea");
                column.setLength(field.getLength());
                column.setSearchability(SearchabilityType.UNSEARCHABLE_LITERAL);
            } else if (fieldType.equals("int")) {
                column.setType(dtMgr.getBuiltInDatatype("int"));
                column.setNativeType("int");
                column.setPrecision(field.getDigits());
            } else if (fieldType.equals("double")) {
                column.setType(dtMgr.getBuiltInDatatype("double"));
                column.setNativeType("double");
                column.setPrecision(field.getPrecision());
                column.setScale(field.getScale());
            } else if (fieldType.equals("percent")) {
                column.setType(dtMgr.getBuiltInDatatype("double"));
                column.setNativeType("percent");
                column.setPrecision(field.getPrecision());
                column.setScale(field.getScale());
            } else if (fieldType.equals("phone")) {
                column.setType(dtMgr.getBuiltInDatatype("string"));
                column.setNativeType("phone");
            } else if (fieldType.equals("id")) {
                column.setType(dtMgr.getBuiltInDatatype("string"));
                column.setNativeType("id");
            } else if (fieldType.equals("date")) {
                column.setType(dtMgr.getBuiltInDatatype("date"));
                column.setNativeType("date");
            } else if (fieldType.equals("datetime")) {
                column.setType(dtMgr.getBuiltInDatatype("dateTime"));
                column.setNativeType("datetime");
            } else if (fieldType.equals("time")) {
                column.setType(dtMgr.getBuiltInDatatype("time"));
                column.setNativeType("time");
            } else if (fieldType.equals("url")) {
                column.setType(dtMgr.getBuiltInDatatype("string"));
                column.setNativeType("url");
            } else if (fieldType.equals("email")) {
                column.setType(dtMgr.getBuiltInDatatype("string"));
                column.setNativeType("email");
            } else if (fieldType.equals("anyType")) {
                column.setType(dtMgr.getBuiltInDatatype("string"));
                column.setNativeType("anyType");
            }
        }
        catch (ModelerCoreException e) {
            ModelBuildingException ex = new ModelBuildingException(e);
            throw ex;
        }
        catch (Throwable e) {
            ModelBuildingException ex = new ModelBuildingException(e);
            throw ex;
        }
    }

    private void createRelationships() {
        Iterator iter = this.relationships.iterator();
        while (iter.hasNext() && !this.monitor.isCanceled()) {
            this.monitor.subTask(Messages.getString("RelationalModelgenerator.generating.relationships"));
            Relationship relation = (Relationship)iter.next();
            if (!this.wizardManager.isModelAuditFields() && relation.relatesToAuditField()) continue;
            ForeignKey fKey = RelationalFactory.eINSTANCE.createForeignKey();
            BaseTable parent = (BaseTable)this.tablesByName.get(relation.getParentTable());
            PrimaryKey pKey = parent.getPrimaryKey();
            if (pKey == null) {
                throw new RuntimeException("ERROR !!primary key column not found!!");
            }
            fKey.setUniqueKey((UniqueKey)pKey);
            BaseTable child = (BaseTable)this.tablesByName.get(relation.getChildTable());
            child.getForeignKeys().add((Object)fKey);
            relation.getForeignKeyField();
            EList columns = child.getColumns();
            Iterator colIter = columns.iterator();
            Column col = null;
            while (colIter.hasNext()) {
                Column c = (Column)colIter.next();
                if (!c.getNameInSource().equals(relation.getForeignKeyField())) continue;
                col = c;
                break;
            }
            if (col == null) {
                throw new RuntimeException("ERROR !!foreign key column not found!! " + child.getName() + relation.getForeignKeyField());
            }
            fKey.setName("FK_" + parent.getName() + "_" + col.getName());
            fKey.getColumns().add((Object)col);
        }
    }

    private void generateGetUpdated(Resource resource) throws ModelBuildingException {
        try {
            DatatypeManager dtMgr = ModelerCore.getBuiltInTypesManager();
            Procedure getUpdatedProc = RelationalFactory.eINSTANCE.createProcedure();
            resource.getContents().add((Object)getUpdatedProc);
            getUpdatedProc.setName("GetUpdated");
            getUpdatedProc.setNameInSource("GetUpdated");
            this.addCommonProcParams(getUpdatedProc, dtMgr);
            this.addLatestDateCoveredParam(getUpdatedProc, dtMgr);
            this.addCommonResult(getUpdatedProc, dtMgr);
        }
        catch (ModelerCoreException e) {
            ModelBuildingException ex = new ModelBuildingException(e);
            throw ex;
        }
    }

    private void generateGetDeleted(Resource resource) throws ModelBuildingException {
        try {
            DatatypeManager dtMgr = ModelerCore.getBuiltInTypesManager();
            Procedure getDeletedProc = RelationalFactory.eINSTANCE.createProcedure();
            resource.getContents().add((Object)getDeletedProc);
            getDeletedProc.setName("GetDeleted");
            getDeletedProc.setNameInSource("GetDeleted");
            this.addCommonProcParams(getDeletedProc, dtMgr);
            ProcedureParameter earliestDateAvailable = RelationalFactory.eINSTANCE.createProcedureParameter();
            getDeletedProc.getParameters().add((Object)earliestDateAvailable);
            earliestDateAvailable.setName("EarliestDateAvailable");
            earliestDateAvailable.setNameInSource("EarliestDateAvailable");
            earliestDateAvailable.setDirection(DirectionKind.OUT_LITERAL);
            earliestDateAvailable.setType(dtMgr.getBuiltInDatatype("dateTime"));
            this.addLatestDateCoveredParam(getDeletedProc, dtMgr);
            ProcedureResult result = this.addCommonResult(getDeletedProc, dtMgr);
            Column deletedDate = RelationalFactory.eINSTANCE.createColumn();
            deletedDate.setName("DeletedDate");
            deletedDate.setNameInSource("DeletedDate");
            deletedDate.setType(dtMgr.getBuiltInDatatype("dateTime"));
            result.getColumns().add((Object)deletedDate);
        }
        catch (ModelerCoreException e) {
            ModelBuildingException ex = new ModelBuildingException(e);
            throw ex;
        }
    }

    private void addCommonProcParams(Procedure proc, DatatypeManager dtMgr) throws ModelerCoreException {
        ProcedureParameter objectName = RelationalFactory.eINSTANCE.createProcedureParameter();
        proc.getParameters().add((Object)objectName);
        objectName.setName("ObjectName");
        objectName.setNameInSource("ObjectName");
        objectName.setDirection(DirectionKind.IN_LITERAL);
        objectName.setType(dtMgr.getBuiltInDatatype("string"));
        ProcedureParameter startDate = RelationalFactory.eINSTANCE.createProcedureParameter();
        proc.getParameters().add((Object)startDate);
        startDate.setName("StartDate");
        startDate.setNameInSource("StartDate");
        startDate.setDirection(DirectionKind.IN_LITERAL);
        startDate.setType(dtMgr.getBuiltInDatatype("timestamp"));
        ProcedureParameter endDate = RelationalFactory.eINSTANCE.createProcedureParameter();
        proc.getParameters().add((Object)endDate);
        endDate.setName("EndDate");
        endDate.setNameInSource("EndDate");
        endDate.setDirection(DirectionKind.IN_LITERAL);
        endDate.setType(dtMgr.getBuiltInDatatype("timestamp"));
    }

    private void addLatestDateCoveredParam(Procedure proc, DatatypeManager dtMgr) throws ModelerCoreException {
        ProcedureParameter latestDateCovered = RelationalFactory.eINSTANCE.createProcedureParameter();
        proc.getParameters().add((Object)latestDateCovered);
        latestDateCovered.setName("LatestDateCovered");
        latestDateCovered.setNameInSource("LatestDateCovered");
        latestDateCovered.setDirection(DirectionKind.OUT_LITERAL);
        latestDateCovered.setType(dtMgr.getBuiltInDatatype("dateTime"));
    }

    private ProcedureResult addCommonResult(Procedure proc, DatatypeManager dtMgr) throws ModelerCoreException {
        ProcedureResult result = RelationalFactory.eINSTANCE.createProcedureResult();
        result.setProcedure(proc);
        result.setName("Result");
        result.setNameInSource("Result");
        Column id = RelationalFactory.eINSTANCE.createColumn();
        id.setName("ID");
        id.setNameInSource("ID");
        id.setLength(18);
        id.setType(dtMgr.getBuiltInDatatype("string"));
        result.getColumns().add((Object)id);
        return result;
    }
}

