/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.salesforce;

import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.teiid.core.designer.util.StringUtilities;
import org.teiid.designer.compare.DifferenceProcessor;
import org.teiid.designer.compare.DifferenceReport;
import org.teiid.designer.compare.MergeProcessor;
import org.teiid.designer.compare.ModelerComparePlugin;
import org.teiid.designer.compare.util.CompareUtil;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.datatools.connection.DataSourceConnectionHelper;
import org.teiid.designer.extension.ExtensionPlugin;
import org.teiid.designer.extension.definition.ModelExtensionDefinition;
import org.teiid.designer.extension.definition.ModelObjectExtensionAssistant;
import org.teiid.designer.modelgenerator.salesforce.Activator;
import org.teiid.designer.modelgenerator.salesforce.Messages;
import org.teiid.designer.modelgenerator.salesforce.RelationalModelgenerator;
import org.teiid.designer.modelgenerator.salesforce.SalesforceConstants;
import org.teiid.designer.modelgenerator.salesforce.connection.SalesforceConnection;
import org.teiid.designer.modelgenerator.salesforce.model.DataModel;
import org.teiid.designer.modelgenerator.salesforce.model.impl.DataModelImpl;
import org.teiid.designer.modelgenerator.salesforce.util.ModelBuildingException;
import org.teiid.designer.modelgenerator.salesforce.util.SalesForceConnectionInfoProvider;
import org.teiid.designer.runtime.spi.ITeiidServer;

public class SalesforceImportWizardManager {
    public static final int WORKSPACE_SOURCE = 0;
    public static final int FILESYSTEM_SOURCE = 1;
    public static final int URL_SOURCE = 2;
    private DataModel dataModel;
    private IConnectionProfile connectionProfile;
    private String targetModelName;
    private IContainer targetModelLocation;
    private boolean modelAuditFields;
    private boolean credentialsValid;
    private ModelResource updateModel;
    private boolean canFinish = false;
    private DifferenceReport diffReport;
    private DifferenceProcessor diffProcessor;
    private ModelResource tempModel;
    private boolean supressCollectCardinalities;
    private boolean collectColumnDistinctValue;
    private SalesforceConnection connection;
    private boolean setNameAsNameInSource;
    private boolean generateUpdated;
    private boolean generateDeleted;
    private String jbossJndiName;
    private boolean autoCreateDataSource = true;

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public IContainer getTargetModelLocation() {
        return this.targetModelLocation;
    }

    public void setTargetModelLocation(IContainer targetModelLocation) {
        this.targetModelLocation = targetModelLocation;
    }

    public String getTargetModelName() {
        return this.targetModelName;
    }

    public void setTargetModelName(String targetModelName) {
        this.targetModelName = targetModelName;
    }

    public IConnectionProfile getConnectionProfile() {
        return this.connectionProfile;
    }

    public void setConnectionProfile(IConnectionProfile connectionProfile) {
        this.connectionProfile = connectionProfile;
    }

    public void clear() {
        this.dataModel = null;
        this.targetModelName = null;
        this.targetModelLocation = null;
    }

    public boolean validateCredentials(IProgressMonitor monitor) throws Throwable {
        monitor.beginTask(Messages.getString("SalesforceImportWizardManager.validating.credentials"), -1);
        SalesforceConnection conn = this.getConnection();
        return conn != null;
    }

    public SalesforceConnection getConnection() throws Throwable {
        if (this.connection == null) {
            try {
                IStatus status = this.connectionProfile.connect();
                if (!status.isOK()) {
                    this.connection = null;
                }
                IConnection conn = this.connectionProfile.createConnection("org.teiid.designer.datatools.salesforce.ConnectionFactory");
                this.connection = (SalesforceConnection)conn.getRawConnection();
            }
            catch (Exception e) {
                this.connection = null;
                throw e;
            }
        }
        return this.connection;
    }

    public void runFinish(IProgressMonitor monitor) throws Exception {
        if (this.diffReport != null) {
            ModelObjectExtensionAssistant assistant = (ModelObjectExtensionAssistant)ExtensionPlugin.getInstance().getRegistry().getModelExtensionAssistant(SalesforceConstants.NAMESPACE_PROVIDER.getNamespacePrefix());
            if (!assistant.supportsMyNamespace((Object)this.updateModel)) {
                ModelExtensionDefinition definition = assistant.getModelExtensionDefinition();
                if (this.updateModel != null && definition != null) {
                    assistant.saveModelExtensionDefinition((Object)this.updateModel);
                }
            }
            EObject[] externalReferences = ModelerCore.getWorkspaceDatatypeManager().getAllDatatypes();
            MergeProcessor mergeProc = ModelerComparePlugin.createMergeProcessor((DifferenceProcessor)this.diffProcessor, (EObject[])externalReferences, (boolean)true);
            mergeProc.execute(monitor);
            this.tempModel = null;
        } else {
            ModelResource modelResource = this.createModel(monitor, this.targetModelName);
            if (!monitor.isCanceled()) {
                monitor.subTask(Messages.getString("SalesforceImportWizardManager.binding"));
                SalesForceConnectionInfoProvider helper = new SalesForceConnectionInfoProvider();
                helper.setConnectionInfo(modelResource, this.connectionProfile);
                String jndiName = this.getJBossJndiName();
                if (!StringUtilities.isEmpty((String)jndiName)) {
                    helper.setJNDIName(modelResource, jndiName);
                }
                this.handleCreateDataSource(modelResource);
                try {
                    monitor.subTask(Messages.getString("SalesforceImportWizardManager.saving.model"));
                    modelResource.save(monitor, false);
                    monitor.worked(1);
                }
                catch (ModelWorkspaceException e) {
                    ModelBuildingException mbe = new ModelBuildingException();
                    mbe.initCause(e);
                    throw mbe;
                }
            }
        }
    }

    private ModelResource createModel(IProgressMonitor monitor, String modelName) throws ModelBuildingException, Exception {
        Resource resource;
        monitor.beginTask(Messages.getString("SalesforceImportWizardManager.creating.salesforce.model"), -1);
        Path path = new Path(modelName);
        IFile iFile = this.targetModelLocation.getFile((IPath)path);
        ModelResource modelResource = ModelerCore.create((IFile)iFile);
        try {
            resource = modelResource.getEmfResource();
        }
        catch (ModelWorkspaceException e) {
            throw new ModelBuildingException(e);
        }
        RelationalModelgenerator builder = new RelationalModelgenerator(this, monitor);
        builder.createRelationalModel(modelResource, resource);
        return modelResource;
    }

    public DataModel createDataModel(IProgressMonitor monitor) throws Throwable {
        if (this.dataModel == null) {
            monitor.setTaskName(Messages.getString("SalesforceImportWizardManager.connecting"));
            SalesforceConnection conn = this.getConnection();
            this.dataModel = new DataModelImpl();
            monitor.setTaskName(Messages.getString("SalesforceImportWizardManager.gathering.metadata"));
            this.dataModel.load(conn, monitor);
        }
        return this.dataModel;
    }

    public boolean isModelAuditFields() {
        return this.modelAuditFields;
    }

    public void modelAuditFields(boolean supressAuditFields) {
        this.modelAuditFields = supressAuditFields;
    }

    public void setCredentialsValid(boolean valid) {
        this.credentialsValid = valid;
    }

    public boolean hasValidCredentials() {
        return this.credentialsValid;
    }

    public DifferenceReport getDifferenceReport(IProgressMonitor monitor) throws ModelBuildingException, Exception {
        String tempName = String.valueOf(Long.toString(System.currentTimeMillis())) + "_temp.xmi";
        this.tempModel = this.createModel(monitor, tempName);
        this.diffProcessor = ModelerComparePlugin.createDifferenceProcessor((ModelResource)this.updateModel, (ModelResource)this.tempModel);
        this.diffProcessor.execute(monitor);
        this.diffReport = this.diffProcessor.getDifferenceReport();
        CompareUtil.skipDeletesOfStandardContainers((DifferenceReport)this.diffReport);
        return this.diffReport;
    }

    public void setUpdatedModel(ModelResource model) {
        this.updateModel = model;
    }

    public boolean canFinish() {
        return this.canFinish;
    }

    public void setCanFinish(boolean canFinish) {
        this.canFinish = canFinish;
    }

    public void supressCollectCardinalities(boolean selection) {
        this.supressCollectCardinalities = selection;
    }

    boolean getSupressCollectCardinalities() {
        return this.supressCollectCardinalities;
    }

    public void setCollectColumnDistinctValue(boolean selection) {
        this.collectColumnDistinctValue = selection;
    }

    public void setNameAsLabel(boolean selection) {
        this.setNameAsNameInSource = selection;
    }

    public boolean isSetNameAsLabel() {
        return this.setNameAsNameInSource;
    }

    public void setSetNameAsNameInSource(boolean setNameAsNameInSource) {
        this.setNameAsNameInSource = setNameAsNameInSource;
    }

    public boolean isCollectColumnDistinctValue() {
        return this.collectColumnDistinctValue;
    }

    public void setGenerateUpdated(boolean selection) {
        this.generateUpdated = selection;
    }

    public boolean isGenerateUpdated() {
        return this.generateUpdated;
    }

    public void setGenerateDeleted(boolean selection) {
        this.generateDeleted = selection;
    }

    public boolean isGenerateDeleted() {
        return this.generateDeleted;
    }

    public String getJBossJndiName() {
        return this.jbossJndiName;
    }

    public void setJBossJndiNameName(String jndiName) {
        this.jbossJndiName = jndiName;
    }

    public boolean doCreateDataSource() {
        return this.autoCreateDataSource;
    }

    public void setCreateDataSource(boolean value) {
        this.autoCreateDataSource = value;
    }

    protected void handleCreateDataSource(ModelResource model) {
        if (this.doCreateDataSource() && DataSourceConnectionHelper.isServerConnected()) {
            ITeiidServer teiidServer = DataSourceConnectionHelper.getServer();
            String dsName = this.getJBossJndiName();
            String jndiName = this.getJBossJndiName();
            DataSourceConnectionHelper helper = new DataSourceConnectionHelper(model, this.getConnectionProfile());
            Properties connProps = helper.getModelConnectionProperties();
            String dsType = helper.getDataSourceType();
            try {
                teiidServer.getOrCreateDataSource(dsName, jndiName, dsType, connProps);
            }
            catch (Exception e) {
                Status status = new Status(4, "org.teiid.designer.modelgenerator.salesforce", e.getMessage());
                Activator.getDefault().getLog().log((IStatus)status);
            }
        }
    }
}

