/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.salesforce.datatools;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnection;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.designer.modelgenerator.salesforce.connection.impl.Connection;

public class SalesforceDatatoolsConnection
implements IConnection {
    private IConnectionProfile savedProfile;
    private Connection connection;
    private Throwable connectException;
    private final String DEFAULT_SF_URL = "https://login.salesforce.com/services/Soap/u/22.0";

    public SalesforceDatatoolsConnection(IConnectionProfile profile) {
        this.savedProfile = profile;
        if (this.connection == null) {
            this.connection = new Connection();
            try {
                Properties props = profile.getBaseProperties();
                String username = props.getProperty("username");
                String password = props.getProperty("password");
                URL connectionURL = null;
                try {
                    connectionURL = this.getURL(props);
                }
                catch (MalformedURLException e) {
                    this.connectException = e;
                    this.connection = null;
                    return;
                }
                this.connection.login(username, password, connectionURL);
            }
            catch (Exception e) {
                this.connectException = e;
                this.connection = null;
            }
        }
    }

    public SalesforceDatatoolsConnection(IConnectionProfile profile, String uid, String pwd) {
        this.savedProfile = profile;
        if (this.connection == null) {
            this.connection = new Connection();
            try {
                Properties props = profile.getBaseProperties();
                URL connectionURL = null;
                try {
                    connectionURL = this.getURL(props);
                }
                catch (MalformedURLException e) {
                    this.connectException = e;
                    this.connection = null;
                    return;
                }
                this.connection.login(uid, pwd, connectionURL);
            }
            catch (Exception e) {
                this.connectException = e;
                this.connection = null;
            }
        }
    }

    private URL getURL(Properties props) throws MalformedURLException {
        String stringUrl = props.getProperty("url");
        if (stringUrl == null || stringUrl.trim().length() == 0) {
            stringUrl = "https://login.salesforce.com/services/Soap/u/22.0";
        }
        return new URL(stringUrl);
    }

    public void close() {
        this.connection = null;
    }

    public Throwable getConnectException() {
        return this.connectException;
    }

    public IConnectionProfile getConnectionProfile() {
        return this.savedProfile;
    }

    public Object getRawConnection() {
        return this.connection;
    }
}

