/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.salesforce.model.impl;

import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeGlobalSObjectResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Soap;
import com.sforce.soap.partner.UnexpectedErrorFault;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.teiid.designer.modelgenerator.salesforce.connection.SalesforceConnection;
import org.teiid.designer.modelgenerator.salesforce.model.DataModel;
import org.teiid.designer.modelgenerator.salesforce.model.SalesforceObject;
import org.teiid.designer.modelgenerator.salesforce.model.impl.Messages;
import org.teiid.designer.modelgenerator.salesforce.model.impl.SalesforceObjectImpl;

public class DataModelImpl
implements DataModel {
    Integer maxBatchSize;
    String encoding;
    private Map<String, SalesforceObject> salesforceObjects = new TreeMap<String, SalesforceObject>();
    private int selectedCount = 0;

    @Override
    public void load(SalesforceConnection conn, IProgressMonitor monitor) throws Exception {
        DescribeGlobalResult describeGlobalResult;
        monitor.beginTask(Messages.getString("DataModelImpl.gathering.metadata"), -1);
        Soap binding = conn.getBinding();
        try {
            describeGlobalResult = binding.describeGlobal();
        }
        catch (UnexpectedErrorFault e) {
            Exception ce = new Exception(e.getCause().getMessage());
            ce.initCause(e.getCause());
            throw ce;
        }
        List sObjects = describeGlobalResult.getSobjects();
        String[] types = new String[sObjects.size()];
        int i = 0;
        while (i < sObjects.size()) {
            types[i] = ((DescribeGlobalSObjectResult)sObjects.get(i)).getName();
            ++i;
        }
        i = 0;
        while (i < types.length) {
            List describeSObjectResults;
            int arrayLength = i + 100 > types.length ? types.length - i : 100;
            ArrayList<String> typesBatch = new ArrayList<String>(arrayLength);
            int j = 0;
            while (j < arrayLength) {
                typesBatch.add(types[i + j]);
                ++j;
            }
            try {
                describeSObjectResults = binding.describeSObjects(typesBatch);
            }
            catch (Exception e) {
                Exception ce = new Exception(e.getCause().getMessage());
                ce.initCause(e.getCause());
                throw ce;
            }
            int x = 0;
            while (x < describeSObjectResults.size()) {
                DescribeSObjectResult describeSObjectResult = (DescribeSObjectResult)describeSObjectResults.get(x);
                SalesforceObjectImpl object = new SalesforceObjectImpl();
                monitor.subTask(String.valueOf(Messages.getString("DataModelImpl.gathering.metadata.table")) + describeSObjectResult.getLabel());
                object.setObjectMetadata(describeSObjectResult, this);
                this.addSalesforceObject((String)typesBatch.get(x), object);
                monitor.worked(1);
                ++x;
            }
            i += arrayLength;
        }
    }

    public Integer getMaxBatchSize() {
        return this.maxBatchSize;
    }

    public void setMaxBatchSize(Integer maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void addSalesforceObject(String objectName, SalesforceObject sObject) throws Exception {
        SalesforceObject result = this.salesforceObjects.put(objectName, sObject);
        if (result != null) {
            throw new Exception(String.valueOf(Messages.getString("DataModelImpl.duplicate.found")) + objectName);
        }
    }

    @Override
    public Object[] getSalesforceObjects() {
        return this.salesforceObjects.values().toArray();
    }

    @Override
    public SalesforceObject getSalesforceObject(String name) {
        return this.salesforceObjects.get(name);
    }

    @Override
    public boolean hasSelectedObjects() {
        return this.selectedCount > 0;
    }

    @Override
    public void incrementSelectionCount() {
        ++this.selectedCount;
    }

    @Override
    public void decrementSelectionCount() {
        --this.selectedCount;
    }
}

