/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.modelgenerator.salesforce.util;

import java.util.Properties;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.teiid.designer.core.ModelerCore;
import org.teiid.designer.core.workspace.ModelResource;
import org.teiid.designer.core.workspace.ModelWorkspaceException;
import org.teiid.designer.datatools.connection.ConnectionInfoHelper;
import org.teiid.designer.datatools.connection.IConnectionInfoProvider;
import org.teiid.designer.type.IDataTypeManagerService;

public class SalesForceConnectionInfoProvider
extends ConnectionInfoHelper
implements IConnectionInfoProvider {
    public static final String SALESFORCE_DATASOURCE_URL = "URL";
    public static final String SALESFORCE_DATASOURCE_USERNAME = "username";
    public static final String SALESFORCE_DATASOURCE_PASSWORD = "password";
    public static final String SALESFORCE_TRANSLATOR_NAME = "salesforce";
    public static final String SALESFORCE_TRANSLATOR_TYPE = "salesforce";
    public static final String SALESFORCE_PASSWORD_KEY = "password";
    public static final String SALESFORCE_CLASSNAME_KEY = "class-name";
    public static final String SALESFORCE_CLASSNAME = "class-name";
    public static final String SALESFORCE_CONNECTION_FACTORY = "org.teiid.resource.adapter.salesforce.SalesForceManagedConnectionFactory";

    public void setConnectionInfo(ModelResource modelResource, IConnectionProfile connectionProfile) throws ModelWorkspaceException {
        Properties connectionProps = this.getCommonProfileProperties(connectionProfile);
        Properties props = connectionProfile.getBaseProperties();
        String url = props.getProperty("url");
        if (url != null) {
            connectionProps.setProperty("connection:URL", url);
        }
        String username = props.getProperty(SALESFORCE_DATASOURCE_USERNAME);
        connectionProps.setProperty("connection:username", username);
        this.getHelper().removeProperties(modelResource, "connectionProfile:");
        this.getHelper().removeProperties(modelResource, "translator:");
        this.getHelper().removeProperties(modelResource, "connection:");
        connectionProps.put("translator:name", "salesforce");
        this.getHelper().setProperties(modelResource, connectionProps);
    }

    public Properties getTeiidRelatedProperties(IConnectionProfile connectionProfile) {
        String password;
        String username;
        Properties connectionProps = new Properties();
        Properties props = connectionProfile.getBaseProperties();
        String url = props.getProperty("url");
        if (url == null) {
            url = props.getProperty(SALESFORCE_DATASOURCE_URL);
        }
        if (url != null) {
            connectionProps.setProperty(SALESFORCE_DATASOURCE_URL, url);
        }
        if ((username = props.getProperty(SALESFORCE_DATASOURCE_USERNAME)) != null) {
            connectionProps.setProperty(SALESFORCE_DATASOURCE_USERNAME, username);
        }
        if ((password = props.getProperty("password")) != null) {
            connectionProps.setProperty("password", password);
        }
        connectionProps.setProperty("class-name", SALESFORCE_CONNECTION_FACTORY);
        return connectionProps;
    }

    public String getPasswordPropertyKey() {
        return "password";
    }

    public String getDataSourcePasswordPropertyKey() {
        return "password";
    }

    public String getDataSourceType() {
        return ModelerCore.getTeiidDataTypeManagerService().getDataSourceType(IDataTypeManagerService.DataSourceTypes.SALESFORCE);
    }

    public boolean requiresPassword(IConnectionProfile connectionProfile) {
        return true;
    }
}

