/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.datatools.connectivity.ui;

import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.services.ExecutionService;
import org.eclipse.datatools.sqltools.core.services.SQLService;
import org.teiid.datatools.connectivity.ui.TeiidExecutionService;

public class TeiidDBConfiguration
extends SQLDevToolsConfiguration {
    static final String[] TERMINATORS = new String[]{";"};
    private static final String[] PRODUCTS = new String[]{"Teiid Server", "Teiid"};

    private String format(String in) {
        return in.trim().toLowerCase();
    }

    public boolean recognize(String product, String version) {
        if (product != null) {
            String formattedProduct = this.format(product);
            int i = 0;
            while (i < PRODUCTS.length) {
                if (formattedProduct.equals(this.format(PRODUCTS[i]))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String[] getAssociatedConnectionProfileType() {
        return new String[]{"org.teiid.datatools.connectivity.connectionProfile"};
    }

    public ExecutionService getExecutionService() {
        return new TeiidExecutionService();
    }

    public SQLService getSQLService() {
        return new SQLService(){

            public String[] splitSQL(String sql) {
                if (sql.indexOf(59) < 0) {
                    return new String[]{sql};
                }
                return this.splitSQLByTerminatorLine(sql, TERMINATORS);
            }

            public String[] splitSQL(String sql, boolean splitByDefault) {
                if (splitByDefault) {
                    return this.splitSQL(sql);
                }
                return new String[]{sql};
            }
        };
    }
}

