/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.datatools.connectivity.ui.plan;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;
import org.teiid.datatools.connectivity.ui.Activator;

public class ExecutionPlanConverter {
    public static final String TEMP_DIRECTORY = System.getProperty("java.io.tmpdir");
    public static final String NO_EXECUTION_PLAN_HTML = "<html><body><div style=\"text-align:center; font-weight:bold; margin-top:4em;\">No Execution Plan Available</div></body></html>";
    private static final String EXECUTION_PLAN_DATA_HOME = "ExecPlanData";
    private static final String EXECUTION_PLAN_XSLT = "ExecPlanData" + File.separator + "qp.xslt";
    private static final String EXECUTION_PLAN_DATA_ZIP = "ExecPlanData" + File.separator + "exec-plan-data.zip";
    private static final String HTML_PREFIX = "execution-plan";
    private static final String HTML_SUFFIX = ".html";
    private Bundle bundle = Activator.getDefault().getBundle();
    private File planDestination = null;

    private void unzipData(File destination) throws IOException, FileNotFoundException {
        byte[] buffer = new byte[1024];
        ZipInputStream zis = new ZipInputStream(FileLocator.openStream((Bundle)this.bundle, (IPath)new Path(EXECUTION_PLAN_DATA_ZIP), (boolean)true));
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            String fileName = ze.getName();
            File newFile = new File(destination, fileName);
            new File(newFile.getParent()).mkdirs();
            if (ze.isDirectory()) {
                newFile.mkdirs();
            } else {
                int len;
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
            }
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }

    private File getDestination() throws Exception {
        if (this.planDestination != null) {
            return this.planDestination;
        }
        this.planDestination = new File(TEMP_DIRECTORY, "execution-plans");
        if (!this.planDestination.exists() && !this.planDestination.mkdir()) {
            throw new Exception();
        }
        this.unzipData(this.planDestination);
        return this.planDestination;
    }

    private String createOutFileName() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
        String dateStr = sdf.format(cal.getTime());
        return HTML_PREFIX + dateStr + HTML_SUFFIX;
    }

    public String convert(String execPlan) throws Exception {
        try (InputStream xslStream = null;){
            xslStream = FileLocator.openStream((Bundle)this.bundle, (IPath)new Path(EXECUTION_PLAN_XSLT), (boolean)true);
            TransformerFactoryImpl factory = new TransformerFactoryImpl();
            StreamSource xslSource = new StreamSource(xslStream);
            ByteArrayInputStream execPlanStream = new ByteArrayInputStream(execPlan.getBytes("UTF-8"));
            File destination = this.getDestination();
            File outHTMLPlan = new File(destination, this.createOutFileName());
            StreamSource in = new StreamSource(execPlanStream);
            StreamResult out = new StreamResult(outHTMLPlan);
            Transformer transformer = factory.newTransformer((Source)xslSource);
            transformer.transform(in, out);
            String string = outHTMLPlan.getAbsolutePath();
            return string;
        }
    }
}

