/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.datatools.connectivity.ui.plan;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.services.ConnectionService;
import org.eclipse.datatools.sqltools.sql.parser.ParsingResult;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.plan.BaseExplainAction;
import org.eclipse.datatools.sqltools.sqleditor.plan.Images;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;
import org.teiid.datatools.connectivity.ui.Activator;
import org.teiid.datatools.connectivity.ui.Messages;
import org.teiid.datatools.views.ExecutionPlanView;

public class TeiidExplainSQLActionDelegate
extends BaseExplainAction
implements IEditorActionDelegate,
ISelectionChangedListener,
IUpdate {
    protected SQLEditor _sqlEditor;

    public TeiidExplainSQLActionDelegate() {
        String title = Messages.getString("TeiidExplainSQLActionDelegate.title");
        String tooltip = Messages.getString("TeiidExplainSQLActionDelegate.tooltip");
        this.setText(title);
        this.setToolTipText(tooltip);
        this.setImageDescriptor(Images.DESC_EXPLAIN_SQL);
        this.setActionDefinitionId("org.eclipse.datatools.sqltools.sqleditor.ExplainSQLAction");
    }

    public void setActiveEditor(SQLEditor targetEditor) {
        this._sqlEditor = targetEditor;
        targetEditor.getSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this);
        this.update();
    }

    public void update() {
        String sql = this.getSQLStatements();
        this.setEnabled(this._sqlEditor != null && this._sqlEditor.isConnected() && super.canBeEnabled() && sql != null && sql.length() > 0);
    }

    public DatabaseIdentifier getDatabaseIdentifier() {
        return this._sqlEditor == null ? null : this._sqlEditor.getDatabaseIdentifier();
    }

    public String getSQLStatements() {
        if (this._sqlEditor == null) {
            return null;
        }
        String selectedSQL = this._sqlEditor.getSelectedText();
        if (selectedSQL != null && !selectedSQL.isEmpty()) {
            return SQLToolsFacade.getDBHelper((DatabaseIdentifier)this.getDatabaseIdentifier()).preprocessSQLScript(selectedSQL);
        }
        return this.getCurrentStatements();
    }

    private String getCurrentStatements() {
        String selectedText = null;
        IDocument doc = this._sqlEditor.getDocumentProvider().getDocument((Object)this._sqlEditor.getEditorInput());
        ITextSelection selection = (ITextSelection)this._sqlEditor.getSelectionProvider().getSelection();
        int selectionLine = selection.getStartLine();
        try {
            IRegion lineInfo = doc.getLineInformation(selectionLine);
            selectedText = doc.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
        return SQLToolsFacade.getDBHelper((DatabaseIdentifier)this.getDatabaseIdentifier()).preprocessSQLScript(selectedText);
    }

    public Runnable getPostRun() {
        Runnable postRun = new Runnable(){

            @Override
            public void run() {
                TeiidExplainSQLActionDelegate.this._sqlEditor.getEditorSite().getPage().activate((IWorkbenchPart)TeiidExplainSQLActionDelegate.this._sqlEditor);
            }
        };
        return postRun;
    }

    protected HashMap getVariableDeclarations() {
        ITextSelection _selection = (ITextSelection)this._sqlEditor.getSelectionProvider().getSelection();
        int start = 0;
        int length = 0;
        if (_selection == null) {
            _selection = (ITextSelection)this._sqlEditor.getSelectionProvider().getSelection();
        }
        if (_selection != null && !_selection.isEmpty()) {
            start = _selection.getOffset();
            length = _selection.getLength();
            if (length < 0) {
                length = -length;
                start -= length;
            }
        }
        int offset = length > 0 ? start + 1 : start;
        IDocument document = this._sqlEditor.getDocumentProvider().getDocument((Object)this._sqlEditor.getEditorInput());
        ParsingResult result = this._sqlEditor.getParsingResult();
        HashMap variables = new HashMap();
        if (result != null) {
            variables = result.getVariables(document, offset);
            HashMap sp_params = result.getParameters(document, offset);
            variables.putAll(sp_params);
        }
        return variables;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (event.getSelection() instanceof ITextSelection) {
            this.update();
        }
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.setActiveEditor((SQLEditor)targetEditor);
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        String sql = this.getSQLStatements();
        this.establishConnection();
        String planStr = null;
        try {
            planStr = this.getExecutionPlan(this._conn, sql);
        }
        catch (SQLException e1) {
            String message = Messages.getString("TeiidExplainSQLActionDelegate.getPlanError");
            Status status = new Status(4, "org.teiid.datatools.connectivity.ui", message, (Throwable)e1);
            Activator.getDefault().getLog().log((IStatus)status);
            Shell shell = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openInformation((Shell)shell, (String)Messages.getString("TeiidExplainSQLActionDelegate.getPlanErrorDialog.title"), (String)Messages.getString("TeiidExplainSQLActionDelegate.getPlanErrorDialog.msg"));
            this.handleEnd(this._conn);
        }
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IViewPart viewPart = null;
        try {
            if (window != null && (viewPart = window.getActivePage().showView("views.executionPlanView")) instanceof ExecutionPlanView) {
                String panelDescription = Messages.getString("TeiidExplainSQLActionDelegate.panelDescription");
                ((ExecutionPlanView)viewPart).updateContents(panelDescription, sql, planStr);
            }
        }
        catch (PartInitException e) {
            String message = Messages.getString("TeiidExplainSQLActionDelegate.initViewError");
            Status status = new Status(4, "org.teiid.datatools.connectivity.ui", message, (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
        }
        this.handleEnd(this._conn);
    }

    private void establishConnection() {
        if (this._conn == null) {
            String profileName = this._sqlEditor.getDatabaseIdentifier().getProfileName();
            String dbName = this._sqlEditor.getDatabaseIdentifier().getDBname();
            SQLDevToolsConfiguration config = SQLToolsFacade.getConfigurationByProfileName((String)profileName);
            ConnectionService conService = config.getConnectionService();
            this._conn = conService.createConnection(profileName, dbName);
        }
    }

    private String getExecutionPlan(Connection sqlConnection, String sql) throws SQLException {
        String executionPlan = null;
        if (sql == null || sql.length() == 0) {
            throw new SQLException("An SQL statement is required to retrieve the execution plan");
        }
        Statement stmt = sqlConnection.createStatement();
        stmt.execute("SET NOEXEC ON");
        stmt.execute("SET SHOWPLAN DEBUG");
        stmt.executeQuery(sql);
        ResultSet planRs = stmt.executeQuery("SHOW PLAN");
        planRs.next();
        executionPlan = planRs.getString("PLAN_XML");
        stmt.execute("SET NOEXEC OFF");
        return executionPlan;
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection instanceof ITextSelection) {
            this.update();
        }
    }
}

