/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.schema.tools.model.schema.impl;

import org.eclipse.xsd.XSDAttributeDeclaration;
import org.teiid.designer.schema.tools.model.jdbc.internal.ColumnImpl;
import org.teiid.designer.schema.tools.model.schema.Column;
import org.teiid.designer.schema.tools.model.schema.impl.BaseColumn;

public class AttributeColumn
extends BaseColumn {
    private XSDAttributeDeclaration attr;
    private String prefix;

    public AttributeColumn(XSDAttributeDeclaration attr, String prefix, boolean pk) {
        super(pk, attr.getTypeDefinition());
        this.attr = attr;
        this.prefix = prefix;
    }

    @Override
    public String getXpath() {
        String name = this.attr.getName();
        String xpath = this.prefix != null && !this.prefix.equals("") ? "@" + this.prefix + ':' + name : "@" + name;
        return xpath;
    }

    @Override
    public String getSimpleName() {
        String name = this.attr.getName();
        return name;
    }

    @Override
    public Column copy() {
        return new AttributeColumn(this.attr, this.prefix, super.isPrimaryKey());
    }

    @Override
    public void printDebug() {
        StringBuffer buff = new StringBuffer("\t \t");
        buff.append("Attribute Column:");
        buff.append("SimpleName = " + this.getSimpleName());
        buff.append(" ");
        buff.append("Xpath = " + this.getXpath());
        buff.append(" ");
        buff.append("prefix = " + this.prefix);
        System.out.println(buff.toString());
    }

    @Override
    public org.teiid.designer.schema.tools.model.jdbc.Column getColumnImplementation() {
        ColumnImpl newColumn = new ColumnImpl();
        newColumn.setDataAttributeName(this.getSimpleName());
        newColumn.setDataType(this.getDataType());
        newColumn.setIsAttributeOfParent(true);
        newColumn.setIsInputParameter(false);
        newColumn.setName(this.getSimpleName());
        newColumn.setOutputXPath(this.getXpath());
        return newColumn;
    }
}

