/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.schema.tools.model.schema.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.designer.schema.tools.ToolsPlugin;
import org.teiid.designer.schema.tools.model.schema.ISchemaModelCopyTraversalContext;
import org.teiid.designer.schema.tools.model.schema.SchemaObject;
import org.teiid.designer.schema.tools.model.schema.impl.BaseSchemaObject;

public class SchemaModelCopyTraversalContext
implements ISchemaModelCopyTraversalContext {
    private Map copiedElements = new HashMap();
    private List resultElements;
    private Set resultRoots;
    private List originalElements;

    public SchemaModelCopyTraversalContext(List schemaElements, Set roots) {
        this.originalElements = schemaElements;
        this.resultElements = new ArrayList(this.originalElements.size());
        this.process();
        this.resultRoots = roots != null ? new HashSet(roots) : new HashSet();
    }

    private void process() {
        SchemaObject copy;
        for (SchemaObject original : this.originalElements) {
            copy = original.copy(this);
            this.copiedElements.put(original, copy);
            this.resultElements.add(copy);
        }
        int i = 0;
        while (i < this.originalElements.size()) {
            SchemaObject original;
            original = (SchemaObject)this.originalElements.get(i);
            copy = (SchemaObject)this.resultElements.get(i);
            ((BaseSchemaObject)original).copy((BaseSchemaObject)copy, this);
            ++i;
        }
    }

    public void addElement(SchemaObject element, SchemaObject copy) {
        if (!this.copiedElements.containsKey(element)) {
            this.copiedElements.put(element, copy);
            this.resultElements.add(copy);
        }
    }

    public SchemaObject getElement(SchemaObject element) {
        if (!this.copiedElements.containsKey(element)) {
            throw new RuntimeException(ToolsPlugin.Util.getString("SchemaModelCopyTraversalContext.copiedElementNotFound", new Object[0]));
        }
        SchemaObject copy = (SchemaObject)this.copiedElements.get(element);
        return copy;
    }

    public List getCopiedElements() {
        if (this.resultElements.size() != this.originalElements.size()) {
            throw new RuntimeException(ToolsPlugin.Util.getString("SchemaModelCopyTraversalContext.invalidCopiedElementTotal", new Object[0]));
        }
        return this.resultElements;
    }

    public Set getCopiedRoots() {
        return this.resultRoots;
    }
}

