/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.designer.schema.tools.processing.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.designer.schema.tools.model.schema.Column;
import org.teiid.designer.schema.tools.model.schema.Relationship;
import org.teiid.designer.schema.tools.model.schema.SchemaModel;
import org.teiid.designer.schema.tools.model.schema.SchemaObject;
import org.teiid.designer.schema.tools.processing.RelationshipProcessor;
import org.teiid.designer.schema.tools.processing.RelationshipRules;

public abstract class BaseRelationshipProcessor
implements RelationshipProcessor {
    RelationshipRules rules;
    protected Map tableRelationships = new HashMap();
    protected SchemaModel schemaModel;

    protected void setSechemaModel(SchemaModel model) {
        this.schemaModel = model;
    }

    @Override
    public void addRelationship(String key, Integer value) {
        this.tableRelationships.put(key, value);
    }

    @Override
    public void setRelationshipRules(RelationshipRules rules) {
        this.rules = rules;
    }

    protected int calculateCValue(List parents) {
        int C_value = -3;
        for (Object o : parents) {
            Relationship tableRelationship = (Relationship)o;
            int maxOccursThisLoop = tableRelationship.getMaxOccurs();
            if (C_value == -3) {
                C_value = maxOccursThisLoop;
                continue;
            }
            if (C_value == maxOccursThisLoop) continue;
            C_value = -2;
            break;
        }
        return C_value;
    }

    protected void removeRecursiveMerges(List elements) {
        for (SchemaObject element : elements) {
            LinkedList fullPath = new LinkedList();
            LinkedList mergedPath = new LinkedList();
            this.removeRecursiveMergesForTable(element, fullPath, mergedPath);
        }
    }

    protected void removeRecursiveMergesForTable(SchemaObject element, LinkedList fullPath, LinkedList mergedPath) {
        fullPath.addLast(element);
        mergedPath.addLast(element);
        for (Object o : element.getChildren()) {
            Relationship tableRelationship = (Relationship)o;
            SchemaObject child = tableRelationship.getChild();
            String key = String.valueOf(child.getSimpleName()) + ':' + child.getNamespace();
            Integer relation = (Integer)this.tableRelationships.get(key);
            int representation = relation;
            LinkedList<SchemaObject> mergedPathParam = mergedPath;
            if (representation == 2 || representation == 3) {
                if (mergedPath.contains(child)) {
                    if (representation == 2) {
                        representation = 0;
                    } else if (representation == 3) {
                        representation = 1;
                    }
                    SchemaObject parent = tableRelationship.getParent();
                    parent.setAllParentRepresentations(representation, this);
                    mergedPathParam = new LinkedList();
                }
            } else {
                mergedPathParam = new LinkedList<SchemaObject>();
                continue;
            }
            if (fullPath.contains(child)) continue;
            this.removeRecursiveMergesForTable(child, fullPath, mergedPathParam);
            mergedPath.removeLast();
            fullPath.removeLast();
        }
    }

    protected void qualifyDuplicateMergedTableNames() {
        ArrayList processedTables = new ArrayList();
        for (Object o : this.schemaModel.getElements()) {
            SchemaObject table = (SchemaObject)o;
            this.qualifyDuplicateMergedChildTableNames(table, processedTables);
        }
    }

    protected void qualifyDuplicateMergedChildTableNames(SchemaObject table, List processedTables) {
        if (processedTables.contains(table)) {
            return;
        }
        processedTables.add(table);
        List children = table.getChildren();
        for (Object oTableRelationship : children) {
            Relationship tableRelationship = (Relationship)oTableRelationship;
            this.qualifyDuplicateMergedChildTableNames(tableRelationship.getChild(), processedTables);
        }
        this.checkForDuplicateMergedChildNames(children);
    }

    protected void checkForDuplicateMergedChildNames(List tableRelationships) {
        HashMap<String, SchemaObject> tablesByName = new HashMap<String, SchemaObject>();
        for (Object o : tableRelationships) {
            Relationship tableRelationship = (Relationship)o;
            int representation = tableRelationship.getType();
            if (representation != 2 && representation != 3) continue;
            SchemaObject table = tableRelationship.getChild();
            String name = table.getSimpleName();
            Object oExisting = tablesByName.get(name);
            if (oExisting == null) {
                tablesByName.put(name, table);
                continue;
            }
            SchemaObject existing = (SchemaObject)oExisting;
            existing.setMustBeQualified();
            table.setMustBeQualified();
        }
    }

    protected void mergeRelationships() {
        ArrayList processedTables = new ArrayList();
        for (Object o : this.schemaModel.getElements()) {
            SchemaObject element = (SchemaObject)o;
            if (!this.schemaModel.isSelectedRootElement(element)) continue;
            this.mergeChildRelationships(element, processedTables);
        }
    }

    protected void mergeChildRelationships(SchemaObject table, List processedTables) {
        if (processedTables.contains(table)) {
            return;
        }
        processedTables.add(table);
        table.setWithinSelectedHierarchy(true);
        Object[] children = table.getChildren().toArray();
        int i = 0;
        while (i < children.length) {
            int representation;
            Object relObject = children[i];
            Relationship tableRelationship = (Relationship)relObject;
            SchemaObject child = tableRelationship.getChild();
            this.mergeChildRelationships(child, processedTables);
            String key = String.valueOf(child.getSimpleName()) + ':' + child.getNamespace();
            if (this.tableRelationships.get(key) != null && ((representation = ((Integer)this.tableRelationships.get(key)).intValue()) == 2 || representation == 3)) {
                this.mergeChild(table, tableRelationship);
                tableRelationship.removeRelationship();
            }
            ++i;
        }
    }

    protected void mergeChild(SchemaObject parent, Relationship tableRelationship) {
        SchemaObject child = tableRelationship.getChild();
        child.setWithinSelectedHierarchy(false);
        Object[] cols = child.getAttributes().toArray();
        int i = 0;
        while (i < cols.length) {
            Column col = (Column)cols[i];
            int maxOccurs = tableRelationship.getMaxOccurs();
            int iOccurrence = 1;
            while (iOccurrence <= maxOccurs) {
                int iOccurenceParam = maxOccurs > 1 ? iOccurrence : -1;
                col.mergeIntoParent(tableRelationship, iOccurenceParam);
                ++iOccurrence;
            }
            ++i;
        }
        this.pullUpGrandChildRelationships(child.getParents(), child.getChildren());
    }

    protected void pullUpGrandChildRelationships(List parentRelationships, List grandChildren) {
        ArrayList<Relationship> newRelationships = new ArrayList<Relationship>();
        ArrayList<Relationship> foldedRelationships = new ArrayList<Relationship>();
        for (Object e : grandChildren) {
            Relationship grandChild = (Relationship)e;
            for (Relationship tableRelationship : parentRelationships) {
                Relationship mergedRelationship = tableRelationship.merge(grandChild);
                newRelationships.add(mergedRelationship);
                foldedRelationships.add(grandChild);
            }
        }
        for (Object e : foldedRelationships) {
            Relationship foldedRelationship = (Relationship)e;
            foldedRelationship.removeRelationship();
        }
        for (Object e : newRelationships) {
            Relationship newRelationship = (Relationship)e;
            newRelationship.addNewRelationship();
        }
    }

    protected void removeFullyMergedTables() {
        ArrayList<SchemaObject> nonMergedTables = new ArrayList<SchemaObject>();
        for (Object o : this.schemaModel.getElements()) {
            SchemaObject table = (SchemaObject)o;
            if (!table.isWithinSelectedHierarchy()) continue;
            nonMergedTables.add(table);
        }
        this.schemaModel.setElements(nonMergedTables);
    }

    protected void qualifyDuplicateNonMergedTableNames() {
        HashMap<String, SchemaObject> tablesByName = new HashMap<String, SchemaObject>();
        for (Object o : this.schemaModel.getElements()) {
            SchemaObject table = (SchemaObject)o;
            String name = table.getSimpleName();
            Object oExisting = tablesByName.get(name);
            if (oExisting == null) {
                tablesByName.put(name, table);
                continue;
            }
            SchemaObject existing = (SchemaObject)oExisting;
            existing.setMustBeQualified();
            table.setMustBeQualified();
        }
    }
}

